/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.jackson.jsh;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.github.skjolber.jackson.jsh.JsonStreamContextListener;
import com.github.skjolber.jackson.jsh.SyntaxHighlighter;
import com.github.skjolber.jackson.jsh.SyntaxHighlighterIndenter;
import java.io.IOException;

public class SyntaxHighlightingPrettyPrinter
extends DefaultPrettyPrinter {
    private static final long serialVersionUID = 1L;
    protected SyntaxHighlighter syntaxHighlighter;
    protected SyntaxHighlighterIndenter objectIndenter;
    protected SyntaxHighlighterIndenter arrayIndenter;
    protected JsonStreamContextListener listener;
    private String valueColor;
    private String commaColor;

    public SyntaxHighlightingPrettyPrinter(SyntaxHighlighter syntaxHighlighter, SyntaxHighlighterIndenter objectIndenter, SyntaxHighlighterIndenter arrayIndenter, JsonStreamContextListener listener) {
        this.syntaxHighlighter = syntaxHighlighter;
        this._objectIndenter = objectIndenter;
        this._arrayIndenter = arrayIndenter;
        this.objectIndenter = objectIndenter;
        this.arrayIndenter = arrayIndenter;
        this.listener = listener;
    }

    public void writeRootValueSeparator(JsonGenerator gen) throws IOException {
        gen.writeRaw("\u001b[0m");
        super.writeRootValueSeparator(gen);
    }

    public void writeStartObject(JsonGenerator gen) throws IOException {
        gen.writeRaw(this.syntaxHighlighter.forCurlyBrackets());
        super.writeStartObject(gen);
        if (this.listener != null) {
            this.listener.startObject(gen.getOutputContext());
        }
    }

    public void writeEndObject(JsonGenerator gen, int nrOfEntries) throws IOException {
        if (this.listener != null) {
            this.listener.endObject(gen.getOutputContext().getParent());
        }
        String color = this.syntaxHighlighter.forCurlyBrackets();
        gen.writeRaw(color);
        this.objectIndenter.setValueColor(color);
        super.writeEndObject(gen, nrOfEntries);
        this.objectIndenter.clearValueColor();
    }

    public void writeObjectEntrySeparator(JsonGenerator gen) throws IOException {
        gen.writeRaw(this.commaColor);
        super.writeObjectEntrySeparator(gen);
    }

    public void writeObjectFieldValueSeparator(JsonGenerator gen) throws IOException {
        if (this._spacesInObjectEntries) {
            gen.writeRaw(this.syntaxHighlighter.forWhitespace());
            gen.writeRaw(' ');
            gen.writeRaw(this.syntaxHighlighter.forColon());
            gen.writeRaw(this._separators.getObjectFieldValueSeparator());
            gen.writeRaw(this.syntaxHighlighter.forWhitespace());
            gen.writeRaw(' ');
        } else {
            gen.writeRaw(this.syntaxHighlighter.forColon());
            gen.writeRaw(this._separators.getObjectFieldValueSeparator());
        }
        if (this.valueColor != null) {
            gen.writeRaw(this.valueColor);
            this.valueColor = null;
        }
    }

    public void writeStartArray(JsonGenerator gen) throws IOException {
        gen.writeRaw(this.syntaxHighlighter.forSquareBrackets());
        super.writeStartArray(gen);
        if (this.listener != null) {
            this.listener.startArray(gen.getOutputContext());
        }
    }

    public void writeEndArray(JsonGenerator gen, int nrOfValues) throws IOException {
        if (this.listener != null) {
            this.listener.endArray(gen.getOutputContext().getParent());
        }
        String color = this.syntaxHighlighter.forSquareBrackets();
        gen.writeRaw(color);
        this.arrayIndenter.setValueColor(color);
        super.writeEndArray(gen, nrOfValues);
        this.arrayIndenter.clearValueColor();
    }

    public void writeArrayValueSeparator(JsonGenerator gen) throws IOException {
        gen.writeRaw(this.syntaxHighlighter.forComma());
        if (this.valueColor != null) {
            this.arrayIndenter.setValueColor(this.valueColor);
        }
        super.writeArrayValueSeparator(gen);
    }

    public void beforeArrayValues(JsonGenerator gen) throws IOException {
        if (this.valueColor != null) {
            this.arrayIndenter.setValueColor(this.valueColor);
        }
        super.beforeArrayValues(gen);
    }

    public void beforeObjectEntries(JsonGenerator gen) throws IOException {
        super.beforeObjectEntries(gen);
    }

    public void setValueColor(String valueColor) {
        this.valueColor = valueColor;
    }

    public void setCommaColor(String commaColor) {
        this.commaColor = commaColor;
    }

    public void cleanCommaColor() {
        this.commaColor = null;
    }
}

