/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.jackson.jsh;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.github.skjolber.jackson.jsh.SyntaxHighlighter;
import java.io.IOException;

public class SyntaxHighlighterIndenter
implements DefaultPrettyPrinter.Indenter {
    private final DefaultPrettyPrinter.Indenter delegate;
    protected SyntaxHighlighter highligheter;
    protected String valueColor;

    public SyntaxHighlighterIndenter(SyntaxHighlighter highligheter, DefaultPrettyPrinter.Indenter delegate) {
        this.delegate = delegate;
        this.highligheter = highligheter;
    }

    public void writeIndentation(JsonGenerator jg, int level) throws IOException {
        String color = this.highligheter.forWhitespace();
        jg.writeRaw(color);
        this.delegate.writeIndentation(jg, level);
        if (this.valueColor != null) {
            jg.writeRaw(this.valueColor);
        }
    }

    public void setValueColor(String color) {
        this.valueColor = color;
    }

    public void clearValueColor() {
        this.valueColor = null;
    }

    public boolean isInline() {
        return this.delegate.isInline();
    }
}

