/*
 * Decompiled with CFR 0.152.
 */
package com.skjolberg.mockito.soap;

import com.skjolberg.mockito.soap.SoapServiceProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.junit.rules.ExternalResource;
import org.mockito.Mockito;

public class SoapServiceRule
extends ExternalResource {
    private List<Server> servers = new ArrayList<Server>();

    public static SoapServiceRule newInstance() {
        return new SoapServiceRule();
    }

    public <T> void proxy(T target, Class<T> port, String address, String wsdlLocation, List<String> schemaLocations) {
        if (target == null) {
            throw new IllegalArgumentException("Expected proxy target");
        }
        if (port == null) {
            throw new IllegalArgumentException("Expect port class");
        }
        if (address == null) {
            throw new IllegalArgumentException("Expected address");
        }
        T serviceInterface = SoapServiceProxy.newInstance(target);
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        svrFactory.setServiceClass(port);
        svrFactory.setAddress(address);
        svrFactory.setServiceBean(serviceInterface);
        if (wsdlLocation != null || schemaLocations != null) {
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("schema-validation-enabled", true);
            svrFactory.setProperties(properties);
            if (wsdlLocation != null) {
                svrFactory.setWsdlLocation(wsdlLocation);
            }
            if (schemaLocations != null) {
                svrFactory.setSchemaLocations(schemaLocations);
            }
        }
        Server server = svrFactory.create();
        server.start();
        this.servers.add(server);
    }

    public <T> T mock(Class<T> port, String address) {
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, null, null);
        return (T)mock;
    }

    public <T> T mock(Class<T> port, String address, String wsdlLocation) {
        if (wsdlLocation == null || wsdlLocation.isEmpty()) {
            throw new IllegalArgumentException("Expected wsdl location");
        }
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, wsdlLocation, null);
        return (T)mock;
    }

    public <T> T mock(Class<T> port, String address, List<String> schemaLocations) {
        if (schemaLocations == null || schemaLocations.isEmpty()) {
            throw new IllegalArgumentException("Expected schema locations");
        }
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, null, schemaLocations);
        return (T)mock;
    }

    protected void before() throws Throwable {
        super.before();
    }

    protected void after() {
        this.destroy();
    }

    public void destroy() {
        for (Server endpointImpl : this.servers) {
            endpointImpl.destroy();
        }
    }

    public void stop() {
        for (Server endpointImpl : this.servers) {
            endpointImpl.stop();
        }
    }

    public void start() {
        for (Server endpointImpl : this.servers) {
            endpointImpl.start();
        }
    }
}

