/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.soap;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ServerSocketFactory;

abstract class PortManager<T> {
    static final int PORT_RANGE_MAX = 65535;
    private int portRangeStart;
    private int portRangeEnd;
    private List<Port> ports = new ArrayList<Port>();

    public PortManager(int portRangeStart, int portRangeEnd) {
        if (portRangeStart <= 0) {
            throw new IllegalArgumentException("Port range start must be greater than 0.");
        }
        if (portRangeEnd < portRangeStart) {
            throw new IllegalArgumentException("Port range end must not be lower than port range end.");
        }
        if (portRangeEnd > 65535) {
            throw new IllegalArgumentException("Port range end must not be larger than 65535.");
        }
        this.portRangeStart = portRangeStart;
        this.portRangeEnd = portRangeEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        try (ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));){
            serverSocket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void add(String ... names) {
        if (names != null) {
            int total = this.ports.size() + names.length;
            if (total > this.portRangeEnd - this.portRangeStart + 1) {
                throw new IllegalArgumentException("Cannot reserve " + names.length + " in range " + this.portRangeStart + "-" + this.portRangeEnd + ".");
            }
            for (String name : names) {
                this.ports.add(new Port(name));
            }
        }
    }

    public Map<String, Integer> getPorts() {
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        for (Port reservation : this.ports) {
            ports.put(reservation.getName(), reservation.getPort());
        }
        return ports;
    }

    public int getPort(String name) {
        for (Port reservation : this.ports) {
            if (!name.equals(reservation.getName())) continue;
            return reservation.getPort();
        }
        throw new IllegalArgumentException("No reserved port for '" + name + "'.");
    }

    public T getData(int port) {
        for (Port reservation : this.ports) {
            if (reservation.getPort() != port) continue;
            return reservation.getData();
        }
        return null;
    }

    public void reserve(Port port) {
        int portRange = this.portRangeEnd - this.portRangeStart + 1;
        int offset = new Random().nextInt(portRange);
        for (int i = 0; i < portRange; ++i) {
            try {
                int candidatePort = this.portRangeStart + (offset + portRange) % portRange;
                if (!PortManager.isPortAvailable(candidatePort)) continue;
                T data = this.reserve(candidatePort);
                port.reserve(candidatePort, data);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Unable to reserve port for " + port.getName());
    }

    public void start() {
        this.ports.forEach(this::reserve);
    }

    public void stop() {
        this.ports.forEach(Port::release);
    }

    public abstract T reserve(int var1) throws Exception;

    public abstract void release(T var1);

    class Port {
        private final String name;
        private int port = -1;
        private T data;

        public Port(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getPort() {
            return this.port;
        }

        public T getData() {
            return this.data;
        }

        public void reserve(int candidatePort, T data) {
            this.port = candidatePort;
            this.data = data;
            System.setProperty(this.name, Integer.toString(candidatePort));
        }

        public void release() {
            if (this.data != null) {
                PortManager.this.release(this.data);
                System.clearProperty(this.name);
                this.port = -1;
                this.data = null;
            }
        }
    }
}

