/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.soap;

import com.github.skjolber.mockito.soap.SoapServiceProxy;
import com.github.skjolber.mockito.soap.SoapServiceRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;

public class SoapServerRule
extends SoapServiceRule {
    private Map<String, Server> servers = new HashMap<String, Server>();

    public static SoapServerRule newInstance() {
        return new SoapServerRule();
    }

    @Override
    public <T> void proxy(T target, Class<T> port, String address, String wsdlLocation, List<String> schemaLocations, Map<String, Object> properties) {
        this.assertValidParams(target, port, address);
        if (this.servers.containsKey(address)) {
            throw new IllegalArgumentException("Server " + address + " already exists");
        }
        T serviceInterface = SoapServiceProxy.newInstance(target);
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        svrFactory.setServiceClass(port);
        svrFactory.setAddress(address);
        svrFactory.setServiceBean(serviceInterface);
        if (wsdlLocation != null) {
            svrFactory.setWsdlLocation(wsdlLocation);
        }
        if (schemaLocations != null) {
            svrFactory.setSchemaLocations(schemaLocations);
        }
        svrFactory.setProperties(this.processProperties(properties, wsdlLocation, schemaLocations));
        Server server = svrFactory.create();
        this.servers.put(address, server);
        server.start();
    }

    protected void after() {
        this.destroy();
    }

    public void destroy() {
        this.reset();
    }

    @Override
    public void stop() {
        this.servers.values().forEach(Server::stop);
    }

    @Override
    public void start() {
        this.servers.values().forEach(Server::start);
    }

    public void reset() {
        this.servers.values().forEach(server -> {
            server.destroy();
            ((EndpointImpl)server.getEndpoint()).getBus().shutdown(true);
        });
        this.servers.clear();
    }

    @Override
    protected void assertValidAddress(String address) {
        if (address != null && address.startsWith("local://")) {
            return;
        }
        super.assertValidAddress(address);
    }
}

