/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.soap;

import com.github.skjolber.mockito.soap.SoapExtension;
import com.github.skjolber.mockito.soap.SoapServiceProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class SoapServiceExtension
extends SoapExtension {
    private Map<String, Server> servers = new HashMap<String, Server>();

    @Override
    public <T> void proxy(T target, Class<T> port, String address, String wsdlLocation, List<String> schemaLocations, Map<String, Object> properties) {
        this.assertValidParams(target, port, address);
        if (this.servers.containsKey(address)) {
            throw new IllegalArgumentException("Server " + address + " already exists");
        }
        T serviceInterface = SoapServiceProxy.newInstance(target);
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        svrFactory.setServiceClass(port);
        svrFactory.setAddress(address);
        svrFactory.setServiceBean(serviceInterface);
        if (wsdlLocation != null) {
            svrFactory.setWsdlLocation(wsdlLocation);
        }
        if (schemaLocations != null) {
            svrFactory.setSchemaLocations(schemaLocations);
        }
        svrFactory.setProperties(this.processProperties(properties, wsdlLocation, schemaLocations));
        Server server = svrFactory.create();
        this.servers.put(address, server);
        server.start();
    }

    @Override
    protected void assertValidAddress(String address) {
        if (address != null && address.startsWith("local://")) {
            return;
        }
        super.assertValidAddress(address);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> target = parameterContext.getParameter().getType();
        return target == SoapServiceExtension.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> target = parameterContext.getParameter().getType();
        if (target == SoapServiceExtension.class) {
            return this;
        }
        throw new RuntimeException();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.start();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.reset();
    }

    public void stop() {
        this.servers.values().forEach(Server::stop);
    }

    public void start() {
        this.servers.values().forEach(Server::start);
    }

    public void reset() {
        this.servers.values().forEach(server -> {
            server.destroy();
            ((EndpointImpl)server.getEndpoint()).getBus().shutdown(true);
        });
        this.servers.clear();
    }

    public void afterAll(ExtensionContext context) throws Exception {
    }
}

