/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.soap;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.cxf.binding.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SoapServiceFault {
    public static SoapFault createFault() {
        QName qName = SoapFault.FAULT_CODE_SERVER;
        return new SoapFault("message", qName);
    }

    public static SoapFault createFault(Node detail) {
        QName qName = SoapFault.FAULT_CODE_SERVER;
        SoapFault fault = new SoapFault("message", qName);
        Element detailElement = fault.getOrCreateDetail();
        detailElement.appendChild(detailElement.getOwnerDocument().importNode(detail, true));
        return fault;
    }

    public static SoapFault createFault(String detail) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(detail)));
            return SoapServiceFault.createFault(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(detail, e);
        }
    }

    public static SoapFault createFault(Object detail) {
        return SoapServiceFault.createFault(detail, null);
    }

    public static <T> SoapFault createFault(Object detail, QName qname) {
        try {
            Marshaller marshaller;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{detail.getClass()});
            DOMResult result = new DOMResult();
            if (detail.getClass().isAnnotationPresent(XmlRootElement.class)) {
                marshaller = SoapServiceFault.getMarshaller(context, false);
            } else {
                detail = new JAXBElement(qname, detail.getClass(), detail);
                marshaller = SoapServiceFault.getMarshaller(context, true);
            }
            marshaller.marshal(detail, (Result)result);
            return SoapServiceFault.createFault(result.getNode().getFirstChild());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static Marshaller getMarshaller(JAXBContext context, boolean fragment) throws JAXBException {
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)fragment);
        return marshaller;
    }
}

