/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.soap;

import com.github.skjolber.mockito.soap.PortManager;
import com.github.skjolber.mockito.soap.SoapServiceProxy;
import com.github.skjolber.mockito.soap.SoapServiceRule;
import jakarta.xml.ws.spi.Provider;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;

public class SoapEndpointRule
extends SoapServiceRule {
    private static final int PORT_RANGE_START = 1025;
    private static final int PORT_RANGE_END = 65535;
    private Map<String, EndpointImpl> endpoints = new HashMap<String, EndpointImpl>();
    private PortManager<Destination> portManager;

    public static SoapEndpointRule newInstance() {
        return new SoapEndpointRule();
    }

    public static SoapEndpointRule newInstance(String ... portNames) {
        return new SoapEndpointRule(portNames);
    }

    public static SoapEndpointRule newInstance(int portRangeStart, int portRangeEnd, String ... portNames) {
        return new SoapEndpointRule(portRangeStart, portRangeEnd, portNames);
    }

    public SoapEndpointRule() {
        this(1025, 65535, new String[0]);
    }

    public SoapEndpointRule(String ... portNames) {
        this(1025, 65535, portNames);
    }

    public SoapEndpointRule(int portRangeStart, int portRangeEnd, String ... portNames) {
        this.portManager = new PortManager<Destination>(portRangeStart, portRangeEnd){

            @Override
            public Destination reserve(int port) throws Exception {
                return SoapEndpointRule.this.createDestination(port);
            }

            @Override
            public void release(Destination destination) {
                destination.shutdown();
            }
        };
        this.portManager.add(portNames);
    }

    public int getPort(String portName) {
        return this.portManager.getPort(portName);
    }

    public Map<String, Integer> getPorts() {
        return this.portManager.getPorts();
    }

    private Destination createDestination(int port) throws IOException, EndpointException {
        JaxWsServiceFactoryBean jaxWsServiceFactoryBean = new JaxWsServiceFactoryBean();
        JaxWsServerFactoryBean serverFactoryBean = new JaxWsServerFactoryBean(jaxWsServiceFactoryBean);
        Bus bus = serverFactoryBean.getBus();
        String address = "http://localhost:" + port;
        serverFactoryBean.setAddress(address);
        DestinationFactory destinationFactory = ((DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class)).getDestinationFactoryForUri(address);
        EndpointInfo ei = new EndpointInfo(null, Integer.toString(port));
        ei.setAddress(address);
        Destination destination = destinationFactory.getDestination(ei, bus);
        ServiceImpl serviceImpl = new ServiceImpl();
        org.apache.cxf.endpoint.EndpointImpl endpoint = new org.apache.cxf.endpoint.EndpointImpl(bus, (Service)serviceImpl, ei);
        destination.setMessageObserver((MessageObserver)new ChainInitiationObserver((Endpoint)endpoint, bus));
        return destination;
    }

    @Override
    public <T> void proxy(T target, Class<T> port, String address, String wsdlLocation, List<String> schemaLocations, Map<String, Object> properties) {
        this.assertValidParams(target, port, address);
        if (this.endpoints.containsKey(address)) {
            throw new IllegalArgumentException("Endpoint " + address + " already exists");
        }
        T serviceInterface = SoapServiceProxy.newInstance(target);
        EndpointImpl endpoint = (EndpointImpl)Provider.provider().createEndpoint(null, serviceInterface);
        if (wsdlLocation != null) {
            endpoint.setWsdlLocation(wsdlLocation);
        }
        if (schemaLocations != null) {
            endpoint.setSchemaLocations(schemaLocations);
        }
        endpoint.setProperties(this.processProperties(properties, wsdlLocation, schemaLocations));
        Destination destination = this.portManager.getData(this.parsePort(address));
        if (destination != null) {
            ServerImpl server = endpoint.getServer();
            server.setDestination(destination);
        }
        endpoint.publish(address);
        this.endpoints.put(address, endpoint);
    }

    protected void before() {
        this.portManager.start();
    }

    protected void after() {
        this.destroy();
    }

    public void clear() {
        this.endpoints.values().forEach(EndpointImpl::stop);
        this.endpoints.clear();
    }

    public void destroy() {
        this.endpoints.values().forEach(endpoint -> {
            endpoint.stop();
            endpoint.getBus().shutdown(true);
        });
        this.endpoints.clear();
        this.portManager.stop();
    }

    @Override
    public void stop() {
        this.endpoints.values().forEach(endpoint -> endpoint.getServer().stop());
    }

    @Override
    public void start() {
        this.endpoints.values().forEach(endpoint -> endpoint.getServer().start());
    }
}

