/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.soap;

import com.github.skjolber.mockito.soap.SoapEndpointRule;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.mockito.Mockito;

public abstract class SoapServiceRule
extends ExternalResource {
    public static SoapServiceRule newInstance() {
        return new SoapEndpointRule();
    }

    public static SoapEndpointRule newInstance(String ... portNames) {
        return new SoapEndpointRule(portNames);
    }

    public static SoapEndpointRule newInstance(int portRangeStart, int portRangeEnd, String ... portNames) {
        return new SoapEndpointRule(portRangeStart, portRangeEnd, portNames);
    }

    public <T> void proxy(T target, Class<T> port, String address, String wsdlLocation, List<String> schemaLocations) {
        this.proxy(target, port, address, wsdlLocation, schemaLocations, null);
    }

    public abstract <T> void proxy(T var1, Class<T> var2, String var3, String var4, List<String> var5, Map<String, Object> var6);

    public <T> T mock(Class<T> port, String address) {
        return this.mock(port, address, null, null, null);
    }

    public <T> T mock(Class<T> port, String address, Map<String, Object> properties) {
        return this.mock(port, address, null, null, properties);
    }

    public <T> T mock(Class<T> port, String address, String wsdlLocation) {
        return this.mock(port, address, wsdlLocation, null);
    }

    public <T> T mock(Class<T> port, String address, String wsdlLocation, Map<String, Object> properties) {
        if (wsdlLocation == null || wsdlLocation.isEmpty()) {
            throw new IllegalArgumentException("Expected WSDL location.");
        }
        return this.mock(port, address, wsdlLocation, null, properties);
    }

    public <T> T mock(Class<T> port, String address, List<String> schemaLocations) {
        return this.mock(port, address, schemaLocations, null);
    }

    public <T> T mock(Class<T> port, String address, List<String> schemaLocations, Map<String, Object> properties) {
        if (schemaLocations == null || schemaLocations.isEmpty()) {
            throw new IllegalArgumentException("Expected XML Schema location(s).");
        }
        return this.mock(port, address, null, schemaLocations, properties);
    }

    private <T> T mock(Class<T> port, String address, String wsdlLocation, List<String> schemaLocations, Map<String, Object> properties) {
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, wsdlLocation, schemaLocations, properties);
        return (T)mock;
    }

    protected <T> void assertValidParams(T target, Class<T> port, String address) {
        if (target == null) {
            throw new IllegalArgumentException("Expected proxy target");
        }
        if (port == null) {
            throw new IllegalArgumentException("Expect port class");
        }
        if (address == null) {
            throw new IllegalArgumentException("Expected address");
        }
        this.assertValidAddress(address);
    }

    protected void assertValidAddress(String address) {
        this.parsePort(address);
    }

    protected int parsePort(String address) {
        try {
            return new URL(address).getPort();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Expected valid address: " + address, e);
        }
    }

    protected Map<String, Object> processProperties(Map<String, Object> properties, String wsdlLocation, List<String> schemaLocations) {
        HashMap<String, Object> map;
        HashMap<String, Object> hashMap = map = properties != null ? new HashMap<String, Object>(properties) : new HashMap();
        if (wsdlLocation != null || schemaLocations != null) {
            map.put("schema-validation-enabled", true);
        }
        return map;
    }

    public static Map<String, Object> properties(Object ... properties) {
        SoapServiceRule.verifyProperties(properties);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (properties != null) {
            for (int i = 0; i < properties.length; i += 2) {
                map.put((String)properties[i], properties[i + 1]);
            }
        }
        return map;
    }

    protected static void verifyProperties(Object ... properties) {
        if (properties != null) {
            if (properties.length % 2 != 0) {
                throw new IllegalArgumentException("Expected key-value properties, not length " + properties.length);
            }
            for (int i = 0; i < properties.length; i += 2) {
                if (properties[i] instanceof String) continue;
                throw new IllegalArgumentException("Expected key-value with string key at index " + i);
            }
        }
    }

    public abstract void stop();

    public abstract void start();
}

