/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.graphql.matchers;

import com.github.skjolber.mockito.graphql.matchers.GraphQLParser;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.parser.Parser;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mockito.ArgumentMatcher;

public abstract class AbstractValueMatcher
implements ArgumentMatcher<Object>,
Serializable {
    protected final String name;
    protected final Map<String, Object> variables;
    protected final OperationDefinition.Operation operation;

    public AbstractValueMatcher(String name, Map<String, Object> variables, OperationDefinition.Operation operation) {
        this.name = name;
        this.variables = variables;
        this.operation = operation;
    }

    public boolean matches(Object actual) {
        String query = null;
        if (actual instanceof String) {
            query = GraphQLParser.parseQuery((String)actual);
        } else if (actual instanceof byte[]) {
            query = GraphQLParser.parseQuery((byte[])actual);
        } else {
            return false;
        }
        if (query != null) {
            Document document = Parser.parse((String)query);
            Optional optional = document.getFirstDefinitionOfType(OperationDefinition.class);
            if (!optional.isPresent()) {
                return false;
            }
            OperationDefinition operationDefinition = (OperationDefinition)optional.get();
            if (operationDefinition.getOperation() != this.operation) {
                return false;
            }
            return this.match(operationDefinition);
        }
        return false;
    }

    protected abstract boolean match(OperationDefinition var1);

    protected boolean matchSelectionSetName(OperationDefinition operationDefinition) {
        SelectionSet selectionSet = operationDefinition.getSelectionSet();
        List selectionsOfType = selectionSet.getSelectionsOfType(Field.class);
        for (Field field : selectionsOfType) {
            if (!field.getName().equals(this.name)) continue;
            if (!this.variables.isEmpty()) {
                List arguments = field.getArguments();
                if (arguments.size() != this.variables.size()) {
                    return false;
                }
                for (Argument argument : arguments) {
                    Object object;
                    Value value = argument.getValue();
                    if (value instanceof ArrayValue) {
                        int i;
                        Object a;
                        object = this.variables.get(argument.getName());
                        ArrayValue v = (ArrayValue)value;
                        List values = v.getValues();
                        if (object instanceof Object[]) {
                            a = (Object[])object;
                            if (((Object[])a).length != values.size()) {
                                return false;
                            }
                            for (i = 0; i < ((Object)a).length; ++i) {
                                if (this.equals(a[i], (Value)values.get(i))) continue;
                                return false;
                            }
                            continue;
                        }
                        if (object instanceof List) {
                            a = (List)object;
                            if (a.size() != values.size()) {
                                return false;
                            }
                            for (i = 0; i < a.size(); ++i) {
                                if (this.equals(a.get(i), (Value)values.get(i))) continue;
                                return false;
                            }
                            continue;
                        }
                        return false;
                    }
                    object = this.variables.get(argument.getName());
                    if (this.equals(object, value)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean equals(Object object, Value value) {
        if (object == null) {
            return value instanceof NullValue;
        }
        if (value instanceof BooleanValue) {
            BooleanValue v = (BooleanValue)value;
            return object.equals(v.isValue());
        }
        if (value instanceof FloatValue) {
            FloatValue v = (FloatValue)value;
            return object.equals(v.getValue());
        }
        if (value instanceof IntValue) {
            IntValue v = (IntValue)value;
            Number n = (Number)object;
            BigInteger other = BigInteger.valueOf(n.longValue());
            return other.equals(v.getValue());
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return object.equals(stringValue.getValue());
        }
        if (value instanceof ArrayValue) {
            ArrayValue v = (ArrayValue)value;
            List values = v.getValues();
            if (object instanceof Object[]) {
                Object[] a = (Object[])object;
                if (a.length != values.size()) {
                    return false;
                }
                for (int i = 0; i < a.length; ++i) {
                    if (this.equals(a[i], (Value)values.get(i))) continue;
                    return false;
                }
            } else if (object instanceof List) {
                List a = (List)object;
                if (a.size() != values.size()) {
                    return false;
                }
                for (int i = 0; i < a.size(); ++i) {
                    if (this.equals(a.get(i), (Value)values.get(i))) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return false;
    }
}

