/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.graphql.matchers;

import com.github.skjolber.mockito.graphql.matchers.AnyGraphQL;
import com.github.skjolber.mockito.graphql.matchers.AnyMutation;
import com.github.skjolber.mockito.graphql.matchers.AnyQuery;
import com.github.skjolber.mockito.graphql.matchers.GraphQLDocument;
import com.github.skjolber.mockito.graphql.matchers.MutationName;
import com.github.skjolber.mockito.graphql.matchers.QueryName;
import com.github.skjolber.mockito.graphql.matchers.SelectionSetName;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.progress.ThreadSafeMockingProgress;

public class ArgumentMatchers {
    public static <T> T anyQuery() {
        ArgumentMatchers.reportMatcher(AnyQuery.ANY);
        return null;
    }

    public static <T> T anyMutation() {
        ArgumentMatchers.reportMatcher(AnyMutation.ANY);
        return null;
    }

    public static <T> T anyGraphQL() {
        ArgumentMatchers.reportMatcher(AnyGraphQL.ANY);
        return null;
    }

    public static <T> T queryName(String name, Object ... arguments) {
        ArgumentMatchers.reportMatcher(new QueryName(name, ArgumentMatchers.toMap(arguments)));
        return null;
    }

    public static <T> T mutationName(String name, Object ... arguments) {
        ArgumentMatchers.reportMatcher(new MutationName(name, ArgumentMatchers.toMap(arguments)));
        return null;
    }

    public static <T> T selectionSetName(String name, OperationDefinition.Operation operation, Object ... arguments) {
        ArgumentMatchers.reportMatcher(new SelectionSetName(name, ArgumentMatchers.toMap(arguments), operation));
        return null;
    }

    public static <T> T document(Function<Document, Boolean> decider) {
        ArgumentMatchers.reportMatcher(new GraphQLDocument(decider));
        return null;
    }

    private static void reportMatcher(ArgumentMatcher<?> matcher) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportMatcher(matcher);
    }

    private static Map<String, Object> toMap(Object[] arguments) {
        if (arguments != null && arguments.length > 0) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (arguments.length % 2 != 0) {
                throw new IllegalArgumentException("Expected key-value pairs");
            }
            for (int i = 0; i < arguments.length; i += 2) {
                Object key = arguments[i];
                Object value = arguments[i + 1];
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Expected String key");
                }
                result.put((String)key, value);
            }
            return result;
        }
        return Collections.emptyMap();
    }
}

