/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.graphql.matchers;

import com.github.skjolber.mockito.graphql.matchers.GraphQLParser;
import graphql.language.Document;
import graphql.parser.Parser;
import java.io.Serializable;
import java.util.function.Function;
import org.mockito.ArgumentMatcher;

public class GraphQLDocument
implements ArgumentMatcher<Object>,
Serializable {
    private final Function<Document, Boolean> f;

    public GraphQLDocument(Function<Document, Boolean> f) {
        this.f = f;
    }

    public boolean matches(Object actual) {
        String query = null;
        if (actual instanceof String) {
            query = GraphQLParser.parseQuery((String)actual);
        } else if (actual instanceof byte[]) {
            query = GraphQLParser.parseQuery((byte[])actual);
        } else {
            return false;
        }
        if (query != null) {
            Document document = Parser.parse((String)query);
            return this.f.apply(document);
        }
        return false;
    }

    public String toString() {
        return "<custom document matcher>";
    }

    public Class<?> type() {
        return Object.class;
    }
}

