/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.graphql.matchers;

import com.github.skjolber.mockito.graphql.matchers.AbstractValueMatcher;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.OperationDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import java.util.List;
import java.util.Map;

public class QueryName
extends AbstractValueMatcher {
    public QueryName(String name, Map<String, Object> variables) {
        super(name, variables, OperationDefinition.Operation.QUERY);
    }

    public String toString() {
        return "<query " + this.name + ">";
    }

    public Class<?> type() {
        return Object.class;
    }

    @Override
    protected boolean match(OperationDefinition operationDefinition) {
        String operationName = operationDefinition.getName();
        if (operationName == null) {
            return this.matchSelectionSetName(operationDefinition);
        }
        if (!this.name.equals(operationName)) {
            return false;
        }
        if (!this.variables.isEmpty()) {
            List variableDefinitions = operationDefinition.getVariableDefinitions();
            if (variableDefinitions.size() != this.variables.size()) {
                return false;
            }
            for (VariableDefinition variableDefinition : variableDefinitions) {
                Object object = this.variables.get(variableDefinition.getName());
                if (object == null) {
                    return false;
                }
                Type type = variableDefinition.getType();
                if (QueryName.matches(type, object)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matches(Type type, Object object) {
        if (type instanceof NonNullType) {
            String string = object.toString();
            if (!string.endsWith("!")) {
                return false;
            }
            NonNullType nonNullType = (NonNullType)type;
            return QueryName.matches(nonNullType.getType(), string.substring(0, string.length() - 1));
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            return QueryName.matches(listType.getType(), object);
        }
        if (type instanceof TypeName) {
            TypeName typeName = (TypeName)type;
            if (typeName.getName().equals(object)) {
                return true;
            }
            if (object instanceof Class) {
                if (Integer.class == object || Long.class == object || Short.class == object || Byte.class == object) {
                    return typeName.getName().equals("Int");
                }
                if (String.class == object) {
                    return typeName.getName().equals("String");
                }
                if (Boolean.class == object) {
                    return typeName.getName().equals("Boolean");
                }
                if (Float.class == object || Double.class == object) {
                    return typeName.getName().equals("Float");
                }
            }
            return false;
        }
        return false;
    }
}

