/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.compose.stability.gradle;

import com.skydoves.compose.stability.gradle.StabilityAnalyzerExtension;
import com.skydoves.compose.stability.gradle.StabilityCheckTask;
import com.skydoves.compose.stability.gradle.StabilityDumpTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinAndroidProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaCompilation;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilationTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/skydoves/compose/stability/gradle/StabilityAnalyzerGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "buildCompilerArguments", "", "", "extension", "Lcom/skydoves/compose/stability/gradle/StabilityAnalyzerExtension;", "configureKotlinCompilerPlugin", "configureTaskDependencies", "stabilityDumpTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/skydoves/compose/stability/gradle/StabilityDumpTask;", "stabilityCheckTask", "Lcom/skydoves/compose/stability/gradle/StabilityCheckTask;", "isTestCompilation", "", "compilationName", "Companion", "stability-gradle"})
public final class StabilityAnalyzerGradlePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VERSION = "0.4.0";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[]{project.getLayout()};
        Object object = project.getExtensions().create("composeStabilityAnalyzer", StabilityAnalyzerExtension.class, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026    project.layout,\n    )");
        StabilityAnalyzerExtension extension = (StabilityAnalyzerExtension)object;
        TaskProvider taskProvider = project.getTasks().register("stabilityDump", StabilityDumpTask.class, new Action(project, extension){
            final /* synthetic */ Project $project;
            final /* synthetic */ StabilityAnalyzerExtension $extension;
            {
                this.$project = $project;
                this.$extension = $extension;
            }

            public final void execute(StabilityDumpTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.getStabilityInputFile().set(this.$project.getLayout().getBuildDirectory().file("stability/stability-info.json"));
                $this$register.getOutputDir().set((Provider)this.$extension.getStabilityValidation().getOutputDir());
                $this$register.getIgnoredPackages().set((Provider)this.$extension.getStabilityValidation().getIgnoredPackages());
                $this$register.getIgnoredClasses().set((Provider)this.$extension.getStabilityValidation().getIgnoredClasses());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project: Project) {\n    \u2026ion.ignoredClasses)\n    }");
        TaskProvider stabilityDumpTask2 = taskProvider;
        TaskProvider taskProvider2 = project.getTasks().register("stabilityCheck", StabilityCheckTask.class, new Action(project, extension){
            final /* synthetic */ Project $project;
            final /* synthetic */ StabilityAnalyzerExtension $extension;
            {
                this.$project = $project;
                this.$extension = $extension;
            }

            public final void execute(StabilityCheckTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.getStabilityInputFile().set(this.$project.getLayout().getBuildDirectory().file("stability/stability-info.json"));
                $this$register.getStabilityDir().set((Provider)this.$extension.getStabilityValidation().getOutputDir());
                $this$register.getIgnoredPackages().set((Provider)this.$extension.getStabilityValidation().getIgnoredPackages());
                $this$register.getIgnoredClasses().set((Provider)this.$extension.getStabilityValidation().getIgnoredClasses());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project: Project) {\n    \u2026ion.ignoredClasses)\n    }");
        TaskProvider stabilityCheckTask2 = taskProvider2;
        project.getTasks().named("check", new Action((TaskProvider<StabilityCheckTask>)stabilityCheckTask2){
            final /* synthetic */ TaskProvider<StabilityCheckTask> $stabilityCheckTask;
            {
                this.$stabilityCheckTask = $stabilityCheckTask;
            }

            public final void execute(Task $this$named) {
                Intrinsics.checkNotNullParameter((Object)$this$named, (String)"$this$named");
                Object[] objectArray = new Object[]{this.$stabilityCheckTask};
                $this$named.dependsOn(objectArray);
            }
        });
        project.afterEvaluate(new Action(extension, project, this, (TaskProvider<StabilityDumpTask>)stabilityDumpTask2, (TaskProvider<StabilityCheckTask>)stabilityCheckTask2){
            final /* synthetic */ StabilityAnalyzerExtension $extension;
            final /* synthetic */ Project $project;
            final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
            final /* synthetic */ TaskProvider<StabilityDumpTask> $stabilityDumpTask;
            final /* synthetic */ TaskProvider<StabilityCheckTask> $stabilityCheckTask;
            {
                this.$extension = $extension;
                this.$project = $project;
                this.this$0 = $receiver;
                this.$stabilityDumpTask = $stabilityDumpTask;
                this.$stabilityCheckTask = $stabilityCheckTask;
            }

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                Object object = this.$extension.getStabilityValidation().getIgnoredProjects().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.stabilityValid\u2026ion.ignoredProjects.get()");
                List ignoredProjects = (List)object;
                String string = this.$project.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
                String projectName = string;
                boolean isIgnored = ignoredProjects.contains(projectName);
                if (isIgnored) {
                    return;
                }
                StabilityAnalyzerGradlePlugin.access$configureKotlinCompilerPlugin(this.this$0, this.$project, this.$extension);
                StabilityAnalyzerGradlePlugin.access$configureTaskDependencies(this.this$0, this.$project, this.$stabilityDumpTask, this.$stabilityCheckTask);
            }
        });
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        Project rootProject = project2;
        Project runtimeProject = rootProject.findProject(":stability-runtime");
        Project lintProject = rootProject.findProject(":stability-lint");
        if (runtimeProject != null) {
            project.getDependencies().add("implementation", (Object)runtimeProject);
            if (lintProject != null) {
                project.getDependencies().add("lintChecks", (Object)lintProject);
            }
        } else {
            String dep = "com.github.skydoves:compose-stability-runtime:0.4.0";
            project.getDependencies().add("implementation", (Object)dep);
        }
    }

    private final void configureKotlinCompilerPlugin(Project project, StabilityAnalyzerExtension extension) {
        KotlinJvmProjectExtension kotlinExtension;
        Object object = (KotlinJvmProjectExtension)project.getExtensions().findByType(KotlinJvmProjectExtension.class);
        if (object == null && (object = (KotlinAndroidProjectExtension)project.getExtensions().findByType(KotlinAndroidProjectExtension.class)) == null) {
            object = project.getExtensions().findByType(KotlinMultiplatformExtension.class);
        }
        if ((kotlinExtension = object) == null) {
            project.getLogger().warn("Kotlin plugin not found. Compose Stability Analyzer will not be configured.");
            return;
        }
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        Project rootProject = project2;
        Project compilerProject = rootProject.findProject(":stability-compiler");
        if (compilerProject != null) {
            project.getDependencies().add("kotlinCompilerPluginClasspath", (Object)compilerProject);
        } else {
            project.getDependencies().add("kotlinCompilerPluginClasspath", (Object)"com.github.skydoves:compose-stability-compiler:0.4.0");
        }
        Object object2 = extension.getStabilityValidation().getIncludeTests().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extension.stabilityValidation.includeTests.get()");
        boolean includeTests = (Boolean)object2;
        KotlinJvmProjectExtension kotlinJvmProjectExtension = kotlinExtension;
        if (kotlinJvmProjectExtension instanceof KotlinJvmProjectExtension) {
            kotlinExtension.getTarget().getCompilations().configureEach(new Action(includeTests, this, project, extension){
                final /* synthetic */ boolean $includeTests;
                final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ StabilityAnalyzerExtension $extension;
                {
                    this.$includeTests = $includeTests;
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$extension = $extension;
                }

                public final void execute(KotlinWithJavaCompilation<KotlinJvmOptions, KotlinJvmCompilerOptions> $this$configureEach) {
                    Intrinsics.checkNotNullParameter($this$configureEach, (String)"$this$configureEach");
                    if (this.$includeTests || !StabilityAnalyzerGradlePlugin.access$isTestCompilation(this.this$0, $this$configureEach.getName())) {
                        $this$configureEach.getCompileTaskProvider().configure(new Action(this.this$0, this.$project, this.$extension){
                            final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ StabilityAnalyzerExtension $extension;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$extension = $extension;
                            }

                            public final void execute(KotlinCompilationTask<?> $this$configure) {
                                Intrinsics.checkNotNullParameter($this$configure, (String)"$this$configure");
                                $this$configure.getCompilerOptions().getFreeCompilerArgs().addAll((Iterable)StabilityAnalyzerGradlePlugin.access$buildCompilerArguments(this.this$0, this.$project, this.$extension));
                            }
                        });
                    }
                }
            });
        } else if (kotlinJvmProjectExtension instanceof KotlinAndroidProjectExtension) {
            ((KotlinAndroidProjectExtension)kotlinExtension).getTarget().getCompilations().configureEach(new Action(includeTests, this, project, extension){
                final /* synthetic */ boolean $includeTests;
                final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ StabilityAnalyzerExtension $extension;
                {
                    this.$includeTests = $includeTests;
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$extension = $extension;
                }

                public final void execute(KotlinJvmAndroidCompilation $this$configureEach) {
                    Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                    if (this.$includeTests || !StabilityAnalyzerGradlePlugin.access$isTestCompilation(this.this$0, $this$configureEach.getName())) {
                        $this$configureEach.getCompileTaskProvider().configure(new Action(this.this$0, this.$project, this.$extension){
                            final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ StabilityAnalyzerExtension $extension;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$extension = $extension;
                            }

                            public final void execute(KotlinCompilationTask<? extends KotlinJvmCompilerOptions> $this$configure) {
                                Intrinsics.checkNotNullParameter($this$configure, (String)"$this$configure");
                                ((KotlinJvmCompilerOptions)$this$configure.getCompilerOptions()).getFreeCompilerArgs().addAll((Iterable)StabilityAnalyzerGradlePlugin.access$buildCompilerArguments(this.this$0, this.$project, this.$extension));
                            }
                        });
                    }
                }
            });
        } else if (kotlinJvmProjectExtension instanceof KotlinMultiplatformExtension) {
            ((KotlinMultiplatformExtension)kotlinExtension).getTargets().configureEach(new Action(includeTests, this, project, extension){
                final /* synthetic */ boolean $includeTests;
                final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ StabilityAnalyzerExtension $extension;
                {
                    this.$includeTests = $includeTests;
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$extension = $extension;
                }

                public final void execute(KotlinTarget $this$configureEach) {
                    Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                    $this$configureEach.getCompilations().configureEach(new Action(this.$includeTests, this.this$0, this.$project, this.$extension){
                        final /* synthetic */ boolean $includeTests;
                        final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ StabilityAnalyzerExtension $extension;
                        {
                            this.$includeTests = $includeTests;
                            this.this$0 = $receiver;
                            this.$project = $project;
                            this.$extension = $extension;
                        }

                        public final void execute(KotlinCompilation<? extends Object> $this$configureEach) {
                            Intrinsics.checkNotNullParameter($this$configureEach, (String)"$this$configureEach");
                            if (this.$includeTests || !StabilityAnalyzerGradlePlugin.access$isTestCompilation(this.this$0, $this$configureEach.getName())) {
                                $this$configureEach.getCompileTaskProvider().configure(new Action(this.this$0, this.$project, this.$extension){
                                    final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ StabilityAnalyzerExtension $extension;
                                    {
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$extension = $extension;
                                    }

                                    public final void execute(KotlinCompilationTask<?> $this$configure) {
                                        Intrinsics.checkNotNullParameter($this$configure, (String)"$this$configure");
                                        $this$configure.getCompilerOptions().getFreeCompilerArgs().addAll((Iterable)StabilityAnalyzerGradlePlugin.access$buildCompilerArguments(this.this$0, this.$project, this.$extension));
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }
    }

    private final boolean isTestCompilation(String compilationName) {
        String string = compilationName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerName = string;
        return StringsKt.contains$default((CharSequence)lowerName, (CharSequence)"test", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lowerName, (CharSequence)"androidtest", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lowerName, (CharSequence)"unittest", (boolean)false, (int)2, null);
    }

    private final List<String> buildCompilerArguments(Project project, StabilityAnalyzerExtension extension) {
        String pluginId = "com.skydoves.compose.stability.compiler";
        List args = new ArrayList();
        args.add("-P");
        args.add("plugin:" + pluginId + ":enabled=" + extension.getEnabled().get());
        String stabilityOutputDir = ((Directory)project.getLayout().getBuildDirectory().dir("stability").get()).getAsFile().getAbsolutePath();
        args.add("-P");
        args.add("plugin:" + pluginId + ":stabilityOutputDir=" + stabilityOutputDir);
        return args;
    }

    private final void configureTaskDependencies(Project project, TaskProvider<StabilityDumpTask> stabilityDumpTask2, TaskProvider<StabilityCheckTask> stabilityCheckTask2) {
        Object object = project.getExtensions().getByType(StabilityAnalyzerExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026zerExtension::class.java)");
        StabilityAnalyzerExtension extension = (StabilityAnalyzerExtension)object;
        Object object2 = extension.getStabilityValidation().getIncludeTests().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extension.stabilityValidation.includeTests.get()");
        boolean includeTests = (Boolean)object2;
        project.getTasks().matching(new Spec(this, includeTests){
            final /* synthetic */ StabilityAnalyzerGradlePlugin this$0;
            final /* synthetic */ boolean $includeTests;
            {
                this.this$0 = $receiver;
                this.$includeTests = $includeTests;
            }

            /*
             * Unable to fully structure code
             */
            public final boolean isSatisfiedBy(Task task) {
                v0 = task.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"task.name");
                if (!StringsKt.startsWith$default((String)v0, (String)"compile", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v1 = task.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"task.name");
                if (StringsKt.contains$default((CharSequence)v1, (CharSequence)"Kotlin", (boolean)false, (int)2, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                isKotlinCompile = v2;
                v3 = task.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"task.name");
                isTestTask = StabilityAnalyzerGradlePlugin.access$isTestCompilation(this.this$0, v3);
                return isKotlinCompile != false && (this.$includeTests != false || isTestTask == false);
            }
        }).all(new Action(stabilityDumpTask2, stabilityCheckTask2){
            final /* synthetic */ TaskProvider<StabilityDumpTask> $stabilityDumpTask;
            final /* synthetic */ TaskProvider<StabilityCheckTask> $stabilityCheckTask;
            {
                this.$stabilityDumpTask = $stabilityDumpTask;
                this.$stabilityCheckTask = $stabilityCheckTask;
            }

            public final void execute(Task $this$all) {
                Intrinsics.checkNotNullParameter((Object)$this$all, (String)"$this$all");
                Object[] objectArray = new Object[]{$this$all};
                ((StabilityDumpTask)((Object)this.$stabilityDumpTask.get())).dependsOn(objectArray);
                objectArray = new Object[]{$this$all};
                ((StabilityCheckTask)((Object)this.$stabilityCheckTask.get())).dependsOn(objectArray);
            }
        });
    }

    public static final /* synthetic */ void access$configureKotlinCompilerPlugin(StabilityAnalyzerGradlePlugin $this, Project project, StabilityAnalyzerExtension extension) {
        $this.configureKotlinCompilerPlugin(project, extension);
    }

    public static final /* synthetic */ void access$configureTaskDependencies(StabilityAnalyzerGradlePlugin $this, Project project, TaskProvider stabilityDumpTask2, TaskProvider stabilityCheckTask2) {
        $this.configureTaskDependencies(project, (TaskProvider<StabilityDumpTask>)stabilityDumpTask2, (TaskProvider<StabilityCheckTask>)stabilityCheckTask2);
    }

    public static final /* synthetic */ boolean access$isTestCompilation(StabilityAnalyzerGradlePlugin $this, String compilationName) {
        return $this.isTestCompilation(compilationName);
    }

    public static final /* synthetic */ List access$buildCompilerArguments(StabilityAnalyzerGradlePlugin $this, Project project, StabilityAnalyzerExtension extension) {
        return $this.buildCompilerArguments(project, extension);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/skydoves/compose/stability/gradle/StabilityAnalyzerGradlePlugin$Companion;", "", "()V", "VERSION", "", "stability-gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

