/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.compose.stability.gradle;

import com.skydoves.compose.stability.gradle.ParameterInfo;
import com.skydoves.compose.stability.gradle.StabilityDifference;
import com.skydoves.compose.stability.gradle.StabilityEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\"H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\"H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00192\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00152\u0006\u0010'\u001a\u00020\u0005H\u0002J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010+\u001a\u00020,H\u0002J\f\u0010.\u001a\u00020\u0005*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/skydoves/compose/stability/gradle/StabilityCheckTask;", "Lorg/gradle/api/DefaultTask;", "()V", "ignoredClasses", "Lorg/gradle/api/provider/ListProperty;", "", "getIgnoredClasses", "()Lorg/gradle/api/provider/ListProperty;", "ignoredPackages", "getIgnoredPackages", "stabilityDir", "Lorg/gradle/api/file/DirectoryProperty;", "getStabilityDir", "()Lorg/gradle/api/file/DirectoryProperty;", "stabilityInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getStabilityInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "check", "", "compareStability", "", "Lcom/skydoves/compose/stability/gradle/StabilityDifference;", "current", "", "Lcom/skydoves/compose/stability/gradle/StabilityEntry;", "reference", "extractJsonBoolean", "", "json", "key", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "extractJsonString", "findMatchingBrace", "", "text", "start", "findMatchingBracket", "parseComposableObject", "obj", "parseJsonParameters", "Lcom/skydoves/compose/stability/gradle/ParameterInfo;", "parseStabilityFile", "file", "Ljava/io/File;", "parseStabilityFromCompiler", "unescapeJson", "stability-gradle"})
@SourceDebugExtension(value={"SMAP\nStabilityCheckTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StabilityCheckTask.kt\ncom/skydoves/compose/stability/gradle/StabilityCheckTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,507:1\n1863#2,2:508\n1863#2,2:510\n1863#2,2:512\n1863#2,2:514\n1863#2:516\n1863#2,2:517\n1864#2:519\n*S KotlinDebug\n*F\n+ 1 StabilityCheckTask.kt\ncom/skydoves/compose/stability/gradle/StabilityCheckTask\n*L\n104#1:508,2\n291#1:510,2\n413#1:512,2\n417#1:514,2\n421#1:516\n446#1:517,2\n421#1:519\n*E\n"})
public abstract class StabilityCheckTask
extends DefaultTask {
    public StabilityCheckTask() {
        this.setGroup("verification");
        this.setDescription("Check composable stability against reference file");
    }

    @Internal
    @NotNull
    public abstract RegularFileProperty getStabilityInputFile();

    @Internal
    @NotNull
    public abstract DirectoryProperty getStabilityDir();

    @Input
    @NotNull
    public abstract ListProperty<String> getIgnoredPackages();

    @Input
    @NotNull
    public abstract ListProperty<String> getIgnoredClasses();

    @TaskAction
    public final void check() {
        Map<String, StabilityEntry> referenceStability;
        File inputFile;
        RegularFile regularFile = (RegularFile)this.getStabilityInputFile().getOrNull();
        File file = inputFile = regularFile != null ? regularFile.getAsFile() : null;
        if (inputFile == null || !inputFile.exists()) {
            this.getLogger().lifecycle("\u2139\ufe0f  No composables found in :" + this.getProject().getName() + ", skipping stability check");
            return;
        }
        File file2 = ((Directory)this.getStabilityDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"stabilityDir.get().asFile");
        File stabilityDirectory = file2;
        if (!stabilityDirectory.exists()) {
            this.getLogger().lifecycle("\u2139\ufe0f  No stability baseline found for :" + this.getProject().getName() + ", skipping stability check");
            this.getLogger().lifecycle("    Run './gradlew :" + this.getProject().getName() + ":stabilityDump' to create the baseline");
            return;
        }
        File referenceFile = FilesKt.resolve((File)stabilityDirectory, (String)(this.getProject().getName() + ".stability"));
        if (!referenceFile.exists()) {
            this.getLogger().lifecycle("\u2139\ufe0f  No stability baseline found for :" + this.getProject().getName() + ", skipping stability check");
            this.getLogger().lifecycle("    Run './gradlew :" + this.getProject().getName() + ":stabilityDump' to create the baseline");
            return;
        }
        Map<String, StabilityEntry> currentStability = this.parseStabilityFromCompiler(inputFile);
        List<StabilityDifference> differences = this.compareStability(currentStability, referenceStability = this.parseStabilityFile(referenceFile));
        if (!((Collection)differences).isEmpty()) {
            StringBuilder stringBuilder;
            StringBuilder $this$check_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$check_u24lambda_u240.append("\u274c Stability check failed!");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$check_u24lambda_u240.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = $this$check_u24lambda_u240.append("The following composables have changed stability:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$check_u24lambda_u240.append('\n'), (String)"append(...)");
            Iterable $this$forEach$iv = differences;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StabilityDifference diff = (StabilityDifference)element$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder4 = $this$check_u24lambda_u240.append(diff.format());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$check_u24lambda_u240.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder5 = $this$check_u24lambda_u240.append("If these changes are intentional, run './gradlew stabilityDump' to update the stability file.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String message = string;
            throw new GradleException(message);
        }
        this.getLogger().lifecycle("\u2705 Stability check passed.");
    }

    private final Map<String, StabilityEntry> parseStabilityFromCompiler(File file) {
        int objEnd;
        int objStart;
        String content = FilesKt.readText$default((File)file, null, (int)1, null);
        Map entries = new LinkedHashMap();
        int composablesStart = StringsKt.indexOf$default((CharSequence)content, (String)"\"composables\": [", (int)0, (boolean)false, (int)6, null);
        if (composablesStart == -1) {
            return entries;
        }
        int pos = composablesStart + 16;
        int endPos = StringsKt.lastIndexOf$default((CharSequence)content, (String)"]", (int)0, (boolean)false, (int)6, null);
        while (pos < endPos && (objStart = StringsKt.indexOf$default((CharSequence)content, (String)"{", (int)pos, (boolean)false, (int)4, null)) != -1 && objStart <= endPos && (objEnd = this.findMatchingBrace(content, objStart)) != -1) {
            String obj;
            Intrinsics.checkNotNullExpressionValue((Object)content.substring(objStart, objEnd + 1), (String)"substring(...)");
            StabilityEntry entry = this.parseComposableObject(obj);
            if (entry != null) {
                entries.put(entry.getQualifiedName(), entry);
            }
            pos = objEnd + 1;
        }
        return entries;
    }

    private final int findMatchingBrace(String text, int start) {
        int depth = 0;
        boolean inString = false;
        boolean escaped = false;
        int n = text.length();
        for (int i = start; i < n; ++i) {
            char c = text.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                inString = !inString;
                continue;
            }
            if (!inString && c == '{') {
                ++depth;
                continue;
            }
            if (inString || c != '}' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private final int findMatchingBracket(String text, int start) {
        int depth = 0;
        boolean inString = false;
        boolean escaped = false;
        int n = text.length();
        for (int i = start; i < n; ++i) {
            char c = text.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                inString = !inString;
                continue;
            }
            if (!inString && c == '[') {
                ++depth;
                continue;
            }
            if (inString || c != ']' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private final StabilityEntry parseComposableObject(String obj) {
        String string;
        String visibility;
        String string2 = this.extractJsonString(obj, "qualifiedName");
        if (string2 == null) {
            return null;
        }
        String qualifiedName = string2;
        String string3 = this.extractJsonString(obj, "simpleName");
        if (string3 == null) {
            return null;
        }
        String simpleName = string3;
        String string4 = this.extractJsonString(obj, "visibility");
        if (string4 == null) {
            string4 = visibility = "public";
        }
        if ((string = this.extractJsonString(obj, "returnType")) == null) {
            string = "Unit";
        }
        String returnType = string;
        Boolean bl = this.extractJsonBoolean(obj, "skippable");
        boolean skippable = bl != null ? bl : false;
        Boolean bl2 = this.extractJsonBoolean(obj, "restartable");
        boolean restartable = bl2 != null ? bl2 : true;
        List<ParameterInfo> parameters = this.parseJsonParameters(obj);
        return new StabilityEntry(qualifiedName, simpleName, visibility, parameters, returnType, skippable, restartable);
    }

    private final List<ParameterInfo> parseJsonParameters(String obj) {
        int paramEnd;
        int paramStart;
        List params = new ArrayList();
        int paramsStart = StringsKt.indexOf$default((CharSequence)obj, (String)"\"parameters\": [", (int)0, (boolean)false, (int)6, null);
        if (paramsStart == -1) {
            return params;
        }
        int pos = paramsStart + 15;
        int paramsEnd = this.findMatchingBracket(obj, paramsStart + 14);
        if (paramsEnd == -1) {
            return params;
        }
        while (pos < paramsEnd && (paramStart = StringsKt.indexOf$default((CharSequence)obj, (String)"{", (int)pos, (boolean)false, (int)4, null)) != -1 && paramStart <= paramsEnd && (paramEnd = this.findMatchingBrace(obj, paramStart)) != -1) {
            String string;
            String type;
            String string2;
            String name;
            String paramObj;
            Intrinsics.checkNotNullExpressionValue((Object)obj.substring(paramStart, paramEnd + 1), (String)"substring(...)");
            String string3 = this.extractJsonString(paramObj, "name");
            if (string3 == null) {
                string3 = name = "";
            }
            if ((string2 = this.extractJsonString(paramObj, "type")) == null) {
                string2 = type = "";
            }
            if ((string = this.extractJsonString(paramObj, "stability")) == null) {
                string = "UNSTABLE";
            }
            String stability = string;
            String reason = this.extractJsonString(paramObj, "reason");
            if (!Intrinsics.areEqual((Object)name, (Object)"<this>")) {
                params.add(new ParameterInfo(name, type, stability, reason));
            }
            pos = paramEnd + 1;
        }
        return params;
    }

    private final String extractJsonString(String json, String key) {
        String pattern = "\"" + key + "\":\\s*\"([^\"]*)\"";
        Regex regex = new Regex(pattern);
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)json, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return this.unescapeJson((String)match.getGroupValues().get(1));
    }

    private final Boolean extractJsonBoolean(String json, String key) {
        String pattern = "\"" + key + "\":\\s*(true|false)";
        Regex regex = new Regex(pattern);
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)json, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return Boolean.parseBoolean((String)match.getGroupValues().get(1));
    }

    private final String unescapeJson(String $this$unescapeJson) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$unescapeJson, (String)"\\\\", (String)"\\", (boolean)false, (int)4, null), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\\n", (String)"\n", (boolean)false, (int)4, null), (String)"\\r", (String)"\r", (boolean)false, (int)4, null), (String)"\\t", (String)"\t", (boolean)false, (int)4, null);
    }

    private final Map<String, StabilityEntry> parseStabilityFile(File file) {
        String[] entries = (String[])new LinkedHashMap();
        String currentQualifiedName = null;
        String currentSimpleName = null;
        String currentVisibility = null;
        String currentReturnType = null;
        List currentParams = null;
        currentParams = new ArrayList();
        boolean currentSkippable = false;
        boolean currentRestartable = false;
        boolean inParams = false;
        Iterable $this$forEach$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            String string2;
            String[] stringArray;
            String qn;
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)line, (String)"@Composable", (boolean)false, (int)2, null)) {
                if (currentQualifiedName != null && currentSimpleName != null) {
                    String string3;
                    qn = currentQualifiedName;
                    String sn = currentSimpleName;
                    stringArray = entries;
                    String string4 = currentVisibility;
                    if (string4 == null) {
                        string4 = "public";
                    }
                    if ((string3 = currentReturnType) == null) {
                        string3 = "Unit";
                    }
                    StabilityEntry stabilityEntry = new StabilityEntry(qn, sn, string4, currentParams, string3, currentSkippable, currentRestartable);
                    stringArray.put(qn, stabilityEntry);
                }
                currentParams = new ArrayList();
                inParams = false;
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"public ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"internal ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"private ", (boolean)false, (int)2, null)) {
                String qn2;
                currentVisibility = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)line, (String)" fun ", null, (int)2, null))).toString();
                String signature = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)" fun ", null, (int)2, null))).toString();
                currentQualifiedName = qn2 = StringsKt.substringBefore$default((String)signature, (String)"(", null, (int)2, null);
                currentSimpleName = StringsKt.substringAfterLast$default((String)qn2, (String)".", null, (int)2, null);
                if (!StringsKt.contains$default((CharSequence)signature, (CharSequence)"): ", (boolean)false, (int)2, null)) continue;
                currentReturnType = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfterLast$default((String)signature, (String)"): ", null, (int)2, null))).toString();
                continue;
            }
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"skippable:", (boolean)false, (int)2, null)) {
                currentSkippable = Boolean.parseBoolean(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                continue;
            }
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"restartable:", (boolean)false, (int)2, null)) {
                currentRestartable = Boolean.parseBoolean(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                continue;
            }
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"params:", (boolean)false, (int)2, null)) {
                inParams = true;
                continue;
            }
            if (inParams && StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"- ", (boolean)false, (int)2, null)) {
                String paramLine = StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (CharSequence)"- ");
                List parts = StringsKt.split$default((CharSequence)paramLine, (String[])(stringArray = new String[]{": "}), (boolean)false, (int)2, (int)2, null);
                if (parts.size() != 2) continue;
                String name = ((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
                String stabilityAndReason = (String)parts.get(1);
                if (Intrinsics.areEqual((Object)name, (Object)"<this>")) continue;
                String stability = null;
                String reason = null;
                if (StringsKt.contains$default((CharSequence)stabilityAndReason, (CharSequence)" (", (boolean)false, (int)2, null)) {
                    stability = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)stabilityAndReason, (String)" (", null, (int)2, null))).toString();
                    reason = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)stabilityAndReason, (String)" (", null, (int)2, null), (String)")", null, (int)2, null))).toString();
                } else {
                    stability = ((Object)StringsKt.trim((CharSequence)stabilityAndReason)).toString();
                    reason = null;
                }
                currentParams.add(new ParameterInfo(name, "", stability, reason));
                continue;
            }
            if (!StringsKt.isBlank((CharSequence)line) || currentQualifiedName == null) continue;
            qn = currentQualifiedName;
            String[] stringArray2 = entries;
            String string5 = currentSimpleName;
            if (string5 == null) {
                string5 = "";
            }
            if ((string2 = currentVisibility) == null) {
                string2 = "public";
            }
            if ((string = currentReturnType) == null) {
                string = "Unit";
            }
            stringArray = new StabilityEntry(qn, string5, string2, currentParams, string, currentSkippable, currentRestartable);
            stringArray2.put(qn, stringArray);
            currentQualifiedName = null;
            currentParams = new ArrayList();
            inParams = false;
        }
        if (currentQualifiedName != null && currentSimpleName != null) {
            String string;
            String qn = currentQualifiedName;
            String sn = currentSimpleName;
            String[] stringArray = entries;
            String string6 = currentVisibility;
            if (string6 == null) {
                string6 = "public";
            }
            if ((string = currentReturnType) == null) {
                string = "Unit";
            }
            StabilityEntry stabilityEntry = new StabilityEntry(qn, sn, string6, currentParams, string, currentSkippable, currentRestartable);
            stringArray.put(qn, stabilityEntry);
        }
        return entries;
    }

    private final List<StabilityDifference> compareStability(Map<String, StabilityEntry> current, Map<String, StabilityEntry> reference) {
        String functionName;
        List differences = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.subtract((Iterable)current.keySet(), (Iterable)reference.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            functionName = (String)element$iv;
            boolean bl = false;
            differences.add(new StabilityDifference.NewFunction(functionName));
        }
        $this$forEach$iv = CollectionsKt.subtract((Iterable)reference.keySet(), (Iterable)current.keySet());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            functionName = (String)element$iv;
            boolean bl = false;
            differences.add(new StabilityDifference.RemovedFunction(functionName));
        }
        $this$forEach$iv = CollectionsKt.intersect((Iterable)current.keySet(), (Iterable)reference.keySet());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StabilityEntry referenceEntry;
            StabilityEntry currentEntry;
            functionName = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)current.get(functionName));
            Intrinsics.checkNotNull((Object)reference.get(functionName));
            if (currentEntry.getSkippable() != referenceEntry.getSkippable()) {
                differences.add(new StabilityDifference.SkippabilityChanged(functionName, referenceEntry.getSkippable(), currentEntry.getSkippable()));
            }
            if (currentEntry.getParameters().size() != referenceEntry.getParameters().size()) {
                differences.add(new StabilityDifference.ParameterCountChanged(functionName, referenceEntry.getParameters().size(), currentEntry.getParameters().size()));
                continue;
            }
            Iterable $this$forEach$iv2 = CollectionsKt.zip((Iterable)currentEntry.getParameters(), (Iterable)referenceEntry.getParameters());
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair pair = (Pair)element$iv2;
                boolean bl2 = false;
                ParameterInfo current2 = (ParameterInfo)pair.component1();
                ParameterInfo ref = (ParameterInfo)pair.component2();
                if (Intrinsics.areEqual((Object)current2.getStability(), (Object)ref.getStability())) continue;
                differences.add(new StabilityDifference.ParameterStabilityChanged(functionName, current2.getName(), ref.getStability(), current2.getStability()));
            }
        }
        return differences;
    }
}

