/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.compose.stability.gradle;

import com.skydoves.compose.stability.gradle.ParameterInfo;
import com.skydoves.compose.stability.gradle.StabilityDumpTask;
import com.skydoves.compose.stability.gradle.StabilityEntry;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J8\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001b2\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u0010*\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\f\u0010+\u001a\u00020\u0005*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006,"}, d2={"Lcom/skydoves/compose/stability/gradle/StabilityDumpTask;", "Lorg/gradle/api/DefaultTask;", "()V", "ignoredClasses", "Lorg/gradle/api/provider/ListProperty;", "", "getIgnoredClasses", "()Lorg/gradle/api/provider/ListProperty;", "ignoredPackages", "getIgnoredPackages", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "stabilityInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getStabilityInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "dump", "", "extractJsonBoolean", "", "json", "key", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "extractJsonString", "filterStabilityInfo", "", "Lcom/skydoves/compose/stability/gradle/StabilityEntry;", "entries", "findMatchingBrace", "", "text", "start", "findMatchingBracket", "parseComposableObject", "obj", "parseParameters", "Lcom/skydoves/compose/stability/gradle/ParameterInfo;", "parseStabilityInfo", "file", "Ljava/io/File;", "writeStabilityFile", "unescapeJson", "stability-gradle"})
@SourceDebugExtension(value={"SMAP\nStabilityDumpTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StabilityDumpTask.kt\ncom/skydoves/compose/stability/gradle/StabilityDumpTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n774#2:325\n865#2:326\n1755#2,3:327\n866#2:330\n1053#2:331\n1863#2:332\n1863#2,2:333\n1864#2:335\n*S KotlinDebug\n*F\n+ 1 StabilityDumpTask.kt\ncom/skydoves/compose/stability/gradle/StabilityDumpTask\n*L\n252#1:325\n252#1:326\n256#1:327,3\n252#1:330\n281#1:331\n281#1:332\n289#1:333,2\n281#1:335\n*E\n"})
public abstract class StabilityDumpTask
extends DefaultTask {
    public StabilityDumpTask() {
        this.setGroup("verification");
        this.setDescription("Dump composable stability information to stability file");
    }

    @Internal
    @NotNull
    public abstract RegularFileProperty getStabilityInputFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Input
    @NotNull
    public abstract ListProperty<String> getIgnoredPackages();

    @Input
    @NotNull
    public abstract ListProperty<String> getIgnoredClasses();

    @TaskAction
    public final void dump() {
        File inputFile;
        RegularFile regularFile = (RegularFile)this.getStabilityInputFile().getOrNull();
        File file = inputFile = regularFile != null ? regularFile.getAsFile() : null;
        if (inputFile == null || !inputFile.exists()) {
            this.getLogger().lifecycle("\u2139\ufe0f  No composables found in :" + this.getProject().getName() + ", skipping stability dump");
            return;
        }
        File file2 = ((Directory)this.getOutputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"outputDir.get().asFile");
        File outputDirectory = file2;
        outputDirectory.mkdirs();
        File outputFile = FilesKt.resolve((File)outputDirectory, (String)(this.getProject().getName() + ".stability"));
        List<StabilityEntry> stabilityInfo = this.parseStabilityInfo(inputFile);
        Object object = this.getIgnoredPackages().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ignoredPackages.get()");
        List list = (List)object;
        Object object2 = this.getIgnoredClasses().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ignoredClasses.get()");
        List<StabilityEntry> filtered = this.filterStabilityInfo(stabilityInfo, list, (List)object2);
        this.writeStabilityFile(outputFile, filtered);
        this.getLogger().lifecycle("Stability file written to: " + outputFile.getAbsolutePath());
    }

    private final List<StabilityEntry> parseStabilityInfo(File file) {
        int objEnd;
        int objStart;
        String content = FilesKt.readText$default((File)file, null, (int)1, null);
        List entries = new ArrayList();
        int composablesStart = StringsKt.indexOf$default((CharSequence)content, (String)"\"composables\": [", (int)0, (boolean)false, (int)6, null);
        if (composablesStart == -1) {
            return entries;
        }
        int pos = composablesStart + 16;
        int endPos = StringsKt.lastIndexOf$default((CharSequence)content, (String)"]", (int)0, (boolean)false, (int)6, null);
        while (pos < endPos && (objStart = StringsKt.indexOf$default((CharSequence)content, (String)"{", (int)pos, (boolean)false, (int)4, null)) != -1 && objStart <= endPos && (objEnd = this.findMatchingBrace(content, objStart)) != -1) {
            String obj;
            Intrinsics.checkNotNullExpressionValue((Object)content.substring(objStart, objEnd + 1), (String)"substring(...)");
            StabilityEntry entry = this.parseComposableObject(obj);
            if (entry != null) {
                entries.add(entry);
            }
            pos = objEnd + 1;
        }
        return entries;
    }

    private final int findMatchingBrace(String text, int start) {
        int depth = 0;
        boolean inString = false;
        boolean escaped = false;
        int n = text.length();
        for (int i = start; i < n; ++i) {
            char c = text.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                inString = !inString;
                continue;
            }
            if (!inString && c == '{') {
                ++depth;
                continue;
            }
            if (inString || c != '}' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private final StabilityEntry parseComposableObject(String obj) {
        String string;
        String visibility;
        String string2 = this.extractJsonString(obj, "qualifiedName");
        if (string2 == null) {
            return null;
        }
        String qualifiedName = string2;
        String string3 = this.extractJsonString(obj, "simpleName");
        if (string3 == null) {
            return null;
        }
        String simpleName = string3;
        String string4 = this.extractJsonString(obj, "visibility");
        if (string4 == null) {
            string4 = visibility = "public";
        }
        if ((string = this.extractJsonString(obj, "returnType")) == null) {
            string = "Unit";
        }
        String returnType = string;
        Boolean bl = this.extractJsonBoolean(obj, "skippable");
        boolean skippable = bl != null ? bl : false;
        Boolean bl2 = this.extractJsonBoolean(obj, "restartable");
        boolean restartable = bl2 != null ? bl2 : true;
        List<ParameterInfo> parameters = this.parseParameters(obj);
        return new StabilityEntry(qualifiedName, simpleName, visibility, parameters, returnType, skippable, restartable);
    }

    private final List<ParameterInfo> parseParameters(String obj) {
        int paramEnd;
        int paramStart;
        List params = new ArrayList();
        int paramsStart = StringsKt.indexOf$default((CharSequence)obj, (String)"\"parameters\": [", (int)0, (boolean)false, (int)6, null);
        if (paramsStart == -1) {
            return params;
        }
        int pos = paramsStart + 15;
        int paramsEnd = this.findMatchingBracket(obj, paramsStart + 14);
        if (paramsEnd == -1) {
            return params;
        }
        while (pos < paramsEnd && (paramStart = StringsKt.indexOf$default((CharSequence)obj, (String)"{", (int)pos, (boolean)false, (int)4, null)) != -1 && paramStart <= paramsEnd && (paramEnd = this.findMatchingBrace(obj, paramStart)) != -1) {
            String string;
            String type;
            String string2;
            String name;
            String paramObj;
            Intrinsics.checkNotNullExpressionValue((Object)obj.substring(paramStart, paramEnd + 1), (String)"substring(...)");
            String string3 = this.extractJsonString(paramObj, "name");
            if (string3 == null) {
                string3 = name = "";
            }
            if ((string2 = this.extractJsonString(paramObj, "type")) == null) {
                string2 = type = "";
            }
            if ((string = this.extractJsonString(paramObj, "stability")) == null) {
                string = "UNSTABLE";
            }
            String stability = string;
            String reason = this.extractJsonString(paramObj, "reason");
            if (!Intrinsics.areEqual((Object)name, (Object)"<this>")) {
                params.add(new ParameterInfo(name, type, stability, reason));
            }
            pos = paramEnd + 1;
        }
        return params;
    }

    private final int findMatchingBracket(String text, int start) {
        int depth = 0;
        boolean inString = false;
        boolean escaped = false;
        int n = text.length();
        for (int i = start; i < n; ++i) {
            char c = text.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                inString = !inString;
                continue;
            }
            if (!inString && c == '[') {
                ++depth;
                continue;
            }
            if (inString || c != ']' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private final String extractJsonString(String json, String key) {
        String pattern = "\"" + key + "\":\\s*\"([^\"]*)\"";
        Regex regex = new Regex(pattern);
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)json, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return this.unescapeJson((String)match.getGroupValues().get(1));
    }

    private final Boolean extractJsonBoolean(String json, String key) {
        String pattern = "\"" + key + "\":\\s*(true|false)";
        Regex regex = new Regex(pattern);
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)json, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return Boolean.parseBoolean((String)match.getGroupValues().get(1));
    }

    private final String unescapeJson(String $this$unescapeJson) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$unescapeJson, (String)"\\\\", (String)"\\", (boolean)false, (int)4, null), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\\n", (String)"\n", (boolean)false, (int)4, null), (String)"\\r", (String)"\r", (boolean)false, (int)4, null), (String)"\\t", (String)"\t", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<StabilityEntry> filterStabilityInfo(List<StabilityEntry> entries, List<String> ignoredPackages, List<String> ignoredClasses) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = entries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            String className;
            block4: {
                StabilityEntry entry = (StabilityEntry)element$iv$iv;
                boolean bl2 = false;
                String packageName = StringsKt.substringBeforeLast((String)entry.getQualifiedName(), (char)'.', (String)"");
                className = StringsKt.substringAfterLast$default((String)entry.getQualifiedName(), (char)'.', null, (int)2, null);
                Iterable $this$any$iv = ignoredPackages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)packageName, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!(!bl && !ignoredClasses.contains(className))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeStabilityFile(File file, List<StabilityEntry> entries) {
        if (entries.isEmpty()) {
            if (file.exists()) {
                file.delete();
                this.getLogger().lifecycle("No composables found - removed " + file.getName());
            }
            return;
        }
        Object object = file;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object = (object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            void $this$forEach$iv;
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            writer.write("// This file was automatically generated by Compose Stability Analyzer\n");
            writer.write("// https://github.com/skydoves/compose-stability-analyzer\n");
            writer.write("//\n");
            writer.write("// Do not edit this file directly. To update it, run:\n");
            writer.write("//   ./gradlew :" + this.getProject().getName() + ":stabilityDump\n");
            writer.write("\n");
            Iterable $this$sortedBy$iv = entries;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    StabilityEntry it = (StabilityEntry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getQualifiedName());
                    it = (StabilityEntry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getQualifiedName())));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StabilityEntry entry = (StabilityEntry)element$iv;
                boolean bl2 = false;
                writer.write("@Composable\n");
                writer.write(entry.getVisibility() + " fun " + entry.getQualifiedName() + "(");
                writer.write(CollectionsKt.joinToString$default((Iterable)entry.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)writeStabilityFile.1.2.1.INSTANCE, (int)30, null));
                writer.write("): " + entry.getReturnType() + "\n");
                writer.write("  skippable: " + entry.getSkippable() + "\n");
                writer.write("  restartable: " + entry.getRestartable() + "\n");
                writer.write("  params:\n");
                Iterable $this$forEach$iv2 = entry.getParameters();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ParameterInfo param = (ParameterInfo)element$iv2;
                    boolean bl3 = false;
                    writer.write("    - " + param.getName() + ": " + param.getStability());
                    if (param.getReason() != null) {
                        writer.write(" (" + param.getReason() + ")");
                    }
                    writer.write("\n");
                }
                writer.write("\n");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

