/*
 *
 */
package com.github.sleroy.junit.mail.server;

import java.io.IOException;
import java.io.InputStream;

import org.subethamail.smtp.helper.SimpleMessageListener;

/**
 * Listens to incoming emails and redirects them to the {@code MailSaver}
 * object.
 *
 * @author Nilhcem
 * @since 1.0
 */
public final class MailListener implements SimpleMessageListener {
    private final MailSaverInterface saver;

    /**
     * Creates the listener.
     *
     * @param saver
     *            a {@code MailServer} object used to save emails and notify
     *            components.
     */
    public MailListener(final MailSaverInterface saver) {
	this.saver = saver;
    }

    /**
     * Accepts all kind of email <i>(always return true)</i>.
     * <p>
     * Called once for every RCPT TO during a SMTP exchange.<br>
     * Each accepted recipient will result in a separate deliver() call later.
     * </p>
     *
     * @param from
     *            the user who send the email.
     * @param recipient
     *            the recipient of the email.
     * @return always return {@code true}
     */
    @Override
    public boolean accept(final String from, final String recipient) {
	return true;
    }

    /**
     * Receives emails and forwards them to the {@link MailSaver} object.
     */
    @Override
    public void deliver(final String from, final String recipient, final InputStream data) throws IOException {
	saver.saveEmailAndNotify(from, recipient, data);
    }
}
