/*
 * Decompiled with CFR 0.152.
 */
package com.github.sleroy.fakesmtp.core;

import com.github.sleroy.fakesmtp.core.Authentication;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ServerConfiguration {
    private String port = "25";
    private String bindAddress;
    private String storageCharsetName = Charset.defaultCharset().name();
    private Authentication authentication = new Authentication();
    private List<String> relayDomains = Collections.emptyList();

    public static ServerConfiguration create() {
        return new ServerConfiguration();
    }

    public ServerConfiguration auth(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public ServerConfiguration bind(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public ServerConfiguration charset(String storageCharset) {
        this.storageCharsetName = storageCharset;
        return this;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getPort() {
        return this.port;
    }

    public List<String> getRelayDomains() {
        return this.relayDomains;
    }

    public Charset getStorageCharset() {
        return Charset.forName(this.storageCharsetName);
    }

    public String getStorageCharSetName() {
        return this.storageCharsetName;
    }

    public ServerConfiguration password(String password) {
        this.authentication.setPassword(password);
        return this;
    }

    public ServerConfiguration port(int port) {
        this.port = Integer.toString(port);
        return this;
    }

    public ServerConfiguration port(String port) {
        this.port = port;
        return this;
    }

    public ServerConfiguration relayDomains(String ... domains) {
        this.relayDomains = Arrays.asList(domains);
        return this;
    }

    public ServerConfiguration relayDomainsList(List<String> relayDomains) {
        this.relayDomains = relayDomains;
        return this;
    }

    public String toString() {
        return "ServerConfiguration [port=" + this.port + ", bindAddress=" + this.bindAddress + ", storageCharsetName=" + this.storageCharsetName + ", authentication=" + this.authentication + "]";
    }

    public ServerConfiguration userName(String userName) {
        this.authentication.setUserName(userName);
        return this;
    }
}

