/*
 * Decompiled with CFR 0.152.
 */
package com.github.sleroy.fakesmtp.model;

import com.github.sleroy.fakesmtp.model.EmailModel;
import com.github.sleroy.junit.mail.server.events.DeleteAllMailEvent;
import com.github.sleroy.junit.mail.server.events.NewMailEvent;
import com.github.sleroy.junit.mail.server.events.RejectedMailEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServerModel
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailServerModel.class);
    private int nbMessageReceived = 0;
    private final List<EmailModel> emailModels = new ArrayList<EmailModel>(100);
    private final List<EmailModel> rejectedMails = new ArrayList<EmailModel>(100);

    protected void deletAllMails() {
        LOGGER.info("Received event to delete all the mails");
        this.emailModels.clear();
        this.rejectedMails.clear();
    }

    public List<EmailModel> getEmailModels() {
        return this.emailModels;
    }

    public int getNbMessageReceived() {
        return this.nbMessageReceived;
    }

    public List<EmailModel> getRejectedMails() {
        return this.rejectedMails;
    }

    private void rejectedMail(EmailModel model) {
        LOGGER.info("A mail has been rejected : {}", (Object)model);
        this.rejectedMails.add(model);
    }

    protected void saveMail(EmailModel email) {
        LOGGER.info("Has received mail : {}", (Object)email);
        this.emailModels.add(email);
    }

    public void setNbMessageReceived(int nbMessageReceived) {
        this.nbMessageReceived = nbMessageReceived;
    }

    public String toString() {
        return "MailServerModel [nbMessageReceived=" + this.nbMessageReceived + ", emailModels=" + this.emailModels + ", rejectedMails=" + this.rejectedMails + "]";
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof NewMailEvent) {
            this.saveMail(((NewMailEvent)arg).getModel());
        } else if (arg instanceof DeleteAllMailEvent) {
            this.deletAllMails();
        } else if (arg instanceof RejectedMailEvent) {
            this.rejectedMail(((RejectedMailEvent)arg).getModel());
        }
    }
}

