/*
 * Decompiled with CFR 0.152.
 */
package com.github.sleroy.junit.mail.server;

import com.github.sleroy.fakesmtp.core.exception.BindPortException;
import com.github.sleroy.fakesmtp.core.exception.OutOfRangePortException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.helper.SimpleMessageListenerAdapter;
import org.subethamail.smtp.server.SMTPServer;

public class SMTPServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMTPServerHandler.class);
    private final SMTPServer smtpServer;

    public SMTPServerHandler(SimpleMessageListener mailListener, AuthenticationHandlerFactory smtpAuthHandlerFactory) {
        this.smtpServer = new SMTPServer((MessageHandlerFactory)new SimpleMessageListenerAdapter(mailListener), smtpAuthHandlerFactory);
    }

    public boolean isRunning() {
        return this.smtpServer.isRunning();
    }

    public void startServer(int port, InetAddress bindAddress) throws BindPortException, OutOfRangePortException {
        LOGGER.debug("Starting server on port {}", (Object)port);
        try {
            this.smtpServer.setBindAddress(bindAddress);
            this.smtpServer.setPort(port);
            this.smtpServer.start();
        }
        catch (RuntimeException exception) {
            if (exception.getMessage().contains("BindException")) {
                LOGGER.error("{}. Port {}", (Object)exception.getMessage(), (Object)port);
                throw new BindPortException(exception, port);
            }
            if (exception.getMessage().contains("out of range")) {
                LOGGER.error("Port {} out of range.", (Object)port);
                throw new OutOfRangePortException(exception, port);
            }
            LOGGER.error("", (Throwable)exception);
            throw exception;
        }
    }

    public void stopServer() {
        if (this.smtpServer.isRunning()) {
            LOGGER.debug("Stopping server");
            this.smtpServer.stop();
        }
    }
}

