/*
 * Decompiled with CFR 0.152.
 */
package com.github.sleroy.junit.mail.server.test;

import com.github.sleroy.fakesmtp.core.ServerConfiguration;
import com.github.sleroy.fakesmtp.model.EmailModel;
import com.github.sleroy.junit.mail.server.MailServer;
import com.github.sleroy.junit.mail.server.test.FakeSmtpRuleException;
import java.util.List;
import org.junit.rules.ExternalResource;

public class FakeSmtpRule
extends ExternalResource {
    private final ServerConfiguration serverConfiguration;
    private MailServer mailServer;

    public FakeSmtpRule(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    protected void after() {
        super.after();
        try {
            if (this.mailServer != null) {
                this.mailServer.close();
            }
            this.mailServer = null;
        }
        catch (Exception e) {
            throw new FakeSmtpRuleException(e);
        }
    }

    protected void before() throws Throwable {
        this.mailServer = new MailServer(this.serverConfiguration);
        this.mailServer.start();
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public boolean isRunning() {
        return this.mailServer != null && this.mailServer.isRunning();
    }

    public List<EmailModel> mailBox() {
        return this.mailServer.getMails();
    }

    public List<EmailModel> rejectedMails() {
        return this.mailServer.getRejectedMails();
    }

    public List<String> relayDomains() {
        return this.mailServer.getRelayDomains();
    }
}

