/*
 * Decompiled with CFR 0.152.
 */
package com.github.sleroy.junit.mail.server;

import com.github.sleroy.fakesmtp.core.ServerConfiguration;
import com.github.sleroy.fakesmtp.model.EmailModel;
import com.github.sleroy.junit.mail.server.MailSaverInterface;
import com.github.sleroy.junit.mail.server.events.NewMailEvent;
import com.github.sleroy.junit.mail.server.events.RejectedMailEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailSaver
extends Observable
implements MailSaverInterface {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MailSaver.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern SUBJECT_PATTERN = Pattern.compile("^Subject: (.*)$");
    protected Charset storageCharSet;
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyhhmmssSSS");
    private final ServerConfiguration serverConfiguration;

    public MailSaver(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
        this.storageCharSet = serverConfiguration.getStorageCharset();
        Validate.notNull((Object)serverConfiguration);
        Validate.notNull((Object)this.storageCharSet);
    }

    private String convertStreamToString(InputStream is) {
        long lineNbToStartCopy = 4L;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, this.storageCharSet));
        StringBuilder sb = new StringBuilder();
        long lineNb = 0L;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (++lineNb <= 4L) continue;
                sb.append(line).append(LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not convert the stream.", (Throwable)e);
        }
        return sb.toString();
    }

    public Object getLock() {
        return this;
    }

    private String getSubjectFromStr(String data) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(data));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = SUBJECT_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                return matcher.group(1);
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot obtain the subject", (Throwable)e);
        }
        return "";
    }

    private boolean isMatchingRelayDomains(String to, List<String> relayDomains) {
        if (relayDomains != null) {
            LOGGER.debug("Relay domains are defined : ", relayDomains);
            boolean matches = false;
            for (String domain : relayDomains) {
                if (!to.endsWith(domain)) continue;
                LOGGER.debug("The domain is matching : ", (Object)domain);
                matches = true;
                break;
            }
            if (!matches) {
                LOGGER.debug("Destination {} doesn't match relay domains", (Object)to);
                return false;
            }
        } else {
            LOGGER.debug("No relay domain has been defined, no filtering");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveEmailAndNotify(String from, String to, InputStream data) {
        List<String> relayDomains = this.serverConfiguration.getRelayDomains();
        EmailModel model = new EmailModel();
        model.setFrom(from);
        model.setTo(to);
        String mailContent = this.convertStreamToString(data);
        model.setSubject(this.getSubjectFromStr(mailContent));
        model.setEmailStr(mailContent);
        model.setReceivedDate(new Date());
        if (!this.isMatchingRelayDomains(to, relayDomains)) {
            this.setChanged();
            this.notifyObservers(new RejectedMailEvent(model));
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            this.setChanged();
            this.notifyObservers(new NewMailEvent(model));
        }
    }
}

