/*
 * Decompiled with CFR 0.152.
 */
package com.github.sleroy.junit.mail.server;

import com.github.sleroy.fakesmtp.core.ServerConfiguration;
import com.github.sleroy.fakesmtp.core.exception.BindPortException;
import com.github.sleroy.fakesmtp.core.exception.InvalidHostException;
import com.github.sleroy.fakesmtp.core.exception.InvalidPortException;
import com.github.sleroy.fakesmtp.core.exception.OutOfRangePortException;
import com.github.sleroy.fakesmtp.model.EmailModel;
import com.github.sleroy.fakesmtp.model.MailServerModel;
import com.github.sleroy.junit.mail.server.MailListener;
import com.github.sleroy.junit.mail.server.MailSaver;
import com.github.sleroy.junit.mail.server.SMTPAuthHandler;
import com.github.sleroy.junit.mail.server.SMTPAuthHandlerFactory;
import com.github.sleroy.junit.mail.server.SMTPServerHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailServer.class);
    private SMTPAuthHandler smtpAuthHandler;
    private final ServerConfiguration serverConfiguration;
    private MailSaver mailSaver;
    private MailListener mailListener;
    private SMTPAuthHandlerFactory smtpAuthHandlerFactory;
    private SMTPServerHandler smtpServerHandler;
    private MailServerModel mailServerModel;
    private boolean started = false;

    public MailServer(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    public void close() throws Exception {
        LOGGER.info("Stopping the server");
        if (this.smtpServerHandler != null) {
            this.smtpServerHandler.stopServer();
        }
    }

    public List<EmailModel> getMails() {
        return this.mailServerModel.getEmailModels();
    }

    public List<EmailModel> getRejectedMails() {
        return this.mailServerModel.getRejectedMails();
    }

    public List<String> getRelayDomains() {
        return this.serverConfiguration.getRelayDomains();
    }

    public boolean isRunning() {
        return this.started;
    }

    public void start() throws BindPortException, OutOfRangePortException, InvalidPortException, InvalidHostException {
        if (this.started) {
            LOGGER.warn("The server has been already started");
        } else {
            LOGGER.info("Configuration of the server. {}", (Object)this.serverConfiguration);
            this.mailServerModel = new MailServerModel();
            this.smtpAuthHandler = new SMTPAuthHandler(this.serverConfiguration.getAuthentication().getUserName(), this.serverConfiguration.getAuthentication().getPassword());
            this.smtpAuthHandlerFactory = new SMTPAuthHandlerFactory(this.smtpAuthHandler);
            this.mailSaver = new MailSaver(this.serverConfiguration);
            this.mailSaver.addObserver(this.mailServerModel);
            this.mailListener = new MailListener(this.mailSaver);
            this.smtpServerHandler = new SMTPServerHandler(this.mailListener, this.smtpAuthHandlerFactory);
            String hostStr = this.serverConfiguration.getBindAddress();
            this.started = false;
            try {
                int port = Integer.parseInt(this.serverConfiguration.getPort());
                InetAddress host = null;
                if (hostStr != null && !hostStr.isEmpty()) {
                    host = InetAddress.getByName(hostStr);
                }
                this.smtpServerHandler.startServer(port, host);
                this.started = true;
            }
            catch (NumberFormatException e) {
                throw new InvalidPortException(e);
            }
            catch (UnknownHostException e) {
                throw new InvalidHostException(e, hostStr);
            }
        }
    }
}

