/*
 * Decompiled with CFR 0.152.
 */
package org.scriptlet4docx.docx;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.util.StringUtils;

class DividedScriptWrapsProcessor {
    private static String placeholder = UUID.randomUUID().toString();
    private static String ANY_TAG = "\\s*(<[^<>]*>\\s*)*";
    private static Pattern dollarPattern = Pattern.compile("\\$" + ANY_TAG + "\\{", 40);
    private static Pattern ltPattern = Pattern.compile("&lt;" + ANY_TAG + "%", 40);
    private static Pattern gtPattern = Pattern.compile("%" + ANY_TAG + "\\&gt;", 40);
    private static Pattern ltOutPattern = Pattern.compile("&lt;%" + ANY_TAG + "=", 40);

    DividedScriptWrapsProcessor() {
    }

    static String process(String template) {
        template = DividedScriptWrapsProcessor.processCommon(template, dollarPattern, "${");
        template = DividedScriptWrapsProcessor.processCommon(template, ltPattern, "&lt;%");
        template = DividedScriptWrapsProcessor.processCommon(template, ltOutPattern, "&lt;%=");
        template = DividedScriptWrapsProcessor.processCommon(template, gtPattern, "%&gt;");
        return template;
    }

    private static String processCommon(String template, Pattern pattern, String replacer) {
        Matcher m = pattern.matcher(template);
        String noMatchingParts = m.replaceAll(placeholder);
        String res = StringUtils.replace((String)noMatchingParts, (String)placeholder, (String)replacer);
        return res;
    }
}

