/*
 * Decompiled with CFR 0.152.
 */
package org.scriptlet4docx.docx;

import groovy.text.GStringTemplateEngine;
import groovy.text.TemplateEngine;
import groovy.util.AntBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.scriptlet4docx.docx.DeleteOnCloseFileInputStream;
import org.scriptlet4docx.docx.DividedScriptWrapsProcessor;
import org.scriptlet4docx.docx.Placeholder;
import org.scriptlet4docx.docx.TableScriptingProcessor;
import org.scriptlet4docx.docx.TemplateContent;
import org.scriptlet4docx.docx.TemplateFileManager;
import org.scriptlet4docx.util.string.StringUtil;
import org.scriptlet4docx.util.xml.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocxTemplater {
    private File pathToDocx;
    private InputStream templateStream;
    private String streamTemplateKey;
    private TemplateEngine templateEngine;
    private static Pattern scriptPattern = Pattern.compile("((&lt;%=?(.*?)%&gt;)|\\$\\{(.*?)\\})", 40);
    private static String NEW_LINE_PLACEHOLDER = "26f679ad-e7fd-4d42-9e05-946f393c277d";
    static String CLASS_NAME = DocxTemplater.class.getCanonicalName();
    static Logger logger = Logger.getLogger(CLASS_NAME);
    static final String UTIL_FUNC_HOLDER = "__docxTemplaterInstance";
    static final String NULL_REPLACER_REF = "__docxTemplaterInstance.replaceIfNull";
    private String nullReplacement;

    public DocxTemplater(File pathToDocx) {
        this.setTemplateEngine((TemplateEngine)new GStringTemplateEngine());
        this.nullReplacement = "";
        this.pathToDocx = pathToDocx;
    }

    public DocxTemplater(InputStream inputStream, String templateKey) {
        this.setTemplateEngine((TemplateEngine)new GStringTemplateEngine());
        this.nullReplacement = "";
        this.templateStream = inputStream;
        this.streamTemplateKey = templateKey;
    }

    protected TemplateContent cleanupTemplate(TemplateContent content) {
        ArrayList<TemplateContent.ContentItem> items = new ArrayList<TemplateContent.ContentItem>();
        for (int i = 0; i < content.getItems().size(); ++i) {
            items.add(new TemplateContent.ContentItem(content.getItems().get(i).getIdentifier(), this.cleanupTemplate(content.getItems().get(i).getContent())));
        }
        return new TemplateContent(items);
    }

    protected String cleanupTemplate(String template) {
        template = DividedScriptWrapsProcessor.process(template);
        template = TableScriptingProcessor.process(template);
        return template;
    }

    protected TemplateContent processCleanedTemplate(TemplateContent content, Map<String, Object> params) throws CompilationFailedException, ClassNotFoundException, IOException {
        ArrayList<TemplateContent.ContentItem> items = new ArrayList<TemplateContent.ContentItem>();
        for (int i = 0; i < content.getItems().size(); ++i) {
            items.add(new TemplateContent.ContentItem(content.getItems().get(i).getIdentifier(), this.processCleanedTemplate(content.getItems().get(i).getContent(), params)));
        }
        return new TemplateContent(items);
    }

    protected static Map<String, Object> processParams(Map<String, Object> params) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : params.entrySet()) {
            Object v = e.getValue();
            if (v instanceof String) {
                String sv = (String)v;
                sv = sv.replace("\r\n", "\n");
                sv = sv.replace("\n", NEW_LINE_PLACEHOLDER);
                v = sv;
            }
            res.put(e.getKey(), v);
        }
        return res;
    }

    protected String processCleanedTemplate(String template, Map<String, Object> params) throws CompilationFailedException, ClassNotFoundException, IOException {
        String string;
        String string2;
        String methodName = "processScriptedTemplate";
        params = DocxTemplater.processParams(params);
        String replacement = UUID.randomUUID().toString();
        ArrayList<Placeholder> scripts = new ArrayList<Placeholder>();
        Matcher m = scriptPattern.matcher(template);
        while (m.find()) {
            String scriptText = m.group(0);
            Placeholder ph = new Placeholder(UUID.randomUUID().toString(), scriptText, Placeholder.PlaceholderType.SCRIPT);
            if (ph.scriptWrap == Placeholder.ScriptWraps.DOLLAR_PRINT) {
                ph.setScriptTextNoWrap(m.group(4));
            } else if (ph.scriptWrap == Placeholder.ScriptWraps.SCRIPLET || ph.scriptWrap == Placeholder.ScriptWraps.SCRIPLET_PRINT) {
                ph.setScriptTextNoWrap(m.group(3));
            }
            scripts.add(ph);
        }
        String replacedScriptsTemplate = m.replaceAll(replacement);
        List<String> pieces = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)replacedScriptsTemplate, (String)replacement));
        if (pieces.size() != scripts.size() + 1) {
            throw new IllegalStateException(String.format("Programming bug was detected. Text pieces size does not match scripts size (%s, %s). Please report this as a bug to the library author.", pieces.size(), scripts.size()));
        }
        ArrayList<Placeholder> tplSkeleton = new ArrayList<Placeholder>();
        int i = 0;
        for (String string3 : pieces) {
            tplSkeleton.add(new Placeholder(UUID.randomUUID().toString(), string3, Placeholder.PlaceholderType.TEXT));
            if (i < scripts.size()) {
                tplSkeleton.add((Placeholder)scripts.get(i));
            }
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        for (Placeholder placeholder : tplSkeleton) {
            if (Placeholder.PlaceholderType.SCRIPT == placeholder.type) {
                String cleanScriptNoWrap = XMLUtils.getNoTagsTrimText(placeholder.getScriptTextNoWrap());
                cleanScriptNoWrap = StringUtils.replaceEach((String)cleanScriptNoWrap, (String[])new String[]{"&amp;", "&gt;", "&lt;", "&quot;", "\u00ab", "\u00bb", "\u201c", "\u201d", "\u2018", "\u2019"}, (String[])new String[]{"&", ">", "<", "\"", "\"", "\"", "\"", "\"", "\"", "\""});
                if ((cleanScriptNoWrap = cleanScriptNoWrap.trim()).matches("\\w+") && !params.containsKey(cleanScriptNoWrap)) {
                    params.put(cleanScriptNoWrap, null);
                }
                if (placeholder.scriptWrap == Placeholder.ScriptWraps.DOLLAR_PRINT || placeholder.scriptWrap == Placeholder.ScriptWraps.SCRIPLET_PRINT) {
                    cleanScriptNoWrap = "__docxTemplaterInstance.replaceIfNull(" + cleanScriptNoWrap + ")";
                }
                String script = placeholder.constructWithCurrentScriptWrap(cleanScriptNoWrap);
                builder.append(script);
                continue;
            }
            builder.append(placeholder.ph);
        }
        template = builder.toString();
        params.put(UTIL_FUNC_HOLDER, this);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "processScriptedTemplate", String.format("\ntemplate = \n%s\n", template));
        }
        try {
            string2 = String.valueOf(this.templateEngine.createTemplate(template).make(params));
        }
        catch (Throwable e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "processScriptedTemplate", String.format("Cannot process template: [%s].", template), e);
            throw new RuntimeException(e);
        }
        String string4 = StringUtil.escapeSimpleSet(string2);
        String result = string = StringUtils.replace((String)string4, (String)NEW_LINE_PLACEHOLDER, (String)"<w:br/>");
        for (Placeholder placeholder : tplSkeleton) {
            if (Placeholder.PlaceholderType.TEXT != placeholder.type) continue;
            result = StringUtils.replace((String)result, (String)placeholder.ph, (String)placeholder.text);
        }
        return result;
    }

    protected String setupTemplate() throws IOException {
        String templateKey = null;
        if (this.pathToDocx != null) {
            templateKey = this.pathToDocx.hashCode() + "-" + FilenameUtils.getBaseName((String)this.pathToDocx.getName());
            if (!TemplateFileManager.getInstance().isPrepared(templateKey)) {
                TemplateFileManager.getInstance().prepare(this.pathToDocx, templateKey);
            }
        } else {
            try {
                templateKey = this.streamTemplateKey;
                if (!TemplateFileManager.getInstance().isTemplateFileFromStreamExists(templateKey)) {
                    TemplateFileManager.getInstance().saveTemplateFileFromStream(templateKey, this.templateStream);
                    TemplateFileManager.getInstance().prepare(TemplateFileManager.getInstance().getTemplateFileFromStream(templateKey), templateKey);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.templateStream);
            }
        }
        return templateKey;
    }

    public InputStream processAndReturnInputStream(Map<String, Object> params) {
        File tmpResFile = TemplateFileManager.getInstance().getUniqueOutStreamFile();
        this.process(tmpResFile, params);
        try {
            return new DeleteOnCloseFileInputStream(tmpResFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(OutputStream outputStream, Map<String, Object> params) {
        try {
            InputStream inputStream = null;
            try {
                inputStream = this.processAndReturnInputStream(params);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void process(File destDocx, Map<String, Object> params) {
        try {
            String templateKey = this.setupTemplate();
            TemplateContent tCont = TemplateFileManager.getInstance().getTemplateContent(templateKey);
            if (!TemplateFileManager.getInstance().isPreProcessedTemplateExists(templateKey)) {
                tCont = this.cleanupTemplate(tCont);
                TemplateFileManager.getInstance().savePreProcessed(templateKey, tCont);
            }
            tCont = this.processCleanedTemplate(tCont, params);
            this.processResult(destDocx, templateKey, tCont);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void processResult(File destDocx, String templateKey, TemplateContent content) throws IOException {
        File tmpProcessFolder = TemplateFileManager.getInstance().createTmpProcessFolder();
        destDocx.delete();
        FileUtils.deleteDirectory((File)tmpProcessFolder);
        FileUtils.copyDirectory((File)TemplateFileManager.getInstance().getTemplateUnzipFolder(templateKey), (File)tmpProcessFolder);
        for (TemplateContent.ContentItem item : content.getItems()) {
            FileUtils.writeStringToFile((File)new File(tmpProcessFolder, "word/" + item.getIdentifier()), (String)item.getContent(), (String)"UTF-8");
        }
        AntBuilder antBuilder = new AntBuilder();
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        params1.put("destfile", destDocx);
        params1.put("basedir", tmpProcessFolder);
        params1.put("includes", "**/*.*");
        params1.put("excludes", "");
        params1.put("encoding", "UTF-8");
        antBuilder.invokeMethod("zip", params1);
        FileUtils.deleteDirectory((File)tmpProcessFolder);
    }

    public static void cleanup() {
        try {
            TemplateFileManager.getInstance().cleanup();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String replaceIfNull(Object o) {
        return o == null ? this.nullReplacement : String.valueOf(o);
    }

    public void setNullReplacement(String nullReplacement) {
        this.nullReplacement = nullReplacement;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }
}

