/*
 * Decompiled with CFR 0.152.
 */
package org.scriptlet4docx.docx;

class Placeholder {
    String ph;
    String text;
    PlaceholderType type;
    ScriptWraps scriptWrap;
    String scriptTextNoWrap;

    public void setScriptTextNoWrap(String scriptTextNoWrap) {
        this.scriptTextNoWrap = scriptTextNoWrap;
    }

    public String getScriptTextNoWrap() {
        return this.scriptTextNoWrap;
    }

    public String constructWithCurrentScriptWrap(String scriptTextNoWrap) {
        String format = null;
        if (this.scriptWrap == ScriptWraps.DOLLAR_PRINT) {
            format = "${%s}";
        } else if (this.scriptWrap == ScriptWraps.SCRIPLET) {
            format = "<%%%s%%>";
        } else if (this.scriptWrap == ScriptWraps.SCRIPLET_PRINT) {
            format = "<%%=%s%%>";
        } else {
            throw new RuntimeException(String.format("ScriptWrap is undefined: %s", new Object[]{this.scriptWrap}));
        }
        return String.format(format, scriptTextNoWrap);
    }

    public Placeholder(String ph, String text, PlaceholderType type) {
        this.ph = ph;
        this.text = text;
        this.type = type;
        if (this.type == PlaceholderType.SCRIPT) {
            this.detectScriptWrap();
        }
    }

    private void detectScriptWrap() {
        String noSpaces = this.text.replaceAll("\\s", "");
        if (noSpaces.startsWith("$")) {
            this.scriptWrap = ScriptWraps.DOLLAR_PRINT;
        } else if (noSpaces.startsWith("&lt;%=")) {
            this.scriptWrap = ScriptWraps.SCRIPLET_PRINT;
        } else if (noSpaces.startsWith("&lt;%")) {
            this.scriptWrap = ScriptWraps.SCRIPLET;
        } else {
            throw new IllegalArgumentException(String.format("Script wrap cannot be detected: [%s]", this.text));
        }
    }

    public String toString() {
        return "Placeholder {" + (Object)((Object)this.type) + ", " + (Object)((Object)this.scriptWrap) + ", '" + this.text + "'}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PlaceholderType {
        SCRIPT,
        TEXT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ScriptWraps {
        DOLLAR_PRINT,
        SCRIPLET,
        SCRIPLET_PRINT;

    }
}

