/*
 * Decompiled with CFR 0.152.
 */
package org.scriptlet4docx.docx;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.scriptlet4docx.docx.TemplateVarException;
import org.scriptlet4docx.util.string.StringUtil;

class TableScriptingRowProcessor {
    private static Pattern groovyFormPattern = Pattern.compile("\\$\\[((.*?)(@\\w+).*?)\\]", 40);
    private boolean iterStatusDefined = false;

    TableScriptingRowProcessor() {
    }

    String process(String trRowStr) {
        Matcher m = groovyFormPattern.matcher(trRowStr);
        ArrayList<String> scripts = new ArrayList<String>();
        String placeholder = UUID.randomUUID().toString();
        HashSet<String> vars = new HashSet<String>();
        HashSet<String> prefixes = new HashSet<String>();
        String varPref = null;
        String varName = null;
        while (m.find()) {
            int initVarPrefLen = 0;
            String funcPref = "";
            String varToReplace = null;
            varPref = StringUtils.defaultString((String)m.group(2));
            initVarPrefLen = varPref.length();
            if (StringUtils.isNotBlank((CharSequence)varPref) && StringUtils.countMatches((CharSequence)varPref, (CharSequence)"(") > StringUtils.countMatches((CharSequence)varPref, (CharSequence)")")) {
                int idx = varPref.lastIndexOf("(");
                funcPref = varPref.substring(0, idx + 1);
                varPref = varPref.substring(idx + 1);
            }
            varToReplace = StringUtils.defaultString((String)m.group(3));
            if (varName == null) {
                varName = varToReplace.replace("@", "");
            }
            vars.add(varToReplace);
            prefixes.add(varPref);
            String sc = m.group(1);
            sc = sc.substring(initVarPrefLen);
            sc = StringUtils.replaceOnce((String)sc, (String)varToReplace, (String)(funcPref + varName));
            sc = String.format("${%s}", sc);
            scripts.add(sc);
        }
        if (vars.size() == 0) {
            throw new TemplateVarException("There must at least one use of @-variable in $[...] block.");
        }
        if (vars.size() > 1) {
            throw new TemplateVarException("Only one @-variable is allowed in $[...] block.");
        }
        if (prefixes.size() > 1) {
            throw new TemplateVarException("Only one @-variable prefix is allowed in $[...] block.");
        }
        String noScriptsTr = m.replaceAll(placeholder);
        String body = StringUtil.replaceOneByOne(noScriptsTr, placeholder, scripts);
        String wrapTop = null;
        String iterStatus = this.iterStatusDefined ? "iterStatus=0;" : "def iterStatus=0;";
        this.iterStatusDefined = true;
        wrapTop = StringUtils.isBlank((CharSequence)varPref) ? String.format("&lt;%% %s for ( %s in %sList ) { iterStatus++; %%&gt;", iterStatus, varName, varName) : String.format("&lt;%% %s for ( %s in %s%s ) { iterStatus++; %%&gt;", iterStatus, varName, varPref, varName);
        String res = wrapTop + body + "&lt;% }; %&gt;";
        return res;
    }
}

