/*
 * Decompiled with CFR 0.152.
 */
package org.scriptlet4docx.docx;

import groovy.util.AntBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.scriptlet4docx.docx.TemplateContent;

public class TemplateFileManager {
    private static volatile TemplateFileManager instance = new TemplateFileManager();
    private File templatesDir;
    static final String DOC_UNZIP_FOLDER_NAME = "/doc-unzip";
    static final String DOC_READY_STREAM_FOLDER_NAME = "/doc-ready-streamed";
    static final String DOC_FROM_STREAM = "/tmpl-from-stream.docx";

    private TemplateFileManager() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.templatesDir = new File(tmpDir + "/scriptlet4docx", FastDateFormat.getInstance((String)"yyyy-MM-dd-HH-mm-ss-SSS").format(new Date()));
        this.templatesDir.mkdirs();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                File f = TemplateFileManager.this.templatesDir.getParentFile();
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to delete tmp directory " + f.getAbsolutePath(), e);
                }
            }
        });
    }

    public static TemplateFileManager getInstance() {
        return instance;
    }

    File getTemplatesDir() {
        return this.templatesDir;
    }

    public TemplateContent getTemplateContent(String templateKey) throws IOException {
        File dir = new File(this.getTemplateUnzipFolder(templateKey), "word");
        ArrayList<TemplateContent.ContentItem> items = new ArrayList<TemplateContent.ContentItem>();
        for (File f : dir.listFiles()) {
            if (!f.isFile() || !f.getName().equals("document.xml") && !f.getName().startsWith("header") && !f.getName().startsWith("footer")) continue;
            items.add(new TemplateContent.ContentItem(f.getName(), null));
        }
        for (TemplateContent.ContentItem item : items) {
            File contentFile = this.getTmplPreprocessedFile(templateKey, item.getIdentifier());
            if (!contentFile.exists()) {
                contentFile = new File(dir, item.getIdentifier());
            }
            item.setContent(FileUtils.readFileToString((File)contentFile, (String)"UTF-8"));
        }
        return new TemplateContent(items);
    }

    public File getTemplateUnzipFolder(String templateKey) {
        return new File(this.templatesDir, templateKey + "/" + DOC_UNZIP_FOLDER_NAME);
    }

    public File createTmpProcessFolder() {
        return new File(this.templatesDir, UUID.randomUUID().toString());
    }

    private File getTmplPreprocessedFile(String templateKey, String identifier) {
        return new File(this.templatesDir, templateKey + "/preproc-" + identifier);
    }

    public boolean isPrepared(String templateKey) {
        File dir = this.getTemplateUnzipFolder(templateKey);
        return dir.exists();
    }

    public void prepare(File pathToDocx, String templateKey) throws IOException {
        File dir = this.getTemplateUnzipFolder(templateKey);
        if (!pathToDocx.exists() || !pathToDocx.isFile()) {
            throw new FileNotFoundException(String.format("Cannot find docx template: '%s'", pathToDocx.getAbsolutePath()));
        }
        AntBuilder antBuilder = new AntBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("src", pathToDocx);
        params.put("dest", dir);
        params.put("overwrite", "true");
        antBuilder.invokeMethod("unzip", params);
    }

    public boolean isPreProcessedTemplateExists(String templateKey) {
        File preprocessed = this.getTmplPreprocessedFile(templateKey, "document.xml");
        return preprocessed.exists();
    }

    public void savePreProcessed(String templateKey, TemplateContent content) throws IOException {
        for (TemplateContent.ContentItem item : content.getItems()) {
            File preprocessed = this.getTmplPreprocessedFile(templateKey, item.getIdentifier());
            FileUtils.writeStringToFile((File)preprocessed, (String)item.getContent(), (String)"UTF-8");
        }
    }

    public void cleanup() throws IOException {
        FileUtils.deleteDirectory((File)this.templatesDir);
        this.templatesDir.mkdirs();
    }

    public File getTemplateFileFromStream(String templateKey) {
        return new File(this.templatesDir, templateKey + "/" + DOC_FROM_STREAM);
    }

    public boolean isTemplateFileFromStreamExists(String templateKey) {
        return this.getTemplateFileFromStream(templateKey).exists();
    }

    public void saveTemplateFileFromStream(String templateKey, InputStream iStream) throws IOException {
        File f = this.getTemplateFileFromStream(templateKey);
        FileUtils.deleteQuietly((File)f);
        FileUtils.copyInputStreamToFile((InputStream)iStream, (File)f);
    }

    public File getUniqueOutStreamFile() {
        return new File(this.templatesDir, "/doc-ready-streamed/" + UUID.randomUUID().toString());
    }
}

