/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j_javascript;

import com.github.sommeri.less4j.EmbeddedLessGenerator;
import com.github.sommeri.less4j.EmbeddedScriptGenerator;
import com.github.sommeri.less4j.LessProblems;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import java.util.List;

public class JavascriptGenerator
implements EmbeddedScriptGenerator {
    private EmbeddedLessGenerator defaultScripting = new EmbeddedLessGenerator();

    public String toScript(Expression value, LessProblems problemsHandler) {
        if (value.getType() == ASTCssNodeType.LIST_EXPRESSION) {
            return this.toJsString((ListExpression)value, problemsHandler);
        }
        return this.toNonArrayScript(value, problemsHandler);
    }

    private String toNonArrayScript(Expression value, LessProblems problemsHandler) {
        if (value.getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.toJsString((CssString)value);
        }
        return this.defaultScripting.toScript(value, problemsHandler);
    }

    private String toJsString(ListExpression value, LessProblems problemsHandler) {
        List split = value.getExpressions();
        if (split.size() == 1) {
            Expression expression = (Expression)split.get(0);
            if (expression instanceof ListExpression) {
                return this.toScript(expression, problemsHandler);
            }
            return this.defaultScripting.toScript((Expression)value, problemsHandler);
        }
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (Expression expression : split) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            builder.append(this.toNonArrayScript(expression, problemsHandler));
        }
        builder.append("]");
        return builder.toString();
    }

    private String toJsString(CssString value) {
        return "\"" + value.getValue() + "\"";
    }
}

