/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.LinkedList;
import java.util.List;

public class ComposedExpression
extends Expression {
    private Expression left;
    private ExpressionOperator operator;
    private Expression right;

    public ComposedExpression(HiddenTokenAwareTree token, Expression left, ExpressionOperator operator, Expression right) {
        super(token);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.COMPOSED_EXPRESSION;
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ExpressionOperator operator) {
        this.operator = operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    @Override
    public List<Expression> splitByComma() {
        return this.doSplitByComma();
    }

    private LinkedList<Expression> doSplitByComma() {
        LinkedList<Expression> result = new LinkedList<Expression>();
        if (this.operator.getOperator() != ExpressionOperator.Operator.COMMA && this.operator.getOperator() != ExpressionOperator.Operator.EMPTY_OPERATOR) {
            result.add(this);
            return result;
        }
        LinkedList<Expression> left = this.splitByComma(this.getLeft());
        LinkedList<Expression> right = this.splitByComma(this.getRight());
        if (this.operator.getOperator() != ExpressionOperator.Operator.EMPTY_OPERATOR) {
            result.addAll(left);
            result.addAll(right);
            return result;
        }
        Expression lastLeft = left.pollLast();
        Expression firstRight = right.pollFirst();
        result.addAll(left);
        result.add(new ComposedExpression(lastLeft.getUnderlyingStructure(), lastLeft, this.operator, firstRight));
        result.addAll(right);
        return result;
    }

    private LinkedList<Expression> splitByComma(Expression expression) {
        if (expression.getType() == ASTCssNodeType.COMPOSED_EXPRESSION) {
            ComposedExpression composed = (ComposedExpression)expression;
            return composed.doSplitByComma();
        }
        LinkedList<Expression> result = new LinkedList<Expression>();
        result.add(expression);
        return result;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.left, this.operator, this.right);
    }

    public String toString() {
        return "[" + this.left + this.operator + this.right + "]";
    }

    @Override
    public ComposedExpression clone() {
        ComposedExpression result = (ComposedExpression)super.clone();
        result.left = this.left == null ? null : this.left.clone();
        result.operator = this.operator == null ? null : this.operator.clone();
        result.right = this.right == null ? null : this.right.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

