/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SupportsLogicalOperator
extends ASTCssNode
implements Cloneable {
    private Operator operator;

    public SupportsLogicalOperator(HiddenTokenAwareTree underlyingStructure, Operator operator) {
        super(underlyingStructure);
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public boolean isFaulty() {
        return this.operator == null;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SUPPORTS_LOGICAL_OPERATOR;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    @Override
    public SupportsLogicalOperator clone() {
        return (SupportsLogicalOperator)super.clone();
    }

    public String toString() {
        return "" + this.operator.getSymbol();
    }

    public static enum Operator {
        AND("and"),
        OR("or");

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static Map<String, Operator> getSymbolsMap() {
            HashMap<String, Operator> result = new HashMap<String, Operator>();
            for (Operator operator : Operator.values()) {
                result.put(operator.getSymbol(), operator);
            }
            return result;
        }
    }
}

