/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.core.validators.SupportedLessBodyMembers;
import java.util.List;
import java.util.Set;

public class AstLogic {
    public static boolean hasOwnScope(ASTCssNode node) {
        return AstLogic.isBody(node) || AstLogic.isBodyOwner(node);
    }

    public static boolean isBodyOwner(ASTCssNode node) {
        return node instanceof BodyOwner;
    }

    protected static boolean isBody(ASTCssNode node) {
        return node instanceof Body;
    }

    public static boolean canHaveArguments(ASTCssNode owner) {
        if (owner.getType() != ASTCssNodeType.REUSABLE_STRUCTURE) {
            return false;
        }
        return ((ReusableStructure)owner).hasParameters();
    }

    public static void validateLessBodyCompatibility(ASTCssNode reference, List<ASTCssNode> members, ProblemsHandler problemsHandler) {
        ASTCssNode parent = reference.getParent();
        if (!AstLogic.isBody(parent)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        SupportedLessBodyMembers allowedBodyMembers = new SupportedLessBodyMembers();
        Set<ASTCssNodeType> supportedMembers = allowedBodyMembers.getSupportedMembers((Body)parent);
        for (ASTCssNode member : members) {
            if (supportedMembers.contains((Object)member.getType())) continue;
            problemsHandler.wrongMemberBroughtIntoBody(reference, member, parent);
        }
    }
}

