/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import com.github.sommeri.less4j.core.compiler.stages.AstNodesStack;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import java.util.ArrayList;
import java.util.List;

public class MixinReferenceFinder {
    private final ReferencesSolver parentSolver;
    private final AstNodesStack semiCompiledNodes;
    private boolean foundNamespace = false;

    public MixinReferenceFinder(ReferencesSolver referencesSolver, AstNodesStack semiCompiledNodes) {
        this.parentSolver = referencesSolver;
        this.semiCompiledNodes = semiCompiledNodes;
    }

    public List<FullMixinDefinition> getNearestMixins(Scope scope, MixinReference reference) {
        this.foundNamespace = false;
        List<String> nameChain = reference.getNameChainAsStrings();
        Scope space = scope;
        List<FullMixinDefinition> result = this.findInMatchingNamespace(scope, nameChain, reference);
        while (result.isEmpty() && space.hasParent()) {
            space = space.getParent();
            result = this.findInMatchingNamespace(space, nameChain, reference);
        }
        return result;
    }

    public boolean foundNamespace() {
        return this.foundNamespace;
    }

    private List<FullMixinDefinition> getNearestLocalMixins(Scope scope, ReusableStructureName name) {
        ArrayList value = scope.getMixinsByName(name);
        if ((value == null || value.isEmpty()) && scope.hasParent()) {
            return this.getNearestLocalMixins(scope.getParent(), name);
        }
        return value == null ? new ArrayList() : value;
    }

    private List<FullMixinDefinition> findInMatchingNamespace(Scope scope, List<String> nameChain, MixinReference reference) {
        if (nameChain.isEmpty()) {
            this.foundNamespace = true;
            if (scope.isBodyOwnerScope()) {
                scope = scope.firstChild();
            }
            return this.getNearestLocalMixins(scope, reference.getFinalName());
        }
        String firstName = nameChain.get(0);
        List<String> theRest = nameChain.subList(1, nameChain.size());
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition fullMixin : scope.getAllMixins()) {
            if (!fullMixin.getMixin().hasName(firstName)) continue;
            List<FullMixinDefinition> foundInNamespaces = this.buildAndFind(fullMixin, theRest, reference);
            result.addAll(foundInNamespaces);
        }
        return result;
    }

    private List<FullMixinDefinition> buildAndFind(FullMixinDefinition fullMixin, final List<String> nameChain, final MixinReference reference) {
        final ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        ReusableStructure mixin = fullMixin.getMixin();
        final GeneralBody bodyClone = mixin.getBody().clone();
        final Scope scope = fullMixin.getScope();
        InScopeSnapshotRunner.runInLocalDataSnapshot(scope, new InScopeSnapshotRunner.ITask(){

            @Override
            public void run() {
                if (!MixinReferenceFinder.this.semiCompiledNodes.contains(bodyClone)) {
                    MixinReferenceFinder.this.parentSolver.unsafeDoSolveReferences((ASTCssNode)bodyClone, scope);
                }
                List found = MixinReferenceFinder.this.findInMatchingNamespace(scope, nameChain, reference);
                result.addAll(found);
            }
        });
        return result;
    }
}

