/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.FaultyNode;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SimpleImportsSolver {
    private final ProblemsHandler problemsHandler;
    private TypesConversionUtils conversionUtils = new TypesConversionUtils();
    private ASTManipulator astManipulator = new ASTManipulator();
    private Set<LessSource> importedSources = new HashSet<LessSource>();

    public SimpleImportsSolver(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void solveImports(StyleSheet node, LessSource source) {
        this.doSolveImports(node, source);
    }

    private void doSolveImports(StyleSheet node, LessSource source) {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode kid : childs) {
            if (kid.getType() != ASTCssNodeType.IMPORT) continue;
            this.importEncountered((Import)kid, source);
        }
    }

    private void importEncountered(Import node, LessSource source) {
        String importedContent;
        LessSource importedSource;
        String filename = this.conversionUtils.extractFilename(node.getUrlExpression(), this.problemsHandler);
        if (filename == null) {
            this.problemsHandler.errorWrongImport(node.getUrlExpression());
            return;
        }
        String urlParams = "";
        int paramsIndx = filename.lastIndexOf("?");
        if (paramsIndx != -1) {
            urlParams = filename.substring(paramsIndx);
            filename = filename.substring(0, paramsIndx);
        }
        if (this.isCssFile(filename)) {
            return;
        }
        filename = this.addLessSuffixIfNeeded(filename, urlParams);
        try {
            importedSource = source.relativeSource(filename);
        }
        catch (LessSource.FileNotFound ex) {
            this.problemsHandler.errorImportedFileNotFound(node, filename);
            return;
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorImportedFileCanNotBeRead(node, filename);
            return;
        }
        catch (LessSource.StringSourceException ex) {
            this.problemsHandler.warnLessImportNoBaseDirectory(node.getUrlExpression());
            return;
        }
        if (this.isImportOnce(node) && this.alreadyVisited(importedSource)) {
            this.astManipulator.removeFromBody(node);
            return;
        }
        this.importedSources.add(importedSource);
        try {
            importedContent = importedSource.getContent();
        }
        catch (LessSource.FileNotFound e) {
            this.problemsHandler.errorImportedFileNotFound(node, filename);
            return;
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorImportedFileCanNotBeRead(node, filename);
            return;
        }
        StyleSheet importedAst = this.parseContent(node, importedContent, importedSource);
        this.solveImports(importedAst, importedSource);
        if (node.hasMediums()) {
            HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
            Media media = new Media(underlyingStructure);
            media.setMediums(node.getMediums());
            media.setBody(new GeneralBody(underlyingStructure, importedAst.getMembers()));
            media.configureParentToAllChilds();
            this.astManipulator.replaceInBody((ASTCssNode)node, media);
        } else {
            this.astManipulator.replaceInBody((ASTCssNode)node, importedAst.getChilds());
        }
    }

    private boolean isImportOnce(Import node) {
        return node.getKind() == Import.ImportKind.IMPORT_ONCE;
    }

    private boolean alreadyVisited(LessSource importedSource) {
        return this.importedSources.contains(importedSource);
    }

    private StyleSheet parseContent(Import importNode, String importedContent, LessSource source) {
        ANTLRParser parser = new ANTLRParser();
        ANTLRParser.ParseResult parsedSheet = parser.parseStyleSheet(importedContent, source);
        if (parsedSheet.hasErrors()) {
            StyleSheet result = new StyleSheet(importNode.getUnderlyingStructure());
            result.addMember(new FaultyNode(importNode));
            this.problemsHandler.addErrors(parsedSheet.getErrors());
            return result;
        }
        ASTBuilder astBuilder = new ASTBuilder(this.problemsHandler);
        StyleSheet lessStyleSheet = astBuilder.parse(parsedSheet.getTree());
        return lessStyleSheet;
    }

    private String addLessSuffixIfNeeded(String filename, String urlParams) {
        if (new File(filename).getName().contains(".")) {
            return filename;
        }
        return filename + ".less" + urlParams;
    }

    private boolean isCssFile(String filename) {
        String lowerCase = filename.toLowerCase();
        return lowerCase.endsWith(".css") || lowerCase.endsWith("/css");
    }
}

