/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.SyntaxOnlyElement;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class Body
extends ASTCssNode {
    private SyntaxOnlyElement openingCurlyBrace;
    private SyntaxOnlyElement closingCurlyBrace;
    private List<ASTCssNode> body = new ArrayList<ASTCssNode>();

    public Body(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public Body(HiddenTokenAwareTree underlyingStructure, SyntaxOnlyElement lbrace, SyntaxOnlyElement rbrace, List<ASTCssNode> members) {
        this(underlyingStructure);
        this.openingCurlyBrace = lbrace;
        this.closingCurlyBrace = rbrace;
        this.body.addAll(members);
    }

    public SyntaxOnlyElement getOpeningCurlyBrace() {
        return this.openingCurlyBrace;
    }

    public void setOpeningCurlyBrace(SyntaxOnlyElement openingCurlyBrace) {
        this.openingCurlyBrace = openingCurlyBrace;
    }

    public SyntaxOnlyElement getClosingCurlyBrace() {
        return this.closingCurlyBrace;
    }

    public void setClosingCurlyBrace(SyntaxOnlyElement closingCurlyBrace) {
        this.closingCurlyBrace = closingCurlyBrace;
    }

    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.openingCurlyBrace);
        result.addAll(this.body);
        if (this.closingCurlyBrace != null) {
            result.add(this.closingCurlyBrace);
        }
        return result;
    }

    public List<ASTCssNode> getMembers() {
        return this.body;
    }

    public boolean isEmpty() {
        return this.body.isEmpty() && this.getOrphanComments().isEmpty();
    }

    public void removeAllMembers() {
        this.body = new ArrayList<ASTCssNode>();
    }

    public void addMembers(List<? extends ASTCssNode> members) {
        this.body.addAll(members);
    }

    public void addMembersAfter(List<? extends ASTCssNode> newMembers, ASTCssNode kid) {
        int index = this.body.indexOf(kid);
        index = index == -1 ? this.body.size() : ++index;
        this.body.addAll(index, newMembers);
    }

    public void addMemberAfter(ASTCssNode newMember, ASTCssNode kid) {
        int index = this.body.indexOf(kid);
        index = index == -1 ? this.body.size() : ++index;
        this.body.add(index, newMember);
    }

    public void addMember(ASTCssNode member) {
        this.body.add(member);
    }

    public void replaceMember(ASTCssNode oldMember, List<ASTCssNode> newMembers) {
        this.body.addAll(this.body.indexOf(oldMember), newMembers);
        this.body.remove(oldMember);
        oldMember.setParent(null);
        this.configureParentToAllChilds();
    }

    public void replaceMember(ASTCssNode oldMember, ASTCssNode newMember) {
        this.body.add(this.body.indexOf(oldMember), newMember);
        this.body.remove(oldMember);
        oldMember.setParent(null);
        newMember.setParent(this);
    }

    public List<ASTCssNode> membersByType(ASTCssNodeType type) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        List<ASTCssNode> body = this.getMembers();
        for (ASTCssNode node : body) {
            if (node.getType() != type) continue;
            result.add(node);
        }
        return result;
    }

    public List<ASTCssNode> membersByNotType(ASTCssNodeType type) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        List<ASTCssNode> body = this.getMembers();
        for (ASTCssNode node : body) {
            if (node.getType() == type) continue;
            result.add(node);
        }
        return result;
    }

    public boolean removeMember(ASTCssNode node) {
        return this.body.remove(node);
    }

    @Override
    public Body clone() {
        Body result = (Body)super.clone();
        result.body = ArraysUtils.deeplyClonedList(this.body);
        result.openingCurlyBrace = this.openingCurlyBrace == null ? null : this.openingCurlyBrace.clone();
        result.closingCurlyBrace = this.closingCurlyBrace == null ? null : this.closingCurlyBrace.clone();
        result.configureParentToAllChilds();
        return result;
    }

    public Body emptyClone() {
        Body result = (Body)super.clone();
        result.body = new ArrayList<ASTCssNode>();
        return result;
    }

    public List<ASTCssNode> getDeclarations() {
        return this.membersByType(ASTCssNodeType.DECLARATION);
    }

    public List<ASTCssNode> getNotDeclarations() {
        return this.membersByNotType(ASTCssNodeType.DECLARATION);
    }

    @Override
    public void setParent(ASTCssNode parent) {
        if (parent != null && !(parent instanceof BodyOwner)) {
            throw new IllegalArgumentException("Body parent must be a BodyOwner: " + (Object)((Object)parent.getType()));
        }
        super.setParent(parent);
    }
}

