/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.FaultyNode;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.InlineContent;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SingleImportSolver {
    private final ProblemsHandler problemsHandler;
    private final LessCompiler.Configuration configuration;
    private TypesConversionUtils conversionUtils = new TypesConversionUtils();
    private ASTManipulator astManipulator = new ASTManipulator();
    private Map<LessSource, StyleSheet> astCache = new HashMap<LessSource, StyleSheet>();

    public SingleImportSolver(ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
    }

    public ASTCssNode importEncountered(Import node, LessSource source, AlreadyImportedSources alreadyImportedSources) {
        String importedContent;
        LessSource importedSource;
        String filename = this.conversionUtils.extractFilename(node.getUrlExpression(), this.problemsHandler, this.configuration);
        if (filename == null) {
            this.problemsHandler.errorWrongImport(node.getUrlExpression());
            return null;
        }
        String urlParams = "";
        int paramsIndx = filename.lastIndexOf("?");
        if (paramsIndx != -1) {
            urlParams = filename.substring(paramsIndx);
            filename = filename.substring(0, paramsIndx);
        }
        if (!node.isInline() && this.treatAsCss(node, filename)) {
            return null;
        }
        filename = this.addLessSuffixIfNeeded(filename, urlParams);
        try {
            importedSource = source.relativeSource(filename);
        }
        catch (LessSource.FileNotFound ex) {
            return this.importFileNotFound(node, filename);
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorFileCanNotBeRead(node, filename);
            return null;
        }
        catch (LessSource.StringSourceException ex) {
            this.problemsHandler.warnLessImportNoBaseDirectory(node.getUrlExpression());
            return null;
        }
        if (node.isImportOnce() && alreadyImportedSources.alreadyVisited(importedSource)) {
            this.astManipulator.removeFromBody(node);
            return null;
        }
        try {
            importedContent = importedSource.getContent();
            alreadyImportedSources.add(importedSource);
        }
        catch (LessSource.FileNotFound e) {
            return this.importFileNotFound(node, filename);
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorFileCanNotBeRead(node, filename);
            return null;
        }
        if (node.isInline()) {
            return this.replaceByInlineValue(node, importedContent);
        }
        StyleSheet importedAst = this.buildImportedAst(node, importedSource, importedContent);
        if (node.isReferenceOnly() || node.isSilent()) {
            this.astManipulator.setTreeSilentness(importedAst, true);
        }
        this.astManipulator.replaceInBody((ASTCssNode)node, importedAst.getChilds());
        return importedAst;
    }

    private ASTCssNode replaceByInlineValue(Import node, String importedContent) {
        HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
        StyleSheet result = new StyleSheet(underlyingStructure);
        InlineContent content = new InlineContent(underlyingStructure, importedContent);
        result.addMember(content);
        result.configureParentToAllChilds();
        this.astManipulator.replaceInBody((ASTCssNode)node, content);
        return result;
    }

    private ASTCssNode importFileNotFound(Import node, String filename) {
        if (!node.isOptional()) {
            this.problemsHandler.errorFileNotFound(node, filename);
            return null;
        }
        return this.replaceByInlineValue(node, "");
    }

    private StyleSheet buildImportedAst(Import node, LessSource source, String content) {
        StyleSheet importedAst = this.getImportedAst(node, source, content);
        if (node.hasMediums()) {
            HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
            StyleSheet result = new StyleSheet(underlyingStructure);
            Media media = new Media(underlyingStructure);
            result.addMember(media);
            media.setParent(result);
            media.setMediums(node.getMediums());
            GeneralBody mediaBody = new GeneralBody(underlyingStructure, importedAst.getMembers());
            media.setBody(mediaBody);
            media.configureParentToAllChilds();
            mediaBody.configureParentToAllChilds();
            return result;
        }
        return importedAst;
    }

    private StyleSheet getImportedAst(Import node, LessSource source, String content) {
        if (this.astCache.containsKey(source)) {
            return this.astCache.get(source).clone();
        }
        StyleSheet importedAst = this.parseContent(node, content, source);
        this.astCache.put(source, importedAst.clone());
        return importedAst;
    }

    private StyleSheet parseContent(Import importNode, String importedContent, LessSource source) {
        ANTLRParser parser = new ANTLRParser();
        ANTLRParser.ParseResult parsedSheet = parser.parseStyleSheet(importedContent, source);
        if (parsedSheet.hasErrors()) {
            StyleSheet result = new StyleSheet(importNode.getUnderlyingStructure());
            result.addMember(new FaultyNode(importNode));
            this.problemsHandler.addErrors(parsedSheet.getErrors());
            return result;
        }
        ASTBuilder astBuilder = new ASTBuilder(this.problemsHandler);
        StyleSheet lessStyleSheet = astBuilder.parseStyleSheet(parsedSheet.getTree());
        return lessStyleSheet;
    }

    private String addLessSuffixIfNeeded(String filename, String urlParams) {
        if (new File(filename).getName().contains(".")) {
            return filename;
        }
        return filename + ".less" + urlParams;
    }

    private boolean treatAsCss(Import node, String filename) {
        Import.ImportContent contentKind = node.getContentKind();
        return contentKind == Import.ImportContent.CSS || contentKind == Import.ImportContent.SUFFIX_BASED && this.isCssFile(filename);
    }

    private boolean isCssFile(String filename) {
        String lowerCase = filename.toLowerCase();
        return lowerCase.endsWith(".css") || lowerCase.endsWith("/css");
    }

    public static class AlreadyImportedSources {
        private Set<LessSource> sourcesThatCount = new HashSet<LessSource>();
        private Set<LessSource> allImportedSources;

        public AlreadyImportedSources(Set<LessSource> allImportedSources) {
            this.allImportedSources = allImportedSources;
        }

        public void add(LessSource importedSource) {
            this.sourcesThatCount.add(importedSource);
            this.allImportedSources.add(importedSource);
        }

        public boolean alreadyVisited(LessSource importedSource) {
            boolean result = this.sourcesThatCount.contains(importedSource);
            return result;
        }
    }
}

