/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.BinaryExpression;
import com.github.sommeri.less4j.core.ast.BinaryExpressionOperator;
import com.github.sommeri.less4j.core.ast.CharsetDeclaration;
import com.github.sommeri.less4j.core.ast.ComparisonExpression;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.DetachedRuleset;
import com.github.sommeri.less4j.core.ast.DetachedRulesetReference;
import com.github.sommeri.less4j.core.ast.Document;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.EmptyExpression;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.FixedMediaExpression;
import com.github.sommeri.less4j.core.ast.FixedNamePart;
import com.github.sommeri.less4j.core.ast.FontFace;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.GuardCondition;
import com.github.sommeri.less4j.core.ast.IdSelector;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.InterpolableNamePart;
import com.github.sommeri.less4j.core.ast.InterpolatedMediaExpression;
import com.github.sommeri.less4j.core.ast.Keyframes;
import com.github.sommeri.less4j.core.ast.KeyframesName;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.Medium;
import com.github.sommeri.less4j.core.ast.MediumModifier;
import com.github.sommeri.less4j.core.ast.MediumType;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.MultiTargetExtend;
import com.github.sommeri.less4j.core.ast.Name;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.Nth;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.Page;
import com.github.sommeri.less4j.core.ast.PageMarginBox;
import com.github.sommeri.less4j.core.ast.Pseudo;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.PseudoElement;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorAttribute;
import com.github.sommeri.less4j.core.ast.SelectorOperator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.Supports;
import com.github.sommeri.less4j.core.ast.SupportsCondition;
import com.github.sommeri.less4j.core.ast.SupportsConditionInParentheses;
import com.github.sommeri.less4j.core.ast.SupportsConditionNegation;
import com.github.sommeri.less4j.core.ast.SupportsLogicalCondition;
import com.github.sommeri.less4j.core.ast.SupportsLogicalOperator;
import com.github.sommeri.less4j.core.ast.SupportsQuery;
import com.github.sommeri.less4j.core.ast.SyntaxOnlyElement;
import com.github.sommeri.less4j.core.ast.UnknownAtRule;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.ast.VariableNamePart;
import com.github.sommeri.less4j.core.ast.Viewport;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.parser.MixinsParametersBuilder;
import com.github.sommeri.less4j.core.parser.SelectorBuilder;
import com.github.sommeri.less4j.core.parser.TermBuilder;
import com.github.sommeri.less4j.core.parser.TokenTypeSwitch;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.CommonToken;

class ASTBuilderSwitch
extends TokenTypeSwitch<ASTCssNode> {
    protected static final String GRAMMAR_MISMATCH = "ASTBuilderSwitch grammar mismatch";
    private final ProblemsHandler problemsHandler;
    private final MixinsParametersBuilder mixinsParametersBuilder;
    private final TermBuilder termBuilder;
    private static Set<String> COLONLESS_PSEUDOELEMENTS = new HashSet<String>();
    private static final String EXTEND_ALL_KEYWORD = "all";
    private static final String IMPORT_OPTION_REFERENCE = "reference";
    private static final String IMPORT_OPTION_INLINE = "inline";
    private static final String IMPORT_OPTION_LESS = "less";
    private static final String IMPORT_OPTION_CSS = "css";
    private static final String IMPORT_OPTION_ONCE = "once";
    private static final String IMPORT_OPTION_MULTIPLE = "multiple";
    private static final String IMPORT_OPTION_OPTIONAL = "optional";

    public ASTBuilderSwitch(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
        this.termBuilder = new TermBuilder(this, problemsHandler);
        this.mixinsParametersBuilder = new MixinsParametersBuilder(this, problemsHandler);
    }

    @Override
    public StyleSheet handleStyleSheet(HiddenTokenAwareTree token) {
        StyleSheet result = new StyleSheet(token);
        if (token.getChildren() == null || token.getChildren().isEmpty()) {
            return result;
        }
        for (HiddenTokenAwareTree kid : token.getChildren()) {
            result.addMember((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public Expression handleTerm(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromChildTerm(token);
    }

    @Override
    public Expression handleExpression(HiddenTokenAwareTree token) {
        LinkedList<HiddenTokenAwareTree> children = new LinkedList<HiddenTokenAwareTree>(token.getChildren());
        if (children.size() == 0) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        if (children.size() == 1) {
            Expression head = (Expression)this.switchOn(children.get(0));
            head.setUnderlyingStructure(token);
            return head;
        }
        if (null != this.toListExpressionOperator(children.get(1))) {
            return this.createListExpression(token, children);
        }
        return this.createBinaryExpression(token, children);
    }

    private Expression createListExpression(HiddenTokenAwareTree parent, LinkedList<HiddenTokenAwareTree> members) {
        Iterator iterator = members.iterator();
        Expression head = (Expression)this.switchOn((HiddenTokenAwareTree)iterator.next());
        ArrayList<Expression> spaceSeparatedExpressions = new ArrayList<Expression>();
        spaceSeparatedExpressions.add(head);
        ListExpressionOperator space = null;
        ArrayList<Expression> commaSeparatedExpressions = new ArrayList<Expression>();
        ListExpressionOperator comma = null;
        while (iterator.hasNext()) {
            HiddenTokenAwareTree operatorToken = (HiddenTokenAwareTree)iterator.next();
            operatorToken.pushHiddenToSiblings();
            ListExpressionOperator operator = this.createListOperator(operatorToken);
            if (operator.getOperator() == ListExpressionOperator.Operator.EMPTY_OPERATOR) {
                space = operator;
            } else {
                comma = operator;
                if (!spaceSeparatedExpressions.isEmpty()) {
                    commaSeparatedExpressions.add(this.maybeList(spaceSeparatedExpressions, space));
                }
                spaceSeparatedExpressions = new ArrayList();
            }
            if (!iterator.hasNext()) continue;
            spaceSeparatedExpressions.add((Expression)this.switchOn((HiddenTokenAwareTree)iterator.next()));
        }
        if (!spaceSeparatedExpressions.isEmpty()) {
            commaSeparatedExpressions.add(this.maybeList(spaceSeparatedExpressions, space));
        }
        return this.maybeList(commaSeparatedExpressions, comma);
    }

    private Expression maybeList(List<Expression> expressions, ListExpressionOperator operator) {
        if (expressions.isEmpty()) {
            return null;
        }
        Expression first = expressions.get(0);
        if (expressions.size() == 1) {
            return first;
        }
        return new ListExpression(first.getUnderlyingStructure(), expressions, operator);
    }

    private Expression createBinaryExpression(HiddenTokenAwareTree parent, LinkedList<HiddenTokenAwareTree> members) {
        Expression head = (Expression)this.switchOn(members.removeFirst());
        while (!members.isEmpty()) {
            BinaryExpressionOperator operator = this.createBinaryOperator(members.removeFirst());
            if (members.isEmpty()) {
                return new BinaryExpression(parent, head, operator, null);
            }
            Expression next = (Expression)this.switchOn(members.removeFirst());
            head = new BinaryExpression(parent, head, operator, next);
        }
        return head;
    }

    public BinaryExpressionOperator createBinaryOperator(HiddenTokenAwareTree token) {
        BinaryExpressionOperator operator = new BinaryExpressionOperator(token, this.toExpressionOperator(token));
        return operator;
    }

    private BinaryExpressionOperator.Operator toExpressionOperator(HiddenTokenAwareTree token) {
        switch (token.getGeneralType()) {
            case 100: {
                return BinaryExpressionOperator.Operator.SOLIDUS;
            }
            case 101: {
                return BinaryExpressionOperator.Operator.STAR;
            }
            case 104: {
                return BinaryExpressionOperator.Operator.MINUS;
            }
            case 96: {
                return BinaryExpressionOperator.Operator.PLUS;
            }
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    public ListExpressionOperator createListOperator(HiddenTokenAwareTree token) {
        ListExpressionOperator.Operator operator = this.toListExpressionOperator(token);
        if (operator == null) {
            return null;
        }
        ListExpressionOperator result = new ListExpressionOperator(token, operator);
        return result;
    }

    private ListExpressionOperator.Operator toListExpressionOperator(HiddenTokenAwareTree token) {
        switch (token.getGeneralType()) {
            case 81: {
                return ListExpressionOperator.Operator.COMMA;
            }
            case 18: {
                return ListExpressionOperator.Operator.EMPTY_OPERATOR;
            }
        }
        return null;
    }

    @Override
    public Variable handleVariable(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromVariable(token);
    }

    @Override
    public Variable handleVariableReference(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromVariableReference(token);
    }

    @Override
    public IndirectVariable handleIndirectVariable(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromIndirectVariable(token);
    }

    @Override
    public Declaration handleDeclaration(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        HiddenTokenAwareTree nameToken = iterator.next();
        InterpolableName name = this.toInterpolableName(nameToken, nameToken.getChildren());
        HiddenTokenAwareTree colonToken = iterator.next();
        ListExpressionOperator.Operator mergeOperator = null;
        if (colonToken.getGeneralType() == 96) {
            colonToken = iterator.next();
            mergeOperator = ListExpressionOperator.Operator.COMMA;
            if (colonToken.getGeneralType() == 102) {
                colonToken = iterator.next();
                mergeOperator = ListExpressionOperator.Operator.EMPTY_OPERATOR;
            }
        }
        colonToken.pushHiddenToSiblings();
        if (!iterator.hasNext()) {
            return new Declaration(token, name);
        }
        HiddenTokenAwareTree expressionToken = iterator.next();
        Expression expression = (Expression)this.switchOn(expressionToken);
        if (!iterator.hasNext()) {
            return new Declaration(token, name, expression, mergeOperator);
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    @Override
    public FontFace handleFontFace(HiddenTokenAwareTree token) {
        FontFace result = new FontFace(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        result.setBody(this.handleGeneralBody(children.get(0)));
        return result;
    }

    @Override
    public CharsetDeclaration handleCharsetDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.isEmpty()) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        HiddenTokenAwareTree charset = children.get(1);
        return new CharsetDeclaration(token, this.termBuilder.createCssString(charset, charset.getText()));
    }

    @Override
    public RuleSet handleRuleSet(HiddenTokenAwareTree token) {
        RuleSet ruleSet = new RuleSet(token);
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        ArrayList<Guard> guards = new ArrayList<Guard>();
        List<HiddenTokenAwareTree> children = token.getChildren();
        ASTCssNode previousKid = null;
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 12) {
                Selector selector = this.handleSelector(kid);
                if (selector != null) {
                    selectors.add(selector);
                }
                previousKid = selector;
                continue;
            }
            if (kid.getGeneralType() == 38) {
                GeneralBody body = this.handleGeneralBody(kid);
                ruleSet.setBody(body);
                previousKid = body;
                continue;
            }
            if (kid.getGeneralType() == 46) {
                guards.add(this.handleGuard(kid));
                continue;
            }
            if (kid.getGeneralType() != 81) continue;
            if (previousKid != null) {
                previousKid.getUnderlyingStructure().addFollowing(kid.getPreceding());
            }
            kid.pushFollowingHiddenToSibling();
        }
        ruleSet.addSelectors(selectors);
        ruleSet.addGuards(guards);
        return ruleSet;
    }

    @Override
    public ReusableStructure handleReusableStructureDeclaration(HiddenTokenAwareTree token) {
        ReusableStructure result = new ReusableStructure(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 57) {
                result.addName(this.handleReusableStructureName(kid));
                continue;
            }
            if (kid.getGeneralType() == 38) {
                result.setBody(this.handleGeneralBody(kid));
                continue;
            }
            if (kid.getGeneralType() == 46) {
                result.addGuard(this.handleGuard(kid));
                continue;
            }
            if (kid.getGeneralType() != 62) continue;
            this.mixinsParametersBuilder.handleMixinDeclarationArguments(kid, result);
        }
        return result;
    }

    @Override
    public ElementSubsequent handleElementSubsequent(HiddenTokenAwareTree token) {
        return (ElementSubsequent)this.switchOn(token.getChild(0));
    }

    @Override
    public ReusableStructureName handleReusableStructureName(HiddenTokenAwareTree token) {
        ReusableStructureName result = new ReusableStructureName(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            result.addNamePart(this.handleElementSubsequent(kid));
        }
        return result;
    }

    @Override
    public MixinReference handleMixinReference(HiddenTokenAwareTree token) {
        MixinReference result = new MixinReference(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 57) {
                result.setFinalName(this.handleReusableStructureName(kid));
                continue;
            }
            if (kid.getGeneralType() == 131) {
                result.setImportant(true);
                continue;
            }
            if (kid.getGeneralType() != 61) continue;
            this.mixinsParametersBuilder.handleMixinReferenceArguments(kid, result);
        }
        return result;
    }

    @Override
    public MixinReference handleNamespaceReference(HiddenTokenAwareTree token) {
        ASTCssNode reference = null;
        ArrayList<ReusableStructureName> nameChain = new ArrayList<ReusableStructureName>();
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            ASTCssNode buildKid = (ASTCssNode)this.switchOn(kid);
            if (buildKid.getType() == ASTCssNodeType.MIXIN_REFERENCE) {
                reference = (MixinReference)this.switchOn(kid);
                continue;
            }
            if (buildKid.getType() == ASTCssNodeType.REUSABLE_STRUCTURE_NAME) {
                nameChain.add(this.handleReusableStructureName(kid));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        reference.setUnderlyingStructure(token);
        ((MixinReference)reference).addNames(nameChain);
        return reference;
    }

    @Override
    public Expression handleMixinPattern(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromTerm(token.getChild(0));
    }

    @Override
    public DetachedRulesetReference handleDetachedRulesetReference(HiddenTokenAwareTree token) {
        DetachedRulesetReference result = new DetachedRulesetReference(token, this.termBuilder.buildFromVariableReference(token.getChild(0)));
        if (token.getChildCount() < 3) {
            this.problemsHandler.detachedRulesetCallWithoutParentheses(result);
        }
        return result;
    }

    @Override
    public DetachedRuleset handleDetachedRuleset(HiddenTokenAwareTree token) {
        return new DetachedRuleset(token, this.handleGeneralBody(token.getChild(0)));
    }

    @Override
    public Guard handleGuard(HiddenTokenAwareTree token) {
        Guard result = new Guard(token);
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        result.addCondition(this.handleGuardCondition(iterator.next()));
        while (iterator.hasNext()) {
            this.validateGuardAnd(iterator.next());
            result.addCondition(this.handleGuardCondition(iterator.next()));
        }
        return result;
    }

    @Override
    public GuardCondition handleGuardCondition(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        HiddenTokenAwareTree kid = iterator.next();
        boolean isNegated = false;
        if (kid.getGeneralType() != 7) {
            this.validateGuardNegation(kid);
            isNegated = true;
            kid = iterator.next();
        }
        Expression condition = this.handleExpression(kid);
        if (iterator.hasNext()) {
            HiddenTokenAwareTree operatorToken = iterator.next();
            Expression followingExpression = this.handleExpression(iterator.next());
            condition = new ComparisonExpression(token, condition, this.toComparisonOperator(operatorToken), followingExpression);
        }
        return new GuardCondition(token, isNegated, condition);
    }

    private ComparisonExpressionOperator toComparisonOperator(HiddenTokenAwareTree token) {
        switch (token.getGeneralType()) {
            case 95: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.GREATER);
            }
            case 132: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.GREATER_OR_EQUAL);
            }
            case 124: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.OPEQ);
            }
            case 133: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.LOWER_OR_EQUAL);
            }
            case 134: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.LOWER);
            }
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    public void validateGuardNegation(HiddenTokenAwareTree token) {
        String operator = token.getText().trim();
        if (!"not".equals(operator)) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
    }

    public void validateGuardAnd(HiddenTokenAwareTree token) {
        String operator = token.getText().trim();
        if (!"and".equals(operator)) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
    }

    @Override
    public GeneralBody handleGeneralBody(HiddenTokenAwareTree token) {
        return this.createGeneralBody(token);
    }

    private List<ASTCssNode> handleBodyMembers(HiddenTokenAwareTree token) {
        if (token.getChildren() == null) {
            return new ArrayList<ASTCssNode>();
        }
        ArrayList<ASTCssNode> members = new ArrayList<ASTCssNode>();
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        while (iterator.hasNext()) {
            members.add((ASTCssNode)this.switchOn(iterator.next()));
        }
        return members;
    }

    @Override
    public SyntaxOnlyElement handleLbrace(HiddenTokenAwareTree token) {
        return this.toSyntaxOnlyElement(token);
    }

    @Override
    public SyntaxOnlyElement handleRbrace(HiddenTokenAwareTree token) {
        return this.toSyntaxOnlyElement(token);
    }

    @Override
    public Selector handleSelector(HiddenTokenAwareTree token) {
        SelectorBuilder builder = new SelectorBuilder(token, this);
        return builder.buildSelector();
    }

    @Override
    public ASTCssNode handleExtendTargetSelector(HiddenTokenAwareTree token) {
        token.pushHiddenToKids();
        if (token.getChildren().size() == 1) {
            Selector selector = (Selector)this.switchOn(token.getChildren().get(0));
            return this.convertSelectorToExtend(token, selector);
        }
        MultiTargetExtend extend = new MultiTargetExtend(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 81) {
                kid.pushHiddenToSiblings();
                continue;
            }
            Selector selector = (Selector)this.switchOn(kid);
            extend.addExtend(this.convertSelectorToExtend(token, selector));
        }
        return extend;
    }

    private Extend convertSelectorToExtend(HiddenTokenAwareTree token, Selector selector) {
        SelectorPart lastPart;
        if (selector.isExtending()) {
            this.problemsHandler.warnExtendInsideExtend(selector);
        }
        if ((lastPart = selector.getLastPart()) == null || !(lastPart instanceof SimpleSelector)) {
            return new Extend(token, selector);
        }
        SimpleSelector possibleAll = (SimpleSelector)lastPart;
        if (possibleAll.hasSubsequent() || !possibleAll.hasElement()) {
            return new Extend(token, selector);
        }
        if (!EXTEND_ALL_KEYWORD.equals(possibleAll.getElementName().getName())) {
            return new Extend(token, selector);
        }
        if (AstLogic.hasNonSpaceCombinator(possibleAll)) {
            possibleAll.setElementName(null);
        } else {
            selector.getParts().remove(possibleAll);
        }
        return new Extend(token, selector, true);
    }

    @Override
    public CssClass handleCssClass(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        List<HiddenTokenAwareTree> childrenWithoutdot = ArraysUtils.safeSublist(children, 1, children.size());
        return new CssClass(token, this.toInterpolableName(token, childrenWithoutdot));
    }

    @Override
    public SelectorAttribute handleSelectorAttribute(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 0) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        if (children.size() == 1) {
            return new SelectorAttribute(token, children.get(0).getText());
        }
        if (children.size() < 3) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        Expression value = this.handleTerm(children.get(2));
        switch (value.getType()) {
            case IDENTIFIER_EXPRESSION: 
            case STRING_EXPRESSION: 
            case NUMBER: {
                break;
            }
            default: {
                this.problemsHandler.warnLessjsIncompatibleSelectorAttributeValue(value);
            }
        }
        return new SelectorAttribute(token, children.get(0).getText(), this.handleSelectorOperator(children.get(1)), value);
    }

    @Override
    public SelectorOperator handleSelectorOperator(HiddenTokenAwareTree token) {
        return new SelectorOperator(token, this.toSelectorOperator(token));
    }

    private SelectorOperator.Operator toSelectorOperator(HiddenTokenAwareTree token) {
        switch (token.getGeneralType()) {
            case 124: {
                return SelectorOperator.Operator.EQUALS;
            }
            case 125: {
                return SelectorOperator.Operator.INCLUDES;
            }
            case 126: {
                return SelectorOperator.Operator.SPECIAL_PREFIX;
            }
            case 127: {
                return SelectorOperator.Operator.PREFIXMATCH;
            }
            case 128: {
                return SelectorOperator.Operator.SUFFIXMATCH;
            }
            case 129: {
                return SelectorOperator.Operator.SUBSTRINGMATCH;
            }
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    @Override
    public Pseudo handlePseudo(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 0 || children.size() == 1) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        HiddenTokenAwareTree t = children.get(1);
        if (t.getGeneralType() == 90) {
            return this.createPseudoElement(token, 2, false);
        }
        if (COLONLESS_PSEUDOELEMENTS.contains(t.getText().toLowerCase())) {
            return this.createPseudoElement(token, 1, true);
        }
        String pseudoClassName = children.get(1).getText();
        if (children.size() == 2) {
            return new PseudoClass(token, pseudoClassName);
        }
        if (children.size() >= 3) {
            HiddenTokenAwareTree parameter = children.get(2);
            if (parameter.getGeneralType() == 105) {
                return new PseudoClass(token, pseudoClassName, this.toInterpolabledVariable(parameter, parameter.getText()));
            }
            return new PseudoClass(token, pseudoClassName, (ASTCssNode)this.switchOn(parameter));
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    @Override
    public Nth handleNth(HiddenTokenAwareTree token) {
        Expression first = null;
        Expression second = null;
        if (this.hasChildren(token.getChild(0))) {
            first = this.termBuilder.buildFromChildTerm(token.getChild(0));
            String sign = "";
            if (first.getType() == ASTCssNodeType.SIGNED_EXPRESSION) {
                SignedExpression negated = (SignedExpression)first;
                first = negated.getExpression();
                sign = negated.getSign().toSymbol();
            }
            if (first.getType() == ASTCssNodeType.IDENTIFIER_EXPRESSION) {
                IdentifierExpression ident = (IdentifierExpression)first;
                String lowerCaseValue = ident.getValue().toLowerCase();
                lowerCaseValue = sign + lowerCaseValue;
                if ("even".equals(lowerCaseValue)) {
                    return new Nth(token, null, null, Nth.Form.EVEN);
                }
                if ("odd".equals(lowerCaseValue)) {
                    return new Nth(token, null, null, Nth.Form.ODD);
                }
                if ("n".equals(lowerCaseValue) || "-n".equals(lowerCaseValue) || "+n".equals(lowerCaseValue)) {
                    boolean expliciteSign = !"n".equals(lowerCaseValue);
                    first = new NumberExpression(token.getChild(0), lowerCaseValue, NumberExpression.Dimension.REPEATER, expliciteSign);
                } else {
                    throw new IllegalStateException("Unexpected identifier value for nth: " + ident.getValue());
                }
            }
        }
        if (token.getChild(1) != null && this.hasChildren(token.getChild(1))) {
            second = this.termBuilder.buildFromChildTerm(token.getChild(1));
        }
        return new Nth(token, (NumberExpression)first, (NumberExpression)second);
    }

    private boolean hasChildren(HiddenTokenAwareTree token) {
        return token.getChildren() != null && !token.getChildren().isEmpty();
    }

    private PseudoElement createPseudoElement(HiddenTokenAwareTree token, int startIndex, boolean level12Form) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        String name = children.get(startIndex).getText();
        return new PseudoElement(token, name, level12Form);
    }

    @Override
    public IdSelector handleIdSelector(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        return new IdSelector(token, this.toInterpolableName(token, children));
    }

    private InterpolableName toInterpolableName(HiddenTokenAwareTree token, List<HiddenTokenAwareTree> children) {
        InterpolableName result = new InterpolableName(token);
        for (HiddenTokenAwareTree kid : children) {
            String text = kid.getText();
            if (text == null || text.length() < 1) {
                throw new BugHappened(GRAMMAR_MISMATCH, kid);
            }
            if (kid.getGeneralType() == 105) {
                result.add((InterpolableNamePart)new VariableNamePart(kid, this.toInterpolabledVariable(kid, text)));
                continue;
            }
            if (kid.getGeneralType() == 112) continue;
            result.add((InterpolableNamePart)new FixedNamePart(kid, this.toFixedName(kid.getGeneralType(), text)));
        }
        return result;
    }

    private Variable toInterpolabledVariable(HiddenTokenAwareTree token, String text) {
        return new Variable(token, "@" + text.substring(2, text.length() - 1), true);
    }

    private String toFixedName(int typeCode, String text) {
        if (typeCode == 111) {
            return text.substring(1);
        }
        return text;
    }

    @Override
    public Media handleMedia(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        Media result = new Media(token);
        this.handleMediaDeclaration(result, children.next());
        result.setBody(this.handleGeneralBody(children.next()));
        return result;
    }

    private void handleMediaDeclaration(Media result, HiddenTokenAwareTree declaration) {
        declaration.pushHiddenToKids();
        List<HiddenTokenAwareTree> children = declaration.getChildren();
        ASTCssNode previousKid = null;
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 81) {
                previousKid.getUnderlyingStructure().addFollowing(kid.getPreceding());
                continue;
            }
            previousKid = this.handleMediaQuery(kid);
            result.addMediaQuery((MediaQuery)previousKid);
        }
    }

    @Override
    public MediaQuery handleMediaQuery(HiddenTokenAwareTree token) {
        MediaQuery result = new MediaQuery(token);
        List<HiddenTokenAwareTree> originalChildren = token.getChildren();
        LinkedList<HiddenTokenAwareTree> children = new LinkedList<HiddenTokenAwareTree>();
        for (HiddenTokenAwareTree kid : originalChildren) {
            if (kid.getGeneralType() == 73) {
                HiddenTokenAwareTree lastKid = (HiddenTokenAwareTree)children.peekLast();
                if (lastKid == null) continue;
                lastKid.addFollowing(kid.getPreceding());
                continue;
            }
            children.add(kid);
        }
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 73) continue;
            result.addMember((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public Medium handleMedium(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 1) {
            HiddenTokenAwareTree type = children.get(0);
            return new Medium(token, new MediumModifier(type), new MediumType(type, type.getText()));
        }
        HiddenTokenAwareTree type = children.get(1);
        return new Medium(token, this.toMediumModifier(children.get(0)), new MediumType(type, type.getText()));
    }

    @Override
    public FixedMediaExpression handleMediaExpression(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree featureNode = children.get(0);
        if (children.size() == 1) {
            return new FixedMediaExpression(token, new MediaExpressionFeature(featureNode, featureNode.getText()), null);
        }
        if (children.size() == 2) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        HiddenTokenAwareTree colonNode = children.get(1);
        featureNode.addFollowing(colonNode.getPreceding());
        HiddenTokenAwareTree expressionNode = children.get(2);
        Expression expression = (Expression)this.switchOn(expressionNode);
        return new FixedMediaExpression(token, new MediaExpressionFeature(featureNode, featureNode.getText()), expression);
    }

    @Override
    public InterpolatedMediaExpression handleInterpolatedMediaExpression(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        while (children.hasNext()) {
            Variable expression = (Variable)this.switchOn(children.next());
            expressions.add(expression);
        }
        ListExpression list = new ListExpression(token, expressions, new ListExpressionOperator(token, ListExpressionOperator.Operator.EMPTY_OPERATOR));
        return new InterpolatedMediaExpression(token, list);
    }

    private MediumModifier toMediumModifier(HiddenTokenAwareTree token) {
        String modifier = token.getText().toLowerCase();
        if ("not".equals(modifier)) {
            return new MediumModifier(token, MediumModifier.Modifier.NOT);
        }
        if ("only".equals(modifier)) {
            return new MediumModifier(token, MediumModifier.Modifier.ONLY);
        }
        throw new IllegalStateException("Unexpected medium modifier: " + modifier);
    }

    @Override
    public VariableDeclaration handleVariableDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree name = children.get(0);
        HiddenTokenAwareTree colon = children.get(1);
        HiddenTokenAwareTree expression = children.get(2);
        if (children.size() > 3) {
            HiddenTokenAwareTree semi = children.get(3);
            colon.giveHidden(name, expression);
            semi.giveHidden(expression, null);
            token.addBeforeFollowing(semi.getFollowing());
        }
        Variable variable = new Variable(name, name.getText());
        Expression value = this.variableValue(token, expression);
        return new VariableDeclaration(token, variable, value);
    }

    private Expression variableValue(HiddenTokenAwareTree underlyingIfEmpty, HiddenTokenAwareTree expression) {
        if (expression.getGeneralType() == 77) {
            return new EmptyExpression(underlyingIfEmpty);
        }
        return (Expression)this.switchOn(expression);
    }

    @Override
    public ArgumentDeclaration handleArgumentDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree firstChild = children.get(0);
        if (firstChild.getGeneralType() == 93) {
            return new ArgumentDeclaration(firstChild, new Variable(firstChild, "@", false, true), null);
        }
        HiddenTokenAwareTree name = firstChild;
        if (children.size() == 1) {
            return new ArgumentDeclaration(token, new Variable(name, name.getText()), null);
        }
        HiddenTokenAwareTree separator = children.get(1);
        if (separator.getGeneralType() == 93) {
            return new ArgumentDeclaration(token, new Variable(name, name.getText(), false, true), null);
        }
        HiddenTokenAwareTree expression = children.get(2);
        separator.giveHidden(name, expression);
        return new ArgumentDeclaration(token, new Variable(name, name.getText()), (Expression)this.switchOn(expression));
    }

    @Override
    public ASTCssNode handleNestedAppender(HiddenTokenAwareTree token) {
        boolean directlyBefore = true;
        boolean directlyAfter = true;
        if (token.getChildren().size() == 2) {
            directlyBefore = this.isMeaningfullWhitespace(token);
            directlyAfter = !directlyBefore;
        } else if (token.getChildren().size() == 3) {
            directlyBefore = false;
            directlyAfter = false;
        }
        return new NestedSelectorAppender(token, directlyBefore, directlyAfter, null);
    }

    @Override
    public SimpleSelector handleElementName(HiddenTokenAwareTree kid) {
        List<HiddenTokenAwareTree> elementNameParts = kid.getChildren();
        InterpolableName interpolableName = this.toInterpolableName(kid, elementNameParts);
        SimpleSelector result = new SimpleSelector(kid, null, interpolableName, this.isStarElementName(elementNameParts));
        return result;
    }

    private boolean isStarElementName(List<HiddenTokenAwareTree> elementNameParts) {
        if (elementNameParts.size() != 1) {
            return false;
        }
        return elementNameParts.get(0).getGeneralType() == 101;
    }

    @Override
    public EscapedSelector handleEscapedSelector(HiddenTokenAwareTree token) {
        token.pushHiddenToKids();
        HiddenTokenAwareTree valueToken = token.getChild(0);
        String quotedText = valueToken.getText();
        return new EscapedSelector(valueToken, quotedText.substring(2, quotedText.length() - 1), "" + quotedText.charAt(1), null);
    }

    private boolean isMeaningfullWhitespace(HiddenTokenAwareTree kid) {
        int type = kid.getChild(0).getGeneralType();
        return type == 106 || type == 47;
    }

    @Override
    public Keyframes handleKeyframes(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        Keyframes result = new Keyframes(token, children.next().getText());
        result.addNames(this.handleKeyframesDeclaration(children.next()));
        result.setBody(this.handleGeneralBody(children.next()));
        return result;
    }

    @Override
    public Supports handleSupports(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        Supports result = new Supports(token, children.next().getText());
        result.setCondition((SupportsCondition)this.switchOn(children.next()));
        result.setBody(this.handleGeneralBody(children.next()));
        return result;
    }

    @Override
    public SupportsCondition handleSupportsCondition(HiddenTokenAwareTree token) {
        token.pushHiddenToKids();
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        if (token.getChildCount() == 1) {
            return (SupportsCondition)this.switchOn(children.next());
        }
        SupportsLogicalCondition result = new SupportsLogicalCondition(token, (SupportsCondition)this.switchOn(children.next()));
        while (children.hasNext()) {
            SupportsLogicalOperator logicalOperator = this.toSupportsLogicalOperator(children.next());
            if (!children.hasNext()) {
                throw new BugHappened(GRAMMAR_MISMATCH, token);
            }
            SupportsCondition condition = (SupportsCondition)this.switchOn(children.next());
            result.addCondition(logicalOperator, condition);
        }
        return result;
    }

    private SupportsLogicalOperator toSupportsLogicalOperator(HiddenTokenAwareTree token) {
        String text = token.getText();
        Map<String, SupportsLogicalOperator.Operator> operatorsBySymbol = SupportsLogicalOperator.Operator.getSymbolsMap();
        if (text == null || !operatorsBySymbol.containsKey(text.toLowerCase())) {
            SupportsLogicalOperator result = new SupportsLogicalOperator(token, null);
            this.problemsHandler.errWrongSupportsLogicalOperator(result, token.getText());
            return result;
        }
        SupportsLogicalOperator result = new SupportsLogicalOperator(token, operatorsBySymbol.get(text.toLowerCase()));
        return result;
    }

    @Override
    public SupportsCondition handleSupportsSimpleCondition(HiddenTokenAwareTree token) {
        token.pushHiddenToKids();
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        HiddenTokenAwareTree first = children.next();
        if (first.getGeneralType() == 82) {
            SyntaxOnlyElement openingParentheses = this.toSyntaxOnlyElement(first);
            SupportsCondition condition = (SupportsCondition)this.switchOn(children.next());
            SyntaxOnlyElement closingParentheses = this.toSyntaxOnlyElement(children.next());
            SupportsConditionInParentheses result = new SupportsConditionInParentheses(token, openingParentheses, condition, closingParentheses);
            return result;
        }
        if (first.getGeneralType() == 73) {
            SyntaxOnlyElement negation = this.toSyntaxOnlyElement(first);
            SupportsCondition condition = (SupportsCondition)this.switchOn(children.next());
            SupportsConditionNegation result = new SupportsConditionNegation(token, negation, condition);
            return result;
        }
        return (SupportsCondition)this.switchOn(first);
    }

    @Override
    public SupportsCondition handleSupportsQuery(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        SyntaxOnlyElement openingParentheses = this.toSyntaxOnlyElement(children.next());
        Declaration declaration = (Declaration)this.switchOn(children.next());
        SyntaxOnlyElement closingParentheses = this.toSyntaxOnlyElement(children.next());
        SupportsQuery result = new SupportsQuery(token, openingParentheses, closingParentheses, declaration);
        return result;
    }

    private SyntaxOnlyElement toSyntaxOnlyElement(HiddenTokenAwareTree token) {
        return new SyntaxOnlyElement(token, token.getText());
    }

    @Override
    public Document handleDocument(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        Document result = new Document(token, children.next().getText());
        result.addUrlMatchFunctions(this.handleUrlMatchFunctionsDeclaration(children.next()));
        result.setBody(this.handleGeneralBody(children.next()));
        return result;
    }

    private List<FunctionExpression> handleUrlMatchFunctionsDeclaration(HiddenTokenAwareTree declaration) {
        ArrayList<FunctionExpression> result = new ArrayList<FunctionExpression>();
        for (HiddenTokenAwareTree token : declaration.getChildren()) {
            if (token.getGeneralType() == 81) {
                token.pushHiddenToSiblings();
                continue;
            }
            ASTCssNode urlMatchFunction = (ASTCssNode)this.switchOn(token);
            if (urlMatchFunction.getType() == ASTCssNodeType.FUNCTION) {
                result.add((FunctionExpression)this.termBuilder.buildFromChildTerm(token));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        return result;
    }

    @Override
    public Viewport handleViewport(HiddenTokenAwareTree token) {
        Viewport result = new Viewport(token, token.getChild(0).getText());
        HiddenTokenAwareTree body = token.getChild(1);
        result.setBody(this.createGeneralBody(body));
        return result;
    }

    private GeneralBody createGeneralBody(HiddenTokenAwareTree token) {
        List<ASTCssNode> list = this.handleBodyMembers(token);
        if (list.size() < 2) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        SyntaxOnlyElement lbrace = (SyntaxOnlyElement)list.remove(0);
        SyntaxOnlyElement rbrace = (SyntaxOnlyElement)list.remove(list.size() - 1);
        List<CommonToken> orphansOrFollowLastMember = rbrace.getUnderlyingStructure().chopPreceedingUpToLastOfType(194);
        if (list.isEmpty()) {
            token.addOrphans(orphansOrFollowLastMember);
        } else {
            list.get(list.size() - 1).getUnderlyingStructure().addFollowing(orphansOrFollowLastMember);
        }
        return new GeneralBody(token, lbrace, rbrace, list);
    }

    private List<KeyframesName> handleKeyframesDeclaration(HiddenTokenAwareTree declaration) {
        ArrayList<KeyframesName> result = new ArrayList<KeyframesName>();
        for (HiddenTokenAwareTree token : declaration.getChildren()) {
            if (token.getGeneralType() == 81) {
                token.pushHiddenToSiblings();
                continue;
            }
            if (token.getGeneralType() == 76 || token.getGeneralType() == 73 || token.getGeneralType() == 89 || token.getGeneralType() == 94 || token.getGeneralType() == 9) {
                result.add(new KeyframesName(token.commentsLessClone(), this.termBuilder.buildFromTerm(token)));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        return result;
    }

    @Override
    public Page handlePage(HiddenTokenAwareTree token) {
        Page result = new Page(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 73) {
                result.setName(new Name(kid, kid.getText()));
                continue;
            }
            if (kid.getGeneralType() == 58) {
                int pseudoPageIndex = 1;
                if (kid.getChild(0).getGeneralType() == 106) {
                    pseudoPageIndex = 2;
                    result.setDockedPseudopage(false);
                    kid.addPreceding(kid.getChild(0).getPreceding());
                }
                if (kid.getChild(1).getGeneralType() == 90) {
                    kid.addPreceding(kid.getChild(1).getPreceding());
                }
                result.setPseudopage(new Name(kid, ":" + kid.getChild(pseudoPageIndex).getText()));
                continue;
            }
            if (kid.getGeneralType() == 38) {
                result.setBody(this.createGeneralBody(kid));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, kid);
        }
        return result;
    }

    @Override
    public PageMarginBox handlePageMarginBox(HiddenTokenAwareTree token) {
        PageMarginBox result = new PageMarginBox(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 89) {
                result.setName(new Name(kid, kid.getText()));
                continue;
            }
            if (kid.getGeneralType() == 38) {
                result.setBody(this.createGeneralBody(kid));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, kid);
        }
        return result;
    }

    @Override
    public Import handleImport(HiddenTokenAwareTree token) {
        Import result = new Import(token);
        switch (token.getGeneralType()) {
            case 78: {
                result.setMultiplicity(Import.ImportMultiplicity.IMPORT);
                break;
            }
            case 79: {
                result.setMultiplicity(Import.ImportMultiplicity.IMPORT_ONCE);
                this.problemsHandler.deprecatedImportOnce(result);
                break;
            }
            case 80: {
                result.setMultiplicity(Import.ImportMultiplicity.IMPORT_MULTIPLE);
                this.problemsHandler.deprecatedImportMultiple(result);
                break;
            }
            default: {
                throw new BugHappened(GRAMMAR_MISMATCH, token);
            }
        }
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        HiddenTokenAwareTree nextChild = children.next();
        if (nextChild.getGeneralType() == 35) {
            this.configureImportOptions(result, nextChild.getChildren());
            nextChild = children.next();
        }
        result.setUrlExpression(this.handleTerm(nextChild));
        while (children.hasNext()) {
            HiddenTokenAwareTree kid = children.next();
            if (kid.getGeneralType() == 81) {
                kid.pushHiddenToSiblings();
                continue;
            }
            if (kid.getGeneralType() == 36) {
                result.add(this.handleMediaQuery(kid));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        return result;
    }

    private void configureImportOptions(Import node, List<HiddenTokenAwareTree> options) {
        for (HiddenTokenAwareTree token : options) {
            String text = token.getText();
            if (IMPORT_OPTION_INLINE.equals(text)) {
                node.setInline(true);
                continue;
            }
            if (IMPORT_OPTION_ONCE.equals(text)) {
                node.setMultiplicity(Import.ImportMultiplicity.IMPORT_ONCE);
                continue;
            }
            if (IMPORT_OPTION_MULTIPLE.equals(text)) {
                node.setMultiplicity(Import.ImportMultiplicity.IMPORT_MULTIPLE);
                continue;
            }
            if (IMPORT_OPTION_LESS.equals(text)) {
                node.setContentKind(Import.ImportContent.LESS);
                continue;
            }
            if (IMPORT_OPTION_CSS.equals(text)) {
                node.setContentKind(Import.ImportContent.CSS);
                continue;
            }
            if (IMPORT_OPTION_REFERENCE.equals(text)) {
                node.setReferenceOnly(true);
                continue;
            }
            if (IMPORT_OPTION_OPTIONAL.equals(text)) {
                node.setOptional(true);
                continue;
            }
            this.problemsHandler.unknownImportOption(node, text);
        }
    }

    @Override
    public NamedExpression handleNamedExpression(HiddenTokenAwareTree token) {
        HiddenTokenAwareTree nameToken = token.getChild(0);
        HiddenTokenAwareTree valueToken = token.getChild(1);
        Expression value = (Expression)this.switchOn(valueToken);
        return new NamedExpression(token, nameToken.getText(), value);
    }

    @Override
    public ASTCssNode handleExtendInDeclaration(HiddenTokenAwareTree token) {
        HiddenTokenAwareTree child = token.getChild(0);
        Pseudo extendAsPseudo = this.handlePseudo(child);
        if (!(extendAsPseudo instanceof PseudoClass)) {
            throw new BugHappened(GRAMMAR_MISMATCH, (ASTCssNode)extendAsPseudo);
        }
        PseudoClass asPseudoclass = (PseudoClass)extendAsPseudo;
        ASTCssNode parameter = asPseudoclass.getParameter();
        if (parameter.getType() != ASTCssNodeType.EXTEND && parameter.getType() != ASTCssNodeType.MULTI_TARGET_EXTEND) {
            throw new BugHappened(GRAMMAR_MISMATCH, (ASTCssNode)extendAsPseudo);
        }
        return parameter;
    }

    @Override
    public UnknownAtRule handleUnknownAtRule(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        UnknownAtRule result = new UnknownAtRule(token, children.next().getText());
        block5: while (children.hasNext()) {
            HiddenTokenAwareTree next = children.next();
            switch (next.getGeneralType()) {
                case 65: {
                    result.addNames(this.handleUnknownAtRuleDeclaration(next));
                    continue block5;
                }
                case 38: {
                    result.setBody(this.handleGeneralBody(next));
                    continue block5;
                }
                case 77: {
                    result.setSemicolon(this.toSyntaxOnlyElement(next));
                    continue block5;
                }
            }
            throw new BugHappened(GRAMMAR_MISMATCH, next);
        }
        this.problemsHandler.warnUnknowAtRule(result);
        return result;
    }

    private List<Expression> handleUnknownAtRuleDeclaration(HiddenTokenAwareTree declaration) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (HiddenTokenAwareTree token : declaration.getChildren()) {
            if (token.getGeneralType() == 81) {
                token.pushHiddenToSiblings();
                continue;
            }
            result.add(this.handleExpression(token));
        }
        return result;
    }

    static {
        COLONLESS_PSEUDOELEMENTS.add("first-line");
        COLONLESS_PSEUDOELEMENTS.add("first-letter");
        COLONLESS_PSEUDOELEMENTS.add("before");
        COLONLESS_PSEUDOELEMENTS.add("after");
    }
}

