/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.Token;

public class LexerLogic {
    private static final String KEYFRAMES = "keyframes";
    private static final String DOCUMENT = "document";
    private static final String VIEWPORT = "viewport";
    private static final String SUPPORTS = "supports";
    private static final String CHARSET = "charset";
    private static final Set<String> PAGE_MARGIN_BOXES = new HashSet<String>(Arrays.asList("@top-left-corner", "@top-left", "@top-center", "@top-right", "@top-right-corner", "@bottom-left-corner", "@bottom-left", "@bottom-center", "@bottom-right", "@bottom-right-corner", "@left-top", "@left-middle", "@left-bottom", "@right-top", "@right-middle", "@right-bottom"));

    public int atNameType(String text) {
        if (text == null) {
            return 89;
        }
        if (text.toLowerCase().endsWith(DOCUMENT)) {
            return 86;
        }
        if (text.toLowerCase().endsWith(KEYFRAMES)) {
            return 85;
        }
        if (text.toLowerCase().endsWith(VIEWPORT)) {
            return 87;
        }
        if (text.toLowerCase().endsWith(SUPPORTS)) {
            return 88;
        }
        if (text.toLowerCase().endsWith(CHARSET)) {
            return 75;
        }
        return 89;
    }

    public boolean isAtName(int type) {
        return type == 89 || type == 86 || type == 85 || type == 87 || type == 88 || type == 75;
    }

    public boolean isIdentifier(int type) {
        return type == 73 || type == 71 || type == 74 || type == 67 || type == 68 || type == 69 || type == 70 || type == 72;
    }

    public boolean isPageMarginBox(Token token) {
        return this.isAmongAtNames(token, PAGE_MARGIN_BOXES);
    }

    private boolean isAmongAtNames(Token token, Set<String> atNames) {
        if (token.getType() != 89 || token.getText() == null) {
            return false;
        }
        String text = token.getText().toLowerCase();
        return atNames.contains(text);
    }

    public boolean truthy() {
        return true;
    }
}

