/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.DetachedRuleset;
import com.github.sommeri.less4j.core.ast.DetachedRulesetReference;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.expressions.GuardValue;
import com.github.sommeri.less4j.core.compiler.expressions.MixinsGuardsValidator;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.compiler.stages.ArgumentsBuilder;
import com.github.sommeri.less4j.core.compiler.stages.AstNodesStack;
import com.github.sommeri.less4j.core.compiler.stages.BodyCompilationResult;
import com.github.sommeri.less4j.core.compiler.stages.CallerCalleeScopeJoiner;
import com.github.sommeri.less4j.core.compiler.stages.DefaultGuardHelper;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.compiler.stages.ReturnMode;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

class MixinsRulesetsSolver {
    private final ProblemsHandler problemsHandler;
    private final ReferencesSolver parentSolver;
    private final AstNodesStack semiCompiledNodes;
    private final LessCompiler.Configuration configuration;
    private final DefaultGuardHelper defaultGuardHelper;
    private final CallerCalleeScopeJoiner scopeManipulation = new CallerCalleeScopeJoiner();

    public MixinsRulesetsSolver(ReferencesSolver parentSolver, AstNodesStack semiCompiledNodes, ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.parentSolver = parentSolver;
        this.semiCompiledNodes = semiCompiledNodes;
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
        this.defaultGuardHelper = new DefaultGuardHelper(problemsHandler);
    }

    private BodyCompilationResult resolveCalledBody(final IScope callerScope, final BodyOwner<?> bodyOwner, IScope bodyWorkingScope, final ReturnMode returnMode) {
        final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(bodyWorkingScope, this.problemsHandler, this.configuration);
        final IScope referencedMixinScope = bodyWorkingScope;
        return InScopeSnapshotRunner.runInOriginalDataSnapshot(referencedMixinScope, new InScopeSnapshotRunner.IFunction<BodyCompilationResult>(){

            @Override
            public BodyCompilationResult run() {
                List replacement = MixinsRulesetsSolver.this.compileBody(bodyOwner.getBody(), referencedMixinScope);
                IScope returnValues = ScopeFactory.createDummyScope();
                if (returnMode == ReturnMode.MIXINS_AND_VARIABLES) {
                    returnValues.addFilteredVariables(new ImportedScopeFilter(expressionEvaluator, callerScope), referencedMixinScope);
                }
                List<FullMixinDefinition> unmodifiedMixinsToImport = referencedMixinScope.getAllMixins();
                List<FullMixinDefinition> allMixinsToImport = MixinsRulesetsSolver.this.scopeManipulation.mixinsToImport(callerScope, referencedMixinScope, unmodifiedMixinsToImport);
                returnValues.addAllMixins(allMixinsToImport);
                return new BodyCompilationResult((ASTCssNode)((Object)bodyOwner), replacement, returnValues);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ASTCssNode> compileBody(Body body, IScope scopeSnapshot) {
        this.semiCompiledNodes.push(body.getParent());
        try {
            Body bodyClone = body.clone();
            this.parentSolver.unsafeDoSolveReferences((ASTCssNode)bodyClone, scopeSnapshot);
            List<ASTCssNode> list = bodyClone.getMembers();
            return list;
        }
        finally {
            this.semiCompiledNodes.pop();
        }
    }

    private void shiftComments(ASTCssNode reference, GeneralBody result) {
        List<ASTCssNode> childs = result.getMembers();
        if (!childs.isEmpty()) {
            childs.get(0).addOpeningComments(reference.getOpeningComments());
            childs.get(childs.size() - 1).addTrailingComments(reference.getTrailingComments());
        }
    }

    private IScope buildMixinsArguments(MixinReference reference, IScope referenceScope, FullMixinDefinition mixin) {
        ArgumentsBuilder builder = new ArgumentsBuilder(reference, mixin.getMixin(), new ExpressionEvaluator(referenceScope, this.problemsHandler, this.configuration), this.problemsHandler);
        return builder.build();
    }

    public GeneralBody buildMixinReferenceReplacement(final MixinReference reference, final IScope callerScope, List<FullMixinDefinition> mixins) {
        GeneralBody result = new GeneralBody(reference.getUnderlyingStructure());
        if (mixins.isEmpty()) {
            return result;
        }
        final ArrayList<BodyCompilationResult> compiledMixins = new ArrayList<BodyCompilationResult>();
        for (final FullMixinDefinition fullMixin : mixins) {
            final ReusableStructure mixin = fullMixin.getMixin();
            final IScope mixinScope = fullMixin.getScope();
            InScopeSnapshotRunner.runInLocalDataSnapshot(mixinScope.getParent(), new InScopeSnapshotRunner.ITask(){

                @Override
                public void run() {
                    IScope mixinArguments = MixinsRulesetsSolver.this.buildMixinsArguments(reference, callerScope, fullMixin);
                    mixinScope.getParent().add(mixinArguments);
                    IScope mixinWorkingScope = MixinsRulesetsSolver.this.scopeManipulation.joinIfIndependent(callerScope, mixinScope);
                    MixinsGuardsValidator guardsValidator = new MixinsGuardsValidator(mixinWorkingScope, MixinsRulesetsSolver.this.problemsHandler, MixinsRulesetsSolver.this.configuration);
                    GuardValue guardValue = guardsValidator.evaluateGuards(mixin);
                    if (guardValue != GuardValue.DO_NOT_USE) {
                        BodyCompilationResult compiled = MixinsRulesetsSolver.this.resolveCalledBody(callerScope, fullMixin.getMixin(), mixinWorkingScope, ReturnMode.MIXINS_AND_VARIABLES);
                        compiled.setGuardValue(guardValue);
                        compiledMixins.add(compiled);
                    }
                }
            });
        }
        List<BodyCompilationResult> mixinsToBeUsed = this.defaultGuardHelper.chooseMixinsToBeUsed(compiledMixins, reference);
        for (BodyCompilationResult compiled : mixinsToBeUsed) {
            result.addMembers(compiled.getReplacement());
            callerScope.addToDataPlaceholder(compiled.getReturnValues());
        }
        callerScope.closeDataPlaceholder();
        this.resolveImportance(reference, result);
        this.shiftComments(reference, result);
        return result;
    }

    public GeneralBody buildDetachedRulesetReplacement(DetachedRulesetReference reference, IScope callerScope, DetachedRuleset detachedRuleset, IScope detachedRulesetScope) {
        IScope mixinWorkingScope = this.scopeManipulation.joinIfIndependent(callerScope, detachedRulesetScope);
        BodyCompilationResult compiled = this.resolveCalledBody(callerScope, detachedRuleset, mixinWorkingScope, ReturnMode.MIXINS);
        GeneralBody result = new GeneralBody(reference.getUnderlyingStructure());
        result.addMembers(compiled.getReplacement());
        callerScope.addToDataPlaceholder(compiled.getReturnValues());
        callerScope.closeDataPlaceholder();
        this.shiftComments(reference, result);
        return result;
    }

    private void resolveImportance(MixinReference reference, GeneralBody result) {
        if (reference.isImportant()) {
            this.declarationsAreImportant(result);
        }
    }

    private void declarationsAreImportant(Body result) {
        for (ASTCssNode kid : result.getMembers()) {
            if (kid instanceof Declaration) {
                Declaration declaration = (Declaration)kid;
                declaration.setImportant(true);
                continue;
            }
            if (!(kid instanceof BodyOwner)) continue;
            BodyOwner owner = (BodyOwner)((Object)kid);
            this.declarationsAreImportant((Body)owner.getBody());
        }
    }

    class ImportedScopeFilter
    implements ExpressionFilter {
        private final ExpressionEvaluator expressionEvaluator;
        private final IScope importTargetScope;
        private final CallerCalleeScopeJoiner scopeManipulation = new CallerCalleeScopeJoiner();

        public ImportedScopeFilter(ExpressionEvaluator expressionEvaluator, IScope importTargetScope) {
            this.expressionEvaluator = expressionEvaluator;
            this.importTargetScope = importTargetScope;
        }

        @Override
        public Expression apply(Expression input) {
            Expression result = this.expressionEvaluator.evaluate(input);
            IScope newScope = this.apply(result.getScope());
            result.setScope(newScope);
            return result;
        }

        private IScope apply(IScope input) {
            if (input == null) {
                return this.importTargetScope;
            }
            return this.scopeManipulation.joinIfIndependentAndPreserveContent(this.importTargetScope, input);
        }

        @Override
        public boolean accepts(String name, Expression value) {
            return true;
        }
    }
}

