/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.util.ArrayList;
import java.util.Iterator;

public class SelectorBuilder {
    private static String EXTEND_PSEUDO = "extend";
    private final HiddenTokenAwareTree token;
    private final ASTBuilderSwitch parent;

    public SelectorBuilder(HiddenTokenAwareTree token, ASTBuilderSwitch astBuilderSwitch) {
        this.token = token;
        this.parent = astBuilderSwitch;
    }

    public Selector buildSelector() {
        Iterator<HiddenTokenAwareTree> iterator = this.token.getChildren().iterator();
        Selector result = new Selector(this.token, new ArrayList<SelectorPart>());
        while (iterator.hasNext()) {
            SelectorCombinator combinator = null;
            SelectorPart part = null;
            HiddenTokenAwareTree kid = iterator.next();
            if (ConversionUtils.isSelectorCombinator(kid)) {
                combinator = ConversionUtils.createSelectorCombinator(kid);
                kid = iterator.next();
                part = (SelectorPart)this.parent.switchOn(kid);
                if (this.isDescendant(combinator) && kid.getType() == 11) {
                    combinator = null;
                }
            } else {
                part = (SelectorPart)this.parent.switchOn(kid);
            }
            part.setLeadingCombinator(combinator);
            if (combinator != null) {
                part.getUnderlyingStructure().moveHidden(combinator.getUnderlyingStructure(), null);
            }
            this.addPart(result, part);
        }
        return result;
    }

    private void addPart(Selector selector, SelectorPart part) {
        ElementSubsequent lastSubsequent = part.getLastSubsequent();
        while (lastSubsequent != null && this.isExtends(lastSubsequent)) {
            Extend extend = this.convertToExtend((PseudoClass)lastSubsequent);
            selector.addExtend(extend);
            part.removeSubsequent(lastSubsequent);
            lastSubsequent = part.getLastSubsequent();
        }
        if (!part.isEmpty()) {
            selector.addPart(part);
        }
    }

    private Extend convertToExtend(PseudoClass extend) {
        ASTCssNode parameter = extend.getParameter();
        if (parameter.getType() != ASTCssNodeType.EXTEND) {
            throw new BugHappened("ASTBuilderSwitch grammar mismatch", parameter.getUnderlyingStructure());
        }
        return (Extend)parameter;
    }

    private boolean isExtends(ElementSubsequent subsequent) {
        return subsequent instanceof PseudoClass && EXTEND_PSEUDO.equals(subsequent.getName());
    }

    private boolean isDescendant(SelectorCombinator combinator) {
        return combinator != null && combinator.getCombinatorType() == SelectorCombinator.CombinatorType.DESCENDANT;
    }
}

