/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.microsemi;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spinal.core.Bits;
import spinal.core.HardType$;
import spinal.core.HertzNumber;
import spinal.core.SpinalVhdl$;
import spinal.core.TimeNumber;
import spinal.core.package;
import spinal.core.package$;
import spinal.lib.DoCmd$;
import spinal.lib.StreamFifo;
import spinal.lib.StreamFifo$;
import spinal.lib.eda.bench.Report;
import spinal.lib.eda.bench.Report$class;

public final class LiberoFlow$ {
    public static final LiberoFlow$ MODULE$;

    static {
        new LiberoFlow$();
    }

    public Report apply(String liberoPath, String workspacePath, String toplevelPath, String family, String device, HertzNumber frequencyTarget, int processorCount) {
        String projectName = (String)Predef$.MODULE$.refArrayOps((Object[])((String)Predef$.MODULE$.refArrayOps((Object[])toplevelPath.split("/")).last()).split("[.]")).head();
        TimeNumber targetPeriod = (frequencyTarget == null ? package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(100)) : frequencyTarget).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory((File)workspacePathFile);
        workspacePathFile.mkdir();
        boolean isVhdl = toplevelPath.endsWith(".vhd") || toplevelPath.endsWith(".vhdl");
        String[] device_parameters = device.split("-");
        String device_die = device_parameters[0];
        String device_package = device_parameters[1];
        String device_speed = device_parameters[2];
        FileWriter tcl = new FileWriter(Paths.get(workspacePath, "doit.tcl").toFile());
        tcl.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new_project\\\\\n  -location {", "} \\\\\n  -name {", "} \\\\\n  -project_description {} \\\\\n  -hdl {", "} \\\\\n  -family {", "} \\\\\n  -die {", "} \\\\\n  -package {", "} \\\\\n  -speed {-", "}\n\ncreate_links \\\\\n  -hdl_source {", "}\n\nrun_tool -name {SYNTHESIZE} -script {} -defvar {} -defvars {}\n\nrun_tool -name {PLACEROUTE} -script {} -defvar {} -defvars {}\n\nrun_tool -name {VERIFYTIMING} -script {} -defvar {} -defvars {}\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Paths.get(workspacePath, projectName), projectName, isVhdl ? "VHDL" : "VERILOG", family, device_die, device_package, device_speed, new File(toplevelPath).getAbsolutePath()})));
        tcl.flush();
        tcl.close();
        DoCmd$.MODULE$.doCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/libero SCRIPT:doit.tcl"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{liberoPath})), ((Object)Paths.get(workspacePath, new String[0])).toString());
        return new Report(workspacePath, family, projectName){
            private final String workspacePath$1;
            private final String family$1;
            private final String projectName$1;

            public String toString() {
                return Report$class.toString(this);
            }

            public double getFMax() {
                double d;
                String report = Source$.MODULE$.fromFile(Paths.get(this.workspacePath$1, this.projectName$1, "designer/impl1", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_maxdelay_timing_report.txt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectName$1}))).toFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("-?(\\d+\\.?)+")).r();
                try {
                    String string = this.family$1;
                    if (!"ProASIC3E".equals(string)) {
                        throw new MatchError((Object)string);
                    }
                    String string2 = (String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Frequency[ ]\\(MHz\\)\\:[ ]*(\\d+.\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get();
                    d = new StringOps(Predef$.MODULE$.augmentString(string2)).toDouble();
                }
                catch (Exception exception) {
                    d = -1.0;
                }
                double leFreq = d;
                return leFreq * 1000000.0;
            }

            public String getArea() {
                String string;
                String report = Source$.MODULE$.fromFile(Paths.get(this.workspacePath$1, this.projectName$1, "designer/impl1", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_place_and_route_report.txt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectName$1}))).toFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("(\\d+\\.?)+")).r();
                try {
                    String string2;
                    String string3 = this.family$1;
                    if (!"ProASIC3E".equals(string3)) {
                        throw new MatchError((Object)string3);
                    }
                    string = string2 = new StringBuilder().append((Object)((String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("COMB[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get())).append((Object)" COMB, ").append(intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("SEQ[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get()).append((Object)" SEQ -> ").append(intFind.findAllIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("CORE[ ]*Used:[ ]*\\d+[ ]*Total:[ ]*\\d+[ ]*\\((\\d+.\\d+,?)")).r().findFirstIn((CharSequence)report).get()).toList().apply(2)).append((Object)"% Total CORE ").toString();
                }
                catch (Exception exception) {
                    string = "???";
                }
                String leArea = string;
                return leArea;
            }
            {
                this.workspacePath$1 = workspacePath$1;
                this.family$1 = family$1;
                this.projectName$1 = projectName$1;
                Report$class.$init$(this);
            }
        };
    }

    public HertzNumber apply$default$6() {
        return null;
    }

    public int apply$default$7() {
        return 1;
    }

    public void main(String[] args) {
        SpinalVhdl$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StreamFifo<Bits> apply() {
                StreamFifo qual$1 = (StreamFifo)new StreamFifo<T>(HardType$.MODULE$.implFactory((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Bits apply() {
                        return package$.MODULE$.Bits(package.IntBuilder$.MODULE$.bits$extension(package$.MODULE$.IntToBuilder(8)));
                    }
                }), 128, StreamFifo$.MODULE$.$lessinit$greater$default$3(), StreamFifo$.MODULE$.$lessinit$greater$default$4(), StreamFifo$.MODULE$.$lessinit$greater$default$5(), StreamFifo$.MODULE$.$lessinit$greater$default$6(), StreamFifo$.MODULE$.$lessinit$greater$default$7()).postInitCallback();
                String x$1 = "fifo128";
                boolean x$2 = qual$1.setDefinitionName$default$2();
                return (StreamFifo)qual$1.setDefinitionName(x$1, x$2);
            }
        });
        Report report = this.apply("C:/eda/Microsemi/Libero_v11.0/Designer/bin", "E:/tmp/test1", "fifo128.vhd", "ProASIC3E", "a3pe3000-fg484-2", package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(1)), this.apply$default$7());
        Predef$.MODULE$.println((Object)report.getArea());
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToDouble((double)report.getFMax()));
    }

    private LiberoFlow$() {
        MODULE$ = this;
    }
}

