/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.mps.deepviolet.api.CipherSuite;
import com.mps.deepviolet.api.CipherSuiteUtilServerHello;
import com.mps.deepviolet.api.DVBackgroundTask;
import com.mps.deepviolet.api.HostData;
import com.mps.deepviolet.api.IDVSession;
import com.mps.deepviolet.api.MutableDVSession;
import com.mps.deepviolet.api.ServerHelloSSLv2;
import com.mps.deepviolet.api.ServerMetadata;
import com.mps.deepviolet.api.TrustAllX509TrustManager;
import com.mps.deepviolet.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CipherSuiteUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.mps.deepviolet.suite.CipherSuiteUtil");
    private static final HashMap<String, String> OIDMAP = new HashMap();
    private static final SSLSocketFactory dsc = HttpsURLConnection.getDefaultSSLSocketFactory();
    private static final HostnameVerifier dhv = HttpsURLConnection.getDefaultHostnameVerifier();
    static final int MAX_RECORD_LEN = 16384;
    static final int CHANGE_CIPHER_SPEC = 20;
    static final int ALERT = 21;
    static final int HANDSHAKE = 22;
    static final int APPLICATION = 23;
    private static final SecureRandom RNG = new SecureRandom();
    private static final byte[] SSL2_CLIENT_HELLO = new byte[]{-128, 46, 1, 0, 2, 0, 21, 0, 0, 0, 16, 1, 0, -128, 2, 0, -128, 3, 0, -128, 4, 0, -128, 5, 0, -128, 6, 0, 64, 7, 0, -64, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84};
    private static final byte[] HEARTBEAT = new byte[]{24, 3, 1, 0, 3, 1, 64, 0};
    static final int UNASSIGNED = -1;
    static final int CLEAR = 0;
    static final int WEAK = 1;
    static final int MEDIUM = 2;
    static final int STRONG = 3;
    public static final String NO_CIPHERS = "No Ciphers";
    static Map<Integer, CipherSuite> CIPHER_SUITES = new TreeMap<Integer, CipherSuite>();
    static boolean bCiphersInitialized = false;

    CipherSuiteUtil() {
    }

    static ServerMetadata getServerMetadataInstance(URL url, IDVSession.CIPHER_NAME_CONVENTION cipher_name_convention, MutableDVSession session, DVBackgroundTask dvtask) throws Exception {
        Iterator iterator;
        HostData hostdata = new HostData(url);
        Boolean compress = false;
        dvtask.setStatusBarMessage("Initializing DV ciphersuite maps.");
        if (!bCiphersInitialized) {
            CipherSuiteUtil.initCipherMap();
        }
        dvtask.setStatusBarMessage("Reviewing server protocols.");
        String name = url.getHost();
        int port = url.getPort() > 0 ? url.getPort() : 443;
        InetSocketAddress isa = new InetSocketAddress(name, port);
        TreeSet<Integer> sv = new TreeSet<Integer>();
        for (int v = 768; v <= 771; ++v) {
            CipherSuiteUtilServerHello sh = CipherSuiteUtil.connect(isa, v, CIPHER_SUITES.keySet());
            if (sh == null) continue;
            sv.add(sh.protoVersion);
            dvtask.setStatusBarMessage("Analysing TLS version " + sh.protoVersion);
            if (sh.compression == 1) {
                compress = true;
                session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.DEFLATE_COMPRESSION, "true");
                logger.warn("Server vulnerable to CRIME attack.  Compression enabled.");
                continue;
            }
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.DEFLATE_COMPRESSION, "false");
        }
        dvtask.setStatusBarMessage("Sending TLS server Hello SSLv2");
        ServerHelloSSLv2 sh2 = CipherSuiteUtil.connectV2(isa);
        if (sh2 != null) {
            sv.add(512);
        }
        if (sv.size() == 0) {
            dvtask.setStatusBarMessage("Server may not be SSL/TLS enabled. host=" + isa);
            logger.error("Server may not be SSL/TLS enabled. host=" + isa);
            return null;
        }
        dvtask.setStatusBarMessage("Normalizing ciphersuite names to " + (Object)((Object)cipher_name_convention) + " specification");
        Object lastSuppCS = null;
        TreeMap<Integer, Set<Object>> suppCS = new TreeMap<Integer, Set<Object>>();
        TreeSet<String> certID = new TreeSet<String>();
        boolean vulnFREAK = false;
        if (sh2 != null) {
            ArrayList<String> listv2 = new ArrayList<String>();
            String[] tmp = new String[]{};
            TreeSet<Integer> vc2 = new TreeSet<Integer>();
            for (Object c : (Iterator)sh2.cipherSuites) {
                vc2.add((int)c);
            }
            iterator = vc2.iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                String suitename = CipherSuiteUtil.cipherSuiteStringV2(c, cipher_name_convention);
                if (!vulnFREAK) {
                    if (suitename == null || suitename.length() == 0) {
                        logger.info("Freak vulnerability analysis skipped due to null ciphersuite name. id=0x" + c);
                    } else {
                        boolean bl = vulnFREAK = CipherSuiteUtil.cipherSuiteStringV2(c, cipher_name_convention).indexOf("RSA_EXPORT") > -1;
                        if (vulnFREAK) {
                            logger.warn("Following ciphersuite vulnerable to FREAK attack, " + suitename);
                        }
                    }
                }
                listv2.add(suitename + "(0x" + Integer.toHexString(c) + ")");
            }
            suppCS.put(512, vc2);
            if (sh2.serverCertName != null) {
                hostdata.setScalarValue("getServerMetadataInstance", sh2.serverCertHash, sh2.serverCertName);
            }
            hostdata.setVectorValue("getServerMetadataInstance", CipherSuiteUtil.versionString(512), listv2.toArray(tmp));
        }
        dvtask.setStatusBarMessage("Starting ciphersuite analysis.");
        int agMaxStrength = 3;
        int agMinStrength = 3;
        boolean vulnBEAST = false;
        iterator = sv.iterator();
        while (iterator.hasNext()) {
            int v = (Integer)iterator.next();
            if (v == 512) continue;
            Set<Integer> vsc = CipherSuiteUtil.supportedSuites(isa, v, certID);
            suppCS.put(v, vsc);
            ArrayList<String> listv = new ArrayList<String>();
            String[] tmp = new String[]{};
            for (int c : vsc) {
                String suitename = CipherSuiteUtil.cipherSuiteString(c, cipher_name_convention);
                if (suitename == null || suitename.length() == 0) {
                    logger.info("Freak vulnerability analysis skipped due to null ciphersuite name. id=0x" + c);
                } else if (!vulnFREAK) {
                    boolean bl = vulnFREAK = CipherSuiteUtil.cipherSuiteString(c, cipher_name_convention).indexOf("RSA_EXPORT") > -1;
                    if (vulnFREAK) {
                        logger.warn("Following ciphersuite vulnerable to FREAK attack, " + suitename);
                    }
                }
                agMaxStrength = Math.min(CipherSuiteUtil.maxStrength(vsc), agMaxStrength);
                agMinStrength = Math.min(CipherSuiteUtil.minStrength(vsc), agMinStrength);
                if (!vulnBEAST && (vulnBEAST = CipherSuiteUtil.testBEAST(isa, c, vsc))) {
                    logger.warn("Following ciphersuite vulnerable to BEAST attack, " + suitename);
                }
                listv.add(suitename + "(0x" + Integer.toHexString(c) + ")");
            }
            hostdata.setVectorValue("getServerMetadataInstance", CipherSuiteUtil.versionString(v), listv.toArray(tmp));
        }
        session.setVulnerabilityAssessmentValue(IDVSession.VULNERABILITY_ASSESSMENTS.MINIMAL_ENCRYPTION_STRENGTH, CipherSuiteUtil.strengthString(agMinStrength));
        session.setVulnerabilityAssessmentValue(IDVSession.VULNERABILITY_ASSESSMENTS.ACHIEVABLE_ENCRYPTION_STRENGTH, CipherSuiteUtil.strengthString(agMaxStrength));
        session.setVulnerabilityAssessmentValue(IDVSession.VULNERABILITY_ASSESSMENTS.BEAST_VULNERABLE, Boolean.toString(vulnBEAST));
        session.setVulnerabilityAssessmentValue(IDVSession.VULNERABILITY_ASSESSMENTS.CRIME_VULNERABLE, Boolean.toString(compress));
        session.setVulnerabilityAssessmentValue(IDVSession.VULNERABILITY_ASSESSMENTS.FREAK_VULNERABLE, Boolean.toString(vulnFREAK));
        dvtask.setStatusBarMessage("Ciphersuite analysis complete.");
        return hostdata;
    }

    private static void initCipherMap() {
        String ciphermap = FileUtils.getJsonResourceAsString("ciphermap.json");
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(ciphermap);
        List ciphermetalist = (List)JsonPath.read((Object)document, (String)"$[?(@.*)]", (Predicate[])new Predicate[0]);
        HashMap<String, Integer> strengtheval = new HashMap<String, Integer>();
        String cipherevaluation = FileUtils.getJsonResourceAsString("server-side-tls-conf-4.0.json");
        Object d2 = Configuration.defaultConfiguration().jsonProvider().parse(cipherevaluation);
        List mc1 = (List)JsonPath.read((Object)d2, (String)"$.configurations.modern.ciphersuites.*", (Predicate[])new Predicate[0]);
        for (String ciph : mc1) {
            strengtheval.put(ciph, new Integer(3));
        }
        Object d3 = Configuration.defaultConfiguration().jsonProvider().parse(cipherevaluation);
        List mc2 = (List)JsonPath.read((Object)d3, (String)"$.configurations.intermediate.ciphersuites.*", (Predicate[])new Predicate[0]);
        for (String ciph : mc2) {
            if (strengtheval.containsKey(ciph)) continue;
            strengtheval.put(ciph, new Integer(2));
        }
        Object d4 = Configuration.defaultConfiguration().jsonProvider().parse(cipherevaluation);
        List mc3 = (List)JsonPath.read((Object)d4, (String)"$.configurations.old.ciphersuites.*", (Predicate[])new Predicate[0]);
        for (String ciph : mc3) {
            if (strengtheval.containsKey(ciph)) continue;
            strengtheval.put(ciph, new Integer(1));
        }
        for (Map ci : ciphermetalist) {
            for (Object obj : ci.keySet()) {
                Map ch1 = (Map)ci.get(obj.toString());
                List<String> ciphercode = Arrays.asList(obj.toString().split(","));
                String ho = ciphercode.get(0);
                List<String> lo = Arrays.asList(ciphercode.get(1).split("x"));
                String sho = ho;
                String slo = lo.get(1).replaceFirst("^0+(?!$)", "");
                sho = sho.equals("0") ? "" : sho;
                Integer cc1 = Integer.decode(sho + slo);
                Iterator cns = ch1.values().iterator();
                int istrengtheval = -1;
                while (cns.hasNext()) {
                    String key = (String)cns.next();
                    if (!strengtheval.containsKey(key)) continue;
                    istrengtheval = (Integer)strengtheval.get(key);
                    break;
                }
                logger.debug("Cached Mozilla ciphers, " + obj.toString() + " " + ch1.toString() + " strengtheval=" + istrengtheval);
                CipherSuiteUtil.makeCS(cc1, ch1, istrengtheval);
            }
        }
    }

    static String versionString(int version) {
        if (version == 512) {
            return "SSLv2";
        }
        if (version == 768) {
            return "SSLv3";
        }
        if (version >>> 8 == 3) {
            return "TLSv1." + ((version & 0xFF) - 1);
        }
        return String.format("UNKNOWN_VERSION:0x%04X", version);
    }

    static Set<Integer> supportedSuites(InetSocketAddress isa, int version, Set<String> serverCertID) {
        TreeSet<Integer> rs = new TreeSet<Integer>();
        int BLK_SIZE = 6000;
        int CIPHERMAPSZ = 65535;
        int i2 = 0;
        int i3 = 1;
        TreeSet<Integer> scanblk = null;
        block0: for (int i = 1; i < CIPHERMAPSZ; i += BLK_SIZE) {
            CipherSuiteUtilServerHello sh;
            scanblk = new TreeSet<Integer>();
            while (i2 < BLK_SIZE * i3) {
                scanblk.add(i2);
                ++i2;
            }
            ++i3;
            while ((sh = CipherSuiteUtil.connect(isa, version, scanblk)) != null) {
                if (!scanblk.contains(sh.cipherSuite)) {
                    String ciphersuite = Integer.toHexString(sh.cipherSuite);
                    logger.warn("Server wants to use cipher suite " + ciphersuite + " which client did not announce.");
                    continue block0;
                }
                scanblk.remove(sh.cipherSuite);
                rs.add(sh.cipherSuite);
                if (sh.serverCertName == null) continue;
                serverCertID.add(sh.serverCertHash + ": " + sh.serverCertName);
            }
        }
        return rs;
    }

    static int minStrength(Set<Integer> supp) {
        int m = 3;
        for (int suite : supp) {
            CipherSuite cs = CIPHER_SUITES.get(suite);
            if (cs == null || cs.strength >= m) continue;
            m = cs.strength;
        }
        return m;
    }

    static int maxStrength(Set<Integer> supp) {
        int m = 0;
        for (int suite : supp) {
            CipherSuite cs = CIPHER_SUITES.get(suite);
            if (cs == null || cs.strength <= m) continue;
            m = cs.strength;
        }
        return m;
    }

    static final String getStrength(String protocol) {
        String unknown;
        String clear = "CLEAR{no encryption}";
        String weak = "WEAK";
        String medium = "MEDIUM";
        String strong = "STRONG";
        String result = unknown = "UNKNOWN";
        if (protocol.contains("_NULL_")) {
            result = clear;
        } else {
            Collection<CipherSuite> suites = CIPHER_SUITES.values();
            CipherSuite c2 = null;
            for (CipherSuite c2 : suites) {
                if (!c2.names.containsValue(protocol)) continue;
                switch (c2.strength) {
                    case 3: {
                        result = strong;
                        break;
                    }
                    case 2: {
                        result = medium;
                        break;
                    }
                    case 1: {
                        result = weak;
                    }
                }
            }
        }
        return result;
    }

    static final X509Certificate getServerCertificate(URL url) throws Exception {
        X509Certificate[] certs = CipherSuiteUtil.getServerCertificateChain(url);
        return certs[0];
    }

    static final Map<String, List<String>> getHttpResponseHeaders(URL url) throws Exception {
        HttpsURLConnection conn = null;
        HashMap<String, List<String>> result = new HashMap();
        try {
            CipherSuiteUtil.enableTLSChainTesting(false);
            conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            result = conn.getHeaderFields();
        }
        finally {
            CipherSuiteUtil.enableTLSChainTesting(true);
        }
        return result;
    }

    static final void enableTLSChainTesting(boolean value) throws Exception {
        if (value) {
            HttpsURLConnection.setDefaultSSLSocketFactory(dsc);
            HttpsURLConnection.setDefaultHostnameVerifier(dhv);
        } else {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllX509TrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession ssls) {
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final X509Certificate[] getServerCertificateChain(URL url) throws Exception {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        try {
            Certificate[] certs;
            CipherSuiteUtil.enableTLSChainTesting(false);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            for (Certificate cert : certs = conn.getServerCertificates()) {
                if (cert instanceof X509Certificate) {
                    list.add((X509Certificate)cert);
                    continue;
                }
                logger.info("Unsupported certificate type.  type=" + cert.getClass().getName());
            }
        }
        finally {
            CipherSuiteUtil.enableTLSChainTesting(true);
        }
        return list.toArray(new X509Certificate[0]);
    }

    static final X509Certificate[] getJavaRootCertificates() throws Exception {
        String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        logger.debug("CACERTS file, " + filename);
        FileInputStream is = new FileInputStream(filename);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        String password = "changeit";
        keystore.load(is, password.toCharArray());
        PKIXParameters params = new PKIXParameters(keystore);
        Iterator<TrustAnchor> it = params.getTrustAnchors().iterator();
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        while (it.hasNext()) {
            TrustAnchor ta = it.next();
            result.add(ta.getTrustedCert());
        }
        return result.toArray(new X509Certificate[0]);
    }

    static final boolean isJavaRootCertificateDN(String IssuerDN) throws Exception {
        boolean result = false;
        for (X509Certificate cert : CipherSuiteUtil.getJavaRootCertificates()) {
            if (!cert.getIssuerDN().getName().equals(IssuerDN)) continue;
            result = true;
            break;
        }
        return result;
    }

    static final boolean checkTrustedCertificate(X509Certificate[] certs, URL url) throws KeyStoreException, NoSuchAlgorithmException, UnknownHostException, IOException {
        boolean valid = false;
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket socket = (SSLSocket)factory.createSocket(url.getHost(), url.getDefaultPort());
        SSLSession session = socket.getSession();
        String keyexchalgo = CipherSuiteUtil.getKeyExchangeAlgorithm(session);
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            try {
                x509TrustManager.checkServerTrusted(certs, keyexchalgo);
                valid = true;
            }
            catch (CertificateException e) {
                logger.error("url=" + url.toString());
            }
        }
        return valid;
    }

    private static final String getKeyExchangeAlgorithm(SSLSession session) {
        String cipher = session.getCipherSuite().toString();
        int i1 = cipher.indexOf(95) + 1;
        int i2 = cipher.indexOf("_WITH");
        String keyexch = cipher.substring(i1, i2);
        return keyexch;
    }

    static final boolean isSelfSignedCertificate(X509Certificate cert) {
        boolean result = false;
        if (cert != null && cert.getIssuerDN().equals(cert.getSubjectDN())) {
            result = true;
        }
        return result;
    }

    public static final String signerFingerprint(byte[] der, String signatureAlgorithm) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance(signatureAlgorithm);
        sha1.update(der);
        StringBuffer buff = new StringBuffer();
        buff.append(CipherSuiteUtil.byteArrayToHex(sha1.digest()));
        return buff.toString();
    }

    static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString().toUpperCase();
    }

    static String getOIDKeyName(String oidkey) {
        return OIDMAP.get(oidkey) != null ? OIDMAP.get(oidkey) : oidkey;
    }

    static final ASN1Primitive toDERObject(byte[] data) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ASN1InputStream asnInputStream = new ASN1InputStream((InputStream)inStream);
        ASN1Primitive p = asnInputStream.readObject();
        asnInputStream.close();
        return p;
    }

    static final void walkASN1Sequence(ASN1Primitive primitive, StringBuffer buff) throws IOException {
        if (primitive instanceof DEROctetString) {
            byte[] bytes = ((DEROctetString)primitive).getOctets();
            ASN1Primitive p = null;
            try {
                p = CipherSuiteUtil.toDERObject(bytes);
                CipherSuiteUtil.walkASN1Sequence(p, buff);
            }
            catch (IOException e) {
                buff.append(CipherSuiteUtil.byteArrayToHex(bytes));
            }
        } else if (primitive instanceof DLSequence) {
            DLSequence dl = (DLSequence)primitive;
            for (int i = 0; i < dl.size(); ++i) {
                ASN1Primitive p = dl.getObjectAt(i).toASN1Primitive();
                CipherSuiteUtil.walkASN1Sequence(p, buff);
            }
        } else if (primitive instanceof DERSequence) {
            DERSequence ds = (DERSequence)primitive;
            for (int i = 0; i < ds.size(); ++i) {
                ASN1Primitive p = ds.getObjectAt(i).toASN1Primitive();
                CipherSuiteUtil.walkASN1Sequence(p, buff);
            }
        } else if (primitive instanceof DERApplicationSpecific) {
            DERApplicationSpecific app = (DERApplicationSpecific)primitive;
            int tag = app.getApplicationTag();
            StringBuffer buff2 = new StringBuffer();
            buff2.append("tag=" + tag + " ");
            String hex = CipherSuiteUtil.byteArrayToHex(app.getContents());
            buff2.append(hex);
            buff.append(buff2.toString());
        } else if (primitive instanceof ASN1ObjectIdentifier) {
            ASN1ObjectIdentifier i = (ASN1ObjectIdentifier)primitive;
            String kn = CipherSuiteUtil.getOIDKeyName(i.toString());
            if (kn.equals("2.5.29.37.0")) {
                buff.append("anyextendedkeyusage ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.1")) {
                buff.append("serverauth ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.2")) {
                buff.append("clientauth ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.3")) {
                buff.append("codesigning ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.4")) {
                buff.append("emailprotection ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.8")) {
                buff.append("timestamping ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.9")) {
                buff.append("ocspsigner ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.15")) {
                buff.append("scvpserver ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.16")) {
                buff.append("scvpclient ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.22")) {
                buff.append("eku_pkix_sshserver ");
            } else if (kn.equals("1.3.6.1.5.5.7.3.21")) {
                buff.append("eku_pkix_sshclient ");
            } else {
                buff.append(CipherSuiteUtil.getOIDKeyName(i.toString()));
                buff.append("=");
            }
        } else if (primitive instanceof DERVisibleString) {
            DERVisibleString vstring = (DERVisibleString)primitive;
            buff.append(vstring.getString());
        } else if (primitive instanceof DERIA5String) {
            DERIA5String ia5string = (DERIA5String)primitive;
            buff.append(ia5string.getString());
        } else if (primitive instanceof DERUTF8String) {
            DERUTF8String utf8string = (DERUTF8String)primitive;
            buff.append(utf8string.toString());
        } else if (primitive instanceof DERBitString) {
            DERBitString bitstring = (DERBitString)primitive;
            int v = bitstring.intValue();
            if ((v & 1) == 1) {
                buff.append("digitial_signature ");
            }
            if ((v & 2) == 2) {
                buff.append("nonrepudiation ");
            }
            if ((v & 4) == 4) {
                buff.append("keyencipherment ");
            }
            if ((v & 8) == 8) {
                buff.append("dataencipherment ");
            }
            if ((v & 0x16) == 16) {
                buff.append("keyagreement ");
            }
            if ((v & 0x32) == 32) {
                buff.append("keycertsign ");
            }
            if ((v & 0x64) == 64) {
                buff.append("crlsign ");
            }
            if ((v & 0x128) == 128) {
                buff.append("encipheronly ");
            }
            if ((v & 0x256) == 256) {
                buff.append("decipherOnly ");
            }
        } else if (primitive instanceof ASN1Boolean) {
            ASN1Boolean ans1boolean = (ASN1Boolean)primitive;
            buff.append(ans1boolean.isTrue() ? "TRUE" : "FALSE");
        } else if (primitive instanceof ASN1Integer) {
            ASN1Integer ans1int = (ASN1Integer)primitive;
            buff.append(ans1int.toString());
        } else if (primitive instanceof DERSet) {
            DERSet derset = (DERSet)primitive;
            buff.append(derset.toString());
        } else if (primitive instanceof DERTaggedObject) {
            DERTaggedObject t = (DERTaggedObject)primitive;
            byte[] b = t.getEncoded();
            byte length = b[1];
            if (t.getTagNo() == 6) {
                buff.append(new String(b, 2, (int)length));
                buff.append(" | ");
            } else if (t.getTagNo() == 2) {
                buff.append(new String(b, 2, (int)length));
                buff.append(" | ");
            } else if (t.getTagNo() == 1) {
                ASN1Primitive p = t.getObject();
                CipherSuiteUtil.walkASN1Sequence(p, buff);
            } else if (t.getTagNo() == 0) {
                ASN1Primitive p = t.getObject();
                CipherSuiteUtil.walkASN1Sequence(p, buff);
            } else if (t.getTagNo() == 4) {
                ASN1Primitive p = t.getObject();
                CipherSuiteUtil.walkASN1Sequence(p, buff);
            } else {
                StringBuffer buff2 = new StringBuffer();
                buff2.append("type=" + t.getTagNo() + " ");
                String hex = CipherSuiteUtil.byteArrayToHex(b);
                buff2.append(hex);
                buff2.append(" | ");
                buff.append(buff2.toString());
                logger.info("Unhandled DERTaggedObject type. RAW=" + buff2.toString());
            }
        } else {
            buff.append("Unhandled type, see log");
            buff.append(" | ");
            logger.error("Unhandled primitive data type, type=" + primitive.getClass().getName());
        }
    }

    static final String getExtensionValue(X509Certificate X509Certificate2, String oid) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append('[');
        byte[] extensionValue = X509Certificate2.getExtensionValue(oid);
        if (extensionValue == null) {
            return null;
        }
        CipherSuiteUtil.walkASN1Sequence(CipherSuiteUtil.toDERObject(extensionValue), buff);
        if (buff.toString().endsWith(" | ")) {
            buff.setLength(buff.length() - 3);
        } else if (buff.toString().endsWith("| ")) {
            buff.setLength(buff.length() - 2);
        } else if (buff.toString().endsWith(" ")) {
            buff.setLength(buff.length() - 1);
        }
        buff.append(']');
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CipherSuiteUtilServerHello connect(InetSocketAddress isa, int version, Collection<Integer> cipherSuites) {
        Socket s = null;
        try {
            s = new Socket();
            try {
                s.connect(isa);
            }
            catch (IOException ioe) {
                logger.error("could not connect to " + isa + ": " + ioe.toString());
                CipherSuiteUtilServerHello cipherSuiteUtilServerHello = null;
                try {
                    s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return cipherSuiteUtilServerHello;
            }
            byte[] ch = CipherSuiteUtil.makeClientHello(version, cipherSuites);
            OutputRecord orec = new OutputRecord(s.getOutputStream());
            orec.setType(22);
            orec.setVersion(version);
            orec.write(ch);
            orec.flush();
            CipherSuiteUtilServerHello cipherSuiteUtilServerHello = new CipherSuiteUtilServerHello(s.getInputStream());
            return cipherSuiteUtilServerHello;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerHelloSSLv2 connectV2(InetSocketAddress isa) {
        Socket s = null;
        try {
            s = new Socket();
            try {
                s.connect(isa);
            }
            catch (IOException ioe) {
                logger.error("could not connect to " + isa + ": " + ioe.toString());
                ServerHelloSSLv2 serverHelloSSLv2 = null;
                try {
                    s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return serverHelloSSLv2;
            }
            s.getOutputStream().write(SSL2_CLIENT_HELLO);
            ServerHelloSSLv2 serverHelloSSLv2 = new ServerHelloSSLv2(s.getInputStream());
            return serverHelloSSLv2;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    static void readFully(InputStream in, byte[] buf) throws IOException {
        CipherSuiteUtil.readFully(in, buf, 0, buf.length);
    }

    static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            int rlen = in.read(buf, off, len);
            if (rlen < 0) {
                throw new EOFException();
            }
            off += rlen;
            len -= rlen;
        }
    }

    static final void enc16be(int val, byte[] buf, int off) {
        buf[off] = (byte)(val >>> 8);
        buf[off + 1] = (byte)val;
    }

    static final void enc24be(int val, byte[] buf, int off) {
        buf[off] = (byte)(val >>> 16);
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)val;
    }

    static final void enc32be(int val, byte[] buf, int off) {
        buf[off] = (byte)(val >>> 24);
        buf[off + 1] = (byte)(val >>> 16);
        buf[off + 2] = (byte)(val >>> 8);
        buf[off + 3] = (byte)val;
    }

    static final int dec16be(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF;
    }

    static final int dec24be(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 16 | (buf[off + 1] & 0xFF) << 8 | buf[off + 2] & 0xFF;
    }

    static final int dec32be(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    static String doSHA1(byte[] buf) {
        return CipherSuiteUtil.doSHA1(buf, 0, buf.length);
    }

    static String doSHA1(byte[] buf, int off, int len) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(buf, off, len);
            byte[] hv = md.digest();
            Formatter f = new Formatter();
            for (byte b : hv) {
                f.format("%02x", b & 0xFF);
            }
            return f.toString();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new Error(nsae);
        }
    }

    static byte[] makeClientHello(int version, Collection<Integer> cipherSuites) {
        try {
            return CipherSuiteUtil.makeClientHello0(version, cipherSuites);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static byte[] makeClientHello0(int version, Collection<Integer> cipherSuites) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        b.write(1);
        b.write(0);
        b.write(0);
        b.write(0);
        b.write(version >>> 8);
        b.write(version);
        byte[] rand = new byte[32];
        RNG.nextBytes(rand);
        CipherSuiteUtil.enc32be((int)(System.currentTimeMillis() / 1000L), rand, 0);
        b.write(rand);
        b.write(0);
        int num = cipherSuites.size();
        byte[] cs = new byte[2 + num * 2];
        CipherSuiteUtil.enc16be(num * 2, cs, 0);
        int j = 2;
        for (int s : cipherSuites) {
            CipherSuiteUtil.enc16be(s, cs, j);
            j += 2;
        }
        b.write(cs);
        b.write(2);
        b.write(1);
        b.write(0);
        byte[] msg = b.toByteArray();
        CipherSuiteUtil.enc24be(msg.length - 4, msg, 1);
        return msg;
    }

    static final String strengthString(int strength) {
        switch (strength) {
            case -1: {
                return "unassigned evaluation";
            }
            case 0: {
                return "no encryption";
            }
            case 1: {
                return "weak encryption (40-bit)";
            }
            case 2: {
                return "medium encryption (56-bit)";
            }
            case 3: {
                return "strong encryption (96-bit or more)";
            }
        }
        throw new Error("Unknown strength evalution: " + strength);
    }

    static final String cipherSuiteString(int suite, IDVSession.CIPHER_NAME_CONVENTION cipher_name_convention) {
        CipherSuite cs = CIPHER_SUITES.get(suite);
        String ciphername = String.format("UNKNOWN_SUITE:%04X", suite);
        if (cs != null) {
            ciphername = (String)cs.names.get(cipher_name_convention.toString());
        }
        return ciphername;
    }

    static final String cipherSuiteStringV2(int suite, IDVSession.CIPHER_NAME_CONVENTION cipher_name_convention) {
        CipherSuite cs = CIPHER_SUITES.get(suite);
        String ciphername = String.format("UNKNOWN_SUITE:%02X,%02X,%02X", suite >> 16, suite >> 8 & 0xFF, suite & 0xFF);
        if (cs != null) {
            ciphername = (String)cs.names.get(cipher_name_convention.toString());
        }
        return ciphername;
    }

    private static final void makeCS(int suite, Map names, int strength) {
        CipherSuite cs = new CipherSuite();
        cs.suite = suite;
        cs.names = names;
        cs.strength = strength;
        CIPHER_SUITES.put(suite, cs);
    }

    static boolean testBEAST(InetSocketAddress isa, int version, Set<Integer> supp) {
        if (version < 768 || version > 769) {
            return false;
        }
        ArrayList strongCBC = new ArrayList();
        ArrayList strongStream = new ArrayList();
        for (int suite : supp) {
            CipherSuite cs = CIPHER_SUITES.get(suite);
            if (cs != null && cs.strength >= 3) continue;
        }
        if (strongCBC.size() == 0) {
            return false;
        }
        if (strongStream.size() == 0) {
            return true;
        }
        ArrayList<Integer> ns = new ArrayList<Integer>(strongCBC);
        ns.addAll(strongStream);
        CipherSuiteUtilServerHello sh = CipherSuiteUtil.connect(isa, version, ns);
        return !strongStream.contains(sh.cipherSuite);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        OIDMAP.put("2.5.29.14", "SubjectKeyIdentifier");
        OIDMAP.put("2.5.29.15", "KeyUsage");
        OIDMAP.put("2.5.29.16", "PrivateKeyUsage");
        OIDMAP.put("2.5.29.17", "SubjectAlternativeName");
        OIDMAP.put("2.5.29.18", "IssuerAlternativeName");
        OIDMAP.put("2.5.29.19", "BasicConstraints");
        OIDMAP.put("2.5.29.30", "NameConstraints");
        OIDMAP.put("2.5.29.33", "PolicyMappings");
        OIDMAP.put("2.5.29.35", "AuthorityKeyIdentifier");
        OIDMAP.put("2.5.29.36", "PolicyConstraints");
        OIDMAP.put("1.3.6.1.5.5.7.48.1", "ocsp");
        OIDMAP.put("1.3.6.1.5.5.7.48.2", "caIssuers");
        OIDMAP.put("1.2.840.113549.1.1.1", "SubjectPublicKeyInfo");
        OIDMAP.put("1.3.6.1.5.5.7.48.1.1", "BasicOCSPResponse");
        OIDMAP.put("1.2.840.113549.1.1.5", "SignatureAlgorithm");
        OIDMAP.put("1.3.6.1.5.5.7.1.1", "AuthorityInfoAccess");
        OIDMAP.put("1.3.6.1.4.1.11129.2.4.2", "SignedCertificateTimestampList");
        OIDMAP.put("1.3.6.1.5.5.7.2.2", "CPSUserNotice");
        OIDMAP.put("2.5.29.31", "CRLDistributionPoints");
        OIDMAP.put("2.5.29.32", "CertificatePolicies");
        OIDMAP.put("1.3.6.1.4.1.6449.1.2.1.5.1", "CertificatePolicyId");
        OIDMAP.put("2.5.29.32", "CertificatePolicies");
        OIDMAP.put("1.3.6.1.5.5.7.2.1", "qualifierID");
        OIDMAP.put("2.5.29.37", "ExtendedKeyUsages");
        OIDMAP.put("2.5.29.15", "KeyUsage");
        OIDMAP.put("2.5.29.14", "SubjectKeyIdentifier");
    }

    static class OutputRecord
    extends OutputStream {
        private OutputStream out;
        private byte[] buffer = new byte[16389];
        private int ptr;
        private int version;
        private int type;

        OutputRecord(OutputStream out) {
            this.out = out;
            this.ptr = 5;
        }

        void setType(int type) {
            this.type = type;
        }

        void setVersion(int version) {
            this.version = version;
        }

        @Override
        public void flush() throws IOException {
            this.buffer[0] = (byte)this.type;
            CipherSuiteUtil.enc16be(this.version, this.buffer, 1);
            CipherSuiteUtil.enc16be(this.ptr - 5, this.buffer, 3);
            this.out.write(this.buffer, 0, this.ptr);
            this.out.flush();
            this.ptr = 5;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer[this.ptr++] = (byte)b;
            if (this.ptr == this.buffer.length) {
                this.flush();
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            while (len > 0) {
                int clen = Math.min(this.buffer.length - this.ptr, len);
                System.arraycopy(buf, off, this.buffer, this.ptr, clen);
                this.ptr += clen;
                off += clen;
                len -= clen;
                if (this.ptr != this.buffer.length) continue;
                this.flush();
            }
        }
    }
}

