/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.CipherSuiteUtil;
import java.io.IOException;
import java.io.InputStream;

class CipherSuiteUtilInputRecord
extends InputStream {
    private InputStream in;
    private byte[] buffer = new byte[16389];
    private int ptr;
    private int end;
    private int version;
    private int type;
    private int expectedType;

    CipherSuiteUtilInputRecord(InputStream in) {
        this.in = in;
        this.ptr = 0;
        this.end = 0;
    }

    void setExpectedType(int expectedType) {
        this.expectedType = expectedType;
    }

    int getVersion() {
        return this.version;
    }

    private void refill() throws IOException {
        block1: {
            do {
                CipherSuiteUtil.readFully(this.in, this.buffer, 0, 5);
                this.type = this.buffer[0] & 0xFF;
                this.version = CipherSuiteUtil.dec16be(this.buffer, 1);
                this.end = CipherSuiteUtil.dec16be(this.buffer, 3);
                CipherSuiteUtil.readFully(this.in, this.buffer, 0, this.end);
                this.ptr = 0;
                if (this.type == this.expectedType) break block1;
            } while (this.type == 21);
            throw new IOException("unexpected record type: " + this.type);
        }
    }

    @Override
    public int read() throws IOException {
        while (this.ptr == this.end) {
            this.refill();
        }
        return this.buffer[this.ptr++] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        while (this.ptr == this.end) {
            this.refill();
        }
        int clen = Math.min(this.end - this.ptr, len);
        System.arraycopy(this.buffer, this.ptr, buf, off, clen);
        this.ptr += clen;
        return clen;
    }
}

