/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.CipherSuiteUtil;
import com.mps.deepviolet.api.CipherSuiteUtilInputRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CipherSuiteUtilServerHello {
    int recordVersion;
    int protoVersion;
    long serverTime;
    int cipherSuite;
    int compression;
    String serverCertName;
    String serverCertHash;

    CipherSuiteUtilServerHello(InputStream in) throws IOException {
        CipherSuiteUtilInputRecord rec = new CipherSuiteUtilInputRecord(in);
        rec.setExpectedType(22);
        byte[] buf = new byte[4];
        CipherSuiteUtil.readFully(rec, buf);
        this.recordVersion = rec.getVersion();
        if (buf[0] != 2) {
            throw new IOException("unexpected handshake message type: " + (buf[0] & 0xFF));
        }
        buf = new byte[CipherSuiteUtil.dec24be(buf, 1)];
        CipherSuiteUtil.readFully(rec, buf);
        int ptr = 0;
        if (ptr + 2 > buf.length) {
            throw new IOException("invalid ServerHello");
        }
        this.protoVersion = CipherSuiteUtil.dec16be(buf, 0);
        if ((ptr += 2) + 32 > buf.length) {
            throw new IOException("invalid ServerHello");
        }
        this.serverTime = 1000L * ((long)CipherSuiteUtil.dec32be(buf, ptr) & 0xFFFFFFFFL);
        if ((ptr += 32) + 1 > buf.length) {
            throw new IOException("invalid ServerHello");
        }
        if ((ptr += 1 + (buf[ptr] & 0xFF)) + 3 > buf.length) {
            throw new IOException("invalid ServerHello");
        }
        this.cipherSuite = CipherSuiteUtil.dec16be(buf, ptr);
        this.compression = buf[ptr + 2] & 0xFF;
        while (true) {
            buf = new byte[4];
            CipherSuiteUtil.readFully(rec, buf);
            int mt = buf[0] & 0xFF;
            buf = new byte[CipherSuiteUtil.dec24be(buf, 1)];
            CipherSuiteUtil.readFully(rec, buf);
            switch (mt) {
                case 11: {
                    this.processCertificate(buf);
                    return;
                }
                case 14: {
                    return;
                }
            }
        }
    }

    private void processCertificate(byte[] buf) {
        if (buf.length <= 6) {
            return;
        }
        int len1 = CipherSuiteUtil.dec24be(buf, 0);
        if (len1 != buf.length - 3) {
            return;
        }
        int len2 = CipherSuiteUtil.dec24be(buf, 3);
        if (len2 > buf.length - 6) {
            return;
        }
        byte[] ec = new byte[len2];
        System.arraycopy(buf, 6, ec, 0, len2);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate xc = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(ec));
            this.serverCertName = xc.getSubjectX500Principal().toString();
            this.serverCertHash = CipherSuiteUtil.doSHA1(ec);
        }
        catch (CertificateException e) {
            return;
        }
    }
}

