/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.CipherSuiteUtil;
import com.mps.deepviolet.api.DVBackgroundTask;
import com.mps.deepviolet.api.DVException;
import com.mps.deepviolet.api.DVX509Certificate;
import com.mps.deepviolet.api.IDVCipherSuite;
import com.mps.deepviolet.api.IDVEng;
import com.mps.deepviolet.api.IDVSession;
import com.mps.deepviolet.api.IDVX509Certificate;
import com.mps.deepviolet.api.MutableDVCipherSuite;
import com.mps.deepviolet.api.MutableDVSession;
import com.mps.deepviolet.api.ServerMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DVEng
implements IDVEng {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.mps.deepviolet.api.DVEng");
    private HashMap<String, String> map;
    int iVersionMajor;
    int iVersionMinor;
    int iVersionBuild;
    boolean bSnapShot;
    private final String EOL;
    private final URL url;
    private MutableDVSession session;
    private ServerMetadata servmeta;

    DVEng(IDVSession session, IDVSession.CIPHER_NAME_CONVENTION cipher_name_convention) throws DVException {
        this(session, cipher_name_convention, null);
    }

    DVEng(IDVSession session, IDVSession.CIPHER_NAME_CONVENTION cipher_name_convention, DVBackgroundTask dvtask) throws DVException {
        block8: {
            this.map = new HashMap();
            this.iVersionMajor = -1;
            this.iVersionMinor = -1;
            this.iVersionBuild = -1;
            this.bSnapShot = false;
            this.EOL = System.getProperty("line.separator");
            try {
                this.session = (MutableDVSession)session;
                this.url = session.getURL();
                dvtask = dvtask == null ? new DVBackgroundTask() : dvtask;
                this.servmeta = CipherSuiteUtil.getServerMetadataInstance(this.url, cipher_name_convention, this.session, dvtask);
                if (this.servmeta == null) {
                    String msg = "Unable to create DVEng.  ServerMetadata is null";
                    logger.error(msg);
                    throw new DVException(msg);
                }
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("dvmaven.properties");
                Properties p = new Properties();
                p.load(is);
                String sVersion = p.getProperty("dvversion");
                logger.debug("DV Maven version string, dvversion=" + sVersion);
                if (sVersion == null || sVersion.length() <= 0) break block8;
                int f1 = sVersion.indexOf(46);
                int f2 = sVersion.lastIndexOf(46);
                int f3 = sVersion.lastIndexOf(45);
                int n = f3 = f3 < 0 ? sVersion.length() : f3;
                if (f3 == -1) {
                    this.bSnapShot = true;
                }
                if (f1 > 0 && f2 > 0) {
                    try {
                        this.iVersionMajor = Integer.parseInt(sVersion.substring(0, f1));
                        this.iVersionMinor = Integer.parseInt(sVersion.substring(f1 + 1, f2));
                        this.iVersionBuild = Integer.parseInt(sVersion.substring(f2 + 1, f3));
                        break block8;
                    }
                    catch (Exception e) {
                        this.iVersionMajor = -1;
                        this.iVersionMinor = -1;
                        this.iVersionBuild = -1;
                        String msg = "Problem with 'dvversion' Maven property value.  dvversion=" + sVersion + ", f1=" + f1 + ", f2=" + f2 + ", f3=" + f3;
                        logger.debug(msg);
                        throw new DVException(msg);
                    }
                }
                logger.debug("Problem with 'dvversion' Maven property value.  dvversion=" + sVersion + ", f1=" + f1 + ", f2=" + f2 + ", f3=" + f3);
            }
            catch (DVException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Problem creating DVEng. err=" + e.getMessage();
                logger.error(msg, (Throwable)e);
                throw new DVException(msg, e);
            }
        }
    }

    @Override
    public IDVSession getDVSession() {
        return this.session;
    }

    @Override
    public final int getDeepVioletMajorVersion() {
        return this.iVersionMajor;
    }

    @Override
    public final int getDeepVioletMinorVersion() {
        return this.iVersionMinor;
    }

    @Override
    public final int getDeepVioletBuildVersion() {
        return this.iVersionBuild;
    }

    @Override
    public final String getDeepVioletStringVersion() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.iVersionMajor);
        buff.append('.');
        buff.append(this.iVersionMinor);
        buff.append('.');
        buff.append(this.iVersionBuild);
        String sSnapShot = this.bSnapShot ? "-SNAPSHOT" : "";
        buff.append(sSnapShot);
        return buff.toString();
    }

    @Override
    public final IDVCipherSuite[] getCipherSuites() throws DVException {
        ArrayList<MutableDVCipherSuite> list = new ArrayList<MutableDVCipherSuite>();
        URL url = this.session.getURL();
        try {
            HashMap<String, List<String>> allCiphers = new HashMap<String, List<String>>();
            if (this.servmeta == null) {
                return null;
            }
            if (this.servmeta.containsKey("getServerMetadataInstance", "SSLv2")) {
                allCiphers.put("SSLv2", this.servmeta.getVectorValue("getServerMetadataInstance", "SSLv2"));
            }
            if (this.servmeta.containsKey("getServerMetadataInstance", "SSLv3")) {
                allCiphers.put("SSLv3", this.servmeta.getVectorValue("getServerMetadataInstance", "SSLv3"));
            }
            if (this.servmeta.containsKey("getServerMetadataInstance", "TLSv1.0")) {
                allCiphers.put("TLSv1.0", this.servmeta.getVectorValue("getServerMetadataInstance", "TLSv1.0"));
            }
            if (this.servmeta.containsKey("getServerMetadataInstance", "TLSv1.1")) {
                allCiphers.put("TLSv1.1", this.servmeta.getVectorValue("getServerMetadataInstance", "TLSv1.1"));
            }
            if (this.servmeta.containsKey("getServerMetadataInstance", "TLSv1.2")) {
                allCiphers.put("TLSv1.2", this.servmeta.getVectorValue("getServerMetadataInstance", "TLSv1.2"));
            }
            for (String tlsVersion : allCiphers.keySet()) {
                Iterator iterator = ((List)allCiphers.get(tlsVersion)).iterator();
                while (iterator.hasNext()) {
                    String cipher;
                    String ciphernameOnly = cipher = (String)iterator.next();
                    int idx = cipher.indexOf("(0x", 0);
                    if (idx != -1) {
                        ciphernameOnly = cipher.substring(0, idx);
                    }
                    String strength = "UNKNOWN";
                    if (ciphernameOnly.length() > 0) {
                        strength = CipherSuiteUtil.getStrength(ciphernameOnly);
                        if (cipher.startsWith("No Ciphers")) {
                            strength = "";
                        }
                    }
                    MutableDVCipherSuite suite = new MutableDVCipherSuite(cipher, strength, tlsVersion);
                    list.add(suite);
                }
            }
        }
        catch (Exception e) {
            String msg = "Problem fetching ciphersuites. err=" + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new DVException(msg, e);
        }
        return list.toArray(new MutableDVCipherSuite[0]);
    }

    @Override
    public final IDVX509Certificate getCertificate() throws DVException {
        DVX509Certificate dvCert;
        try {
            X509Certificate cert = CipherSuiteUtil.getServerCertificate(this.session.getURL());
            dvCert = new DVX509Certificate(this, cert);
        }
        catch (Exception e) {
            String msg = "Problem fetching certificate. err=" + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new DVException(msg, e);
        }
        return dvCert;
    }

    @Override
    public final long writeCertificate(String file) throws DVException {
        byte[] derenccert = null;
        try {
            X509Certificate cert = CipherSuiteUtil.getServerCertificate(this.session.getURL());
            File f = new File(file);
            String path = f.getParentFile().getCanonicalPath();
            File dir = new File(path);
            if (dir.exists()) {
                if (!dir.canWrite()) {
                    DVException e = new DVException("Write certificate failed. reason=directory WRITE required.  dir=" + path);
                    throw e;
                }
            } else {
                dir.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(f);
            try {
                Base64.Encoder encoder = Base64.getEncoder();
                String cert_begin = "-----BEGIN CERTIFICATE-----\n";
                String end_cert = "\n-----END CERTIFICATE-----";
                derenccert = cert.getEncoded();
                String pemB64 = new String(encoder.encode(derenccert));
                StringBuffer pemBuff = new StringBuffer(pemB64.length());
                int ct = 0;
                for (int i = 0; i < pemB64.length(); ++i) {
                    pemBuff.append(pemB64.charAt(i));
                    if (++ct % 64 != 0) continue;
                    pemBuff.append(this.EOL);
                    ct = 0;
                }
                String pemCert = cert_begin + pemBuff.toString() + end_cert;
                out.write(pemCert.getBytes());
            }
            catch (IOException e) {
                DVException e1 = new DVException("Error writing file.  file=" + f.getAbsolutePath(), e);
                throw e1;
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (SSLHandshakeException e) {
            if (e.getMessage().indexOf("PKIX") > 0) {
                DVException e1 = new DVException("Certificate chain failed validation. err=" + e.getMessage(), e);
                throw e1;
            }
            DVException e1 = new DVException("SSLHandshakeException. err=" + e.getMessage(), e);
            throw e1;
        }
        catch (Exception e) {
            DVException e1 = new DVException("SSLHandshakeException. err=" + e.getMessage(), e);
            throw e1;
        }
        long sz = derenccert != null ? (long)derenccert.length : 0L;
        return sz;
    }

    @Override
    public boolean isDeepVioletSnapShot() {
        return this.bSnapShot;
    }
}

