/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.DVBackgroundTask;
import com.mps.deepviolet.api.DVEng;
import com.mps.deepviolet.api.DVException;
import com.mps.deepviolet.api.IDVEng;
import com.mps.deepviolet.api.IDVSession;
import com.mps.deepviolet.api.ImmutableDVHost;
import com.mps.deepviolet.api.MutableDVSession;
import com.mps.deepviolet.util.FileUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DVFactory {
    private DVFactory() {
    }

    public static final synchronized IDVSession initializeSession(URL url) throws DVException {
        ArrayList<ImmutableDVHost> list = new ArrayList<ImmutableDVHost>();
        MutableDVSession session = null;
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Socket socket = null;
        try {
            InetAddress[] addresses;
            FileUtils.createWorkingDirectory();
            socket = (SSLSocket)factory.createSocket(url.getHost(), url.getDefaultPort());
            for (InetAddress address : addresses = InetAddress.getAllByName(url.getHost())) {
                String host = address.getHostName();
                String ip = address.getHostAddress();
                String canonical = address.getCanonicalHostName();
                ImmutableDVHost dvhost = new ImmutableDVHost(host, ip, canonical, url);
                list.add(dvhost);
            }
            String soKeepalive = Boolean.toString(socket.getKeepAlive());
            String soRcvbuf = Integer.toString(socket.getReceiveBufferSize());
            String soLinger = Integer.toString(socket.getSoLinger());
            String soTimeout = Integer.toString(socket.getSoTimeout());
            String trafficClass = Integer.toString(socket.getTrafficClass());
            String clientAuthReq = Boolean.toString(((SSLSocket)socket).getNeedClientAuth());
            String clientAuthWant = Boolean.toString(((SSLSocket)socket).getWantClientAuth());
            String tcpNodelay = Boolean.toString(socket.getTcpNoDelay());
            String soReuseaddr = Boolean.toString(socket.getReuseAddress());
            String soSendbuff = Integer.toString(socket.getSendBufferSize());
            String enabledProtocols = String.join((CharSequence)",", ((SSLSocket)socket).getEnabledProtocols());
            session = new MutableDVSession(url, list.toArray(new ImmutableDVHost[0]));
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.SO_KEEPALIVE, soKeepalive);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.SO_RCVBUF, soRcvbuf);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.SO_LINGER, soLinger);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.SO_TIMEOUT, soTimeout);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.SO_REUSEADDR, soReuseaddr);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.SO_SENDBUFF, soSendbuff);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.CLIENT_AUTH_REQ, clientAuthReq);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.CLIENT_AUTH_WANT, clientAuthWant);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.TRAFFIC_CLASS, trafficClass);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.TCP_NODELAY, tcpNodelay);
            session.setSessionPropertyValue(IDVSession.SESSION_PROPERTIES.ENABLED_PROTOCOLS, enabledProtocols);
        }
        catch (Exception e) {
            throw new DVException(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return session;
    }

    public static final synchronized IDVEng getDVEng(IDVSession session) throws DVException {
        return new DVEng(session, IDVSession.CIPHER_NAME_CONVENTION.IANA);
    }

    public static final synchronized IDVEng getDVEng(IDVSession session, IDVSession.CIPHER_NAME_CONVENTION cipher_name_convention) throws DVException {
        return new DVEng(session, cipher_name_convention);
    }

    public static final synchronized IDVEng getDVEng(IDVSession session, IDVSession.CIPHER_NAME_CONVENTION cipher_name_convention, DVBackgroundTask dvtask) throws DVException {
        return new DVEng(session, cipher_name_convention, dvtask);
    }
}

