/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.CipherSuiteUtil;
import com.mps.deepviolet.api.DVException;
import com.mps.deepviolet.api.IDVEng;
import com.mps.deepviolet.api.IDVX509Certificate;
import java.io.IOException;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DVX509Certificate
implements IDVX509Certificate {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.mps.deepviolet.api.DVX509Certificate");
    private final String EOL = System.getProperty("line.separator");
    private X509Certificate cert;
    private X509Certificate[] chain;
    private DVX509Certificate[] dvChain;
    private IDVEng eng;
    private String signingAlgorithm;
    private String signingAlgorithmOID;
    private BigInteger certificateSerialNumber;
    private int iCertificateVersion;
    private String notValidBefore;
    private String notValidAfter;
    private IDVX509Certificate.ValidState iValidityState;
    private String subjectDN;
    private String issuerDN;
    private IDVX509Certificate.TrustState iTrustState;
    private boolean bSelfSignedCertificate;
    private boolean bJavaRootCertificate;
    private String certificateFingerPrint;
    private HashMap<String, String> nonCritOidMap = new HashMap();
    private HashMap<String, String> critOidMap = new HashMap();

    DVX509Certificate(IDVEng eng, X509Certificate cert) throws DVException {
        try {
            this.cert = cert;
            this.eng = eng;
            this.signingAlgorithm = cert.getSigAlgName();
            this.notValidBefore = cert.getNotBefore().toString();
            this.notValidAfter = cert.getNotAfter().toString();
            this.certificateSerialNumber = cert.getSerialNumber();
            this.subjectDN = cert.getSubjectDN().toString();
            this.issuerDN = cert.getIssuerDN().toString();
            this.signingAlgorithmOID = cert.getSigAlgOID();
            this.iCertificateVersion = cert.getVersion();
            this.iTrustState = IDVX509Certificate.TrustState.UNKNOWN;
            byte[] encx509 = cert.getEncoded();
            String sa = this.signingAlgorithm.substring(0, this.signingAlgorithm.indexOf("with"));
            this.certificateFingerPrint = CipherSuiteUtil.signerFingerprint(encx509, sa);
            try {
                try {
                    cert.checkValidity();
                    this.iValidityState = IDVX509Certificate.ValidState.VALID;
                }
                catch (CertificateNotYetValidException e) {
                    this.iValidityState = IDVX509Certificate.ValidState.NOT_YET_VALID;
                }
            }
            catch (CertificateExpiredException c) {
                this.iValidityState = IDVX509Certificate.ValidState.EXPIRED;
            }
            Set<String> oids = cert.getNonCriticalExtensionOIDs();
            if (oids != null) {
                this.assignOIDs(this.nonCritOidMap, oids);
            }
            if ((oids = cert.getCriticalExtensionOIDs()) != null) {
                this.assignOIDs(this.critOidMap, oids);
            }
            this.bSelfSignedCertificate = CipherSuiteUtil.isSelfSignedCertificate(cert);
            this.bJavaRootCertificate = CipherSuiteUtil.isJavaRootCertificateDN(cert.getIssuerDN().getName());
            this.onlineInitializationOnly();
        }
        catch (Exception e) {
            throw new DVException(e);
        }
    }

    void onlineInitializationOnly() throws DVException {
        this.assignCertificateChain();
        this.assignTrustState();
    }

    @Override
    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    @Override
    public BigInteger getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    @Override
    public String getSigningAlgorithmOID() {
        return this.signingAlgorithmOID;
    }

    @Override
    public int getCertificateVersion() {
        return this.iCertificateVersion;
    }

    @Override
    public String getNotValidBefore() {
        return this.notValidBefore;
    }

    @Override
    public String getNotValidAfter() {
        return this.notValidAfter;
    }

    @Override
    public IDVX509Certificate.ValidState getValidityState() {
        return this.iValidityState;
    }

    @Override
    public String getSubjectDN() {
        return this.subjectDN;
    }

    @Override
    public String getIssuerDN() {
        return this.issuerDN;
    }

    @Override
    public IDVX509Certificate.TrustState getTrustState() {
        return this.iTrustState;
    }

    @Override
    public boolean isSelfSignedCertificate() {
        return this.bSelfSignedCertificate;
    }

    @Override
    public boolean isJavaRootCertificate() {
        return this.bJavaRootCertificate;
    }

    @Override
    public String getCertificateFingerPrint() {
        return this.certificateFingerPrint;
    }

    @Override
    public String[] getNonCritOIDProperties() {
        Set<String> oids = this.nonCritOidMap.keySet();
        return oids.toArray(new String[0]);
    }

    @Override
    public String getNonCritPropertyValue(String key) {
        if (key == null || !this.nonCritOidMap.containsKey(key)) {
            return null;
        }
        return this.nonCritOidMap.get(key);
    }

    @Override
    public String[] getCritOIDProperties() {
        Set<String> oids = this.critOidMap.keySet();
        return oids.toArray(new String[0]);
    }

    @Override
    public String getCritPropertyValue(String key) {
        if (key == null || !this.critOidMap.containsKey(key)) {
            return null;
        }
        return this.critOidMap.get(key);
    }

    @Override
    public boolean isContainsNonCritPropertyKey(String key) {
        return this.nonCritOidMap.containsKey(key);
    }

    @Override
    public boolean isContainsCritPropertyKey(String key) {
        return this.critOidMap.containsKey(key);
    }

    @Override
    public synchronized IDVX509Certificate[] getCertificateChain() throws DVException {
        if (this.dvChain != null) {
            return this.dvChain;
        }
        ArrayList<DVX509Certificate> list = new ArrayList<DVX509Certificate>();
        for (X509Certificate lcert : this.chain) {
            list.add(new DVX509Certificate(this.eng, lcert));
        }
        this.dvChain = list.toArray(new DVX509Certificate[0]);
        return this.dvChain;
    }

    private void assignOIDs(HashMap<String, String> lmap, Set<String> OIDs) {
        for (String oid : OIDs) {
            String value = "<UNSUPPORTED>";
            try {
                value = CipherSuiteUtil.getExtensionValue(this.cert, oid);
            }
            catch (IOException e) {
                logger.error("Can't print ASN.1 value", (Throwable)e);
            }
            lmap.put(CipherSuiteUtil.getOIDKeyName(oid), value);
        }
    }

    private void assignCertificateChain() throws DVException {
        try {
            this.chain = CipherSuiteUtil.getServerCertificateChain(this.eng.getDVSession().getURL());
        }
        catch (SSLHandshakeException e) {
            if (e.getMessage().indexOf("PKIX") > 0) {
                String msg = "Certificate chain failed validation. err=" + e.getMessage();
                logger.error(msg, (Throwable)e);
                throw new DVException(msg, e);
            }
            String msg = "SSLHandshakeException. err=" + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new DVException(msg, e);
        }
        catch (Exception e) {
            String msg = "Problem fetching certificates. err=" + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new DVException(msg, e);
        }
    }

    private void assignTrustState() throws DVException {
        try {
            boolean bTrusted = CipherSuiteUtil.checkTrustedCertificate(this.chain, this.eng.getDVSession().getURL());
            this.iTrustState = bTrusted ? IDVX509Certificate.TrustState.TRUSTED : IDVX509Certificate.TrustState.UNTRUSTED;
        }
        catch (KeyStoreException e) {
            this.iTrustState = IDVX509Certificate.TrustState.UNKNOWN;
            throw new DVException("Problem accessing keystore, err=" + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            this.iTrustState = IDVX509Certificate.TrustState.UNKNOWN;
            throw new DVException("No ciphersuite available, err=" + e.getMessage(), e);
        }
        catch (UnknownHostException e) {
            this.iTrustState = IDVX509Certificate.TrustState.UNKNOWN;
            throw new DVException("Unknown host, err=" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DVException("File system problem, err=" + e.getMessage(), e);
        }
    }

    @Override
    public String toString() {
        String value;
        StringBuilder buff = new StringBuilder();
        buff.append(super.toString());
        buff.append(this.EOL);
        buff.append("SUBJECTDN");
        buff.append('=');
        buff.append(this.subjectDN);
        buff.append(this.EOL);
        buff.append("SIGNING_ALGORITHM");
        buff.append('=');
        buff.append(this.signingAlgorithm);
        buff.append(this.EOL);
        buff.append("CERTIFICATE_FINGERPRINT");
        buff.append('=');
        buff.append(this.certificateFingerPrint);
        buff.append(this.EOL);
        buff.append("ISSUERDN");
        buff.append('=');
        buff.append(this.issuerDN);
        buff.append(this.EOL);
        buff.append("VALIDITY_STATE");
        buff.append('=');
        String state = "<ERROR>";
        if (this.iValidityState == IDVX509Certificate.ValidState.EXPIRED) {
            state = "EXPIRED";
        } else if (this.iValidityState == IDVX509Certificate.ValidState.VALID) {
            state = "VALID";
        } else if (this.iValidityState == IDVX509Certificate.ValidState.NOT_YET_VALID) {
            state = "NOT_YET_VALID";
        }
        buff.append(state);
        buff.append(this.EOL);
        buff.append("TRUST_STATE");
        buff.append('=');
        state = "<ERROR>";
        if (this.iTrustState == IDVX509Certificate.TrustState.TRUSTED) {
            state = "TRUSTED";
        } else if (this.iTrustState == IDVX509Certificate.TrustState.UNKNOWN) {
            state = "UNKNOWN";
        } else if (this.iTrustState == IDVX509Certificate.TrustState.UNTRUSTED) {
            state = "UNTRUSTED";
        }
        buff.append(state);
        buff.append(this.EOL);
        buff.append("VALIDITY_NOT_VALID_BEFORE");
        buff.append('=');
        buff.append(this.notValidBefore);
        buff.append(this.EOL);
        buff.append("VALIDITY_NOT_VALID_AFTER");
        buff.append('=');
        buff.append(this.notValidAfter);
        buff.append(this.EOL);
        buff.append("CERTIFICATE_SERIAL_NUMBER");
        buff.append('=');
        buff.append(this.certificateSerialNumber);
        buff.append(this.EOL);
        buff.append("CERTIFICATE_VERSION");
        buff.append('=');
        buff.append(Integer.toString(this.iCertificateVersion));
        buff.append(this.EOL);
        buff.append("SELF_SIGNED_CERTIFICATE");
        buff.append('=');
        buff.append(Boolean.toString(this.bSelfSignedCertificate));
        buff.append(this.EOL);
        buff.append("JAVA_ROOT_CERTIFICATE");
        buff.append('=');
        buff.append(Boolean.toString(this.bJavaRootCertificate));
        buff.append(this.EOL);
        buff.append("SIGNING_ALGORITHM_OID");
        buff.append('=');
        buff.append(this.signingAlgorithmOID);
        buff.append(this.EOL);
        buff.append("CRIT_OIDS[");
        boolean fi = true;
        for (String key : this.critOidMap.keySet()) {
            value = this.critOidMap.get(key);
            if (!fi) {
                buff.append(", ");
            }
            buff.append(key);
            buff.append('=');
            buff.append(value);
            fi = false;
        }
        buff.append("]");
        buff.append(this.EOL);
        buff.append("NON_CRIT_OIDS[");
        fi = true;
        for (String key : this.nonCritOidMap.keySet()) {
            value = this.nonCritOidMap.get(key);
            if (!fi) {
                buff.append(", ");
            }
            buff.append(key);
            buff.append('=');
            buff.append(value);
            fi = false;
        }
        buff.append("]");
        buff.append(this.EOL);
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        boolean o1 = false;
        boolean o2 = false;
        boolean o3 = false;
        boolean o4 = false;
        boolean o5 = false;
        boolean o6 = false;
        boolean o7 = false;
        boolean o8 = false;
        boolean o9 = false;
        boolean o10 = false;
        boolean o11 = false;
        boolean o12 = false;
        boolean o13 = false;
        boolean o14 = false;
        boolean o15 = false;
        if (obj != null && obj instanceof IDVX509Certificate) {
            IDVX509Certificate c = (IDVX509Certificate)obj;
            o1 = this.signingAlgorithm.equals(c.getSigningAlgorithm());
            o2 = this.signingAlgorithmOID.equals(c.getSigningAlgorithmOID());
            o3 = this.iCertificateVersion == c.getCertificateVersion();
            o4 = this.notValidBefore.equals(c.getNotValidBefore());
            o5 = this.notValidAfter.equals(c.getNotValidAfter());
            o6 = this.iValidityState == c.getValidityState();
            o7 = this.subjectDN.equals(c.getSubjectDN());
            o8 = this.issuerDN.equals(c.getIssuerDN());
            o9 = this.iTrustState == c.getTrustState();
            o10 = this.bSelfSignedCertificate;
            o11 = this.bJavaRootCertificate;
            o12 = this.certificateFingerPrint.equals(c.getCertificateFingerPrint());
            o13 = true;
            for (String key : this.nonCritOidMap.keySet()) {
                if (!c.isContainsNonCritPropertyKey(key)) continue;
                o13 = false;
                break;
            }
            o14 = true;
            for (String key : this.critOidMap.keySet()) {
                if (!c.isContainsCritPropertyKey(key)) continue;
                o14 = false;
                break;
            }
            o15 = this.certificateSerialNumber.equals(c.getCertificateSerialNumber());
        }
        return o1 && o2 && o3 && o4 && o5 && o6 && o7 && o8 && o9 && o10 && o11 && o12 && o13 && o14 && o15;
    }
}

