/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.ServerMetadata;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class HostData
implements ServerMetadata {
    private HashMap<String, HashMap<String, Object>> featuremap = new HashMap();
    private URL host;
    private long timestamp;
    private long TTL = 900000L;

    public HostData(URL url) {
        this.host = url;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() > this.timestamp + this.TTL;
    }

    public void setHost(URL host) {
        this.host = host;
    }

    @Override
    public URL getHost() {
        return this.host;
    }

    public void setScalarValue(String feature, String key, String value) {
        HashMap<Object, Object> map = null;
        if (this.featuremap.containsKey(feature)) {
            map = this.featuremap.get(feature);
        } else {
            map = new HashMap();
            this.featuremap.put(feature, map);
        }
        map.put(key, value);
    }

    @Override
    public String getScalarValue(String feature, String key) {
        HashMap<Object, Object> map = null;
        if (this.featuremap.containsKey(feature)) {
            map = this.featuremap.get(feature);
        } else {
            map = new HashMap();
            this.featuremap.put(feature, map);
        }
        return this.isScalarType(feature, key) ? (String)map.get(key) : null;
    }

    public void setVectorValue(String feature, String key, String[] value) {
        HashMap<Object, Object> map = null;
        if (this.featuremap.containsKey(feature)) {
            map = this.featuremap.get(feature);
        } else {
            map = new HashMap();
            this.featuremap.put(feature, map);
        }
        map.put(key, value);
    }

    @Override
    public boolean containsKey(String feature, String key) {
        HashMap<Object, Object> map = null;
        if (this.featuremap.containsKey(feature)) {
            map = this.featuremap.get(feature);
        } else {
            map = new HashMap();
            this.featuremap.put(feature, map);
        }
        return map.containsKey(key);
    }

    @Override
    public List<String> getVectorValue(String feature, String key) {
        String[] s;
        ArrayList<String> result = new ArrayList<String>();
        HashMap<Object, Object> map = null;
        if (this.featuremap.containsKey(feature)) {
            map = this.featuremap.get(feature);
        } else {
            map = new HashMap();
            this.featuremap.put(feature, map);
        }
        for (String val : s = (String[])map.get(key)) {
            result.add(val);
        }
        return result;
    }

    @Override
    public List<String> getKeys(String feature) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<Object, Object> map = null;
        if (this.featuremap.containsKey(feature)) {
            map = this.featuremap.get(feature);
        } else {
            map = new HashMap();
            this.featuremap.put(feature, map);
        }
        Set<Object> s = map.keySet();
        Iterator<Object> i = s.iterator();
        while (i.hasNext()) {
            result.add((String)i.next());
        }
        return result;
    }

    @Override
    public boolean isScalarType(String feature, String key) {
        boolean result = false;
        HashMap<Object, Object> map = null;
        if (this.featuremap.containsKey(feature)) {
            map = this.featuremap.get(feature);
        } else {
            map = new HashMap();
            this.featuremap.put(feature, map);
        }
        if (map.containsKey(key)) {
            result = map.get(key) instanceof String;
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(2000);
        StringBuffer scalar = new StringBuffer();
        StringBuffer vector = new StringBuffer();
        for (String feature : this.featuremap.keySet()) {
            List<String> keys = this.getKeys(feature);
            for (String key : keys) {
                if (this.isScalarType(feature, key)) {
                    String value = this.getScalarValue(feature, key);
                    scalar.append(feature);
                    scalar.append(':');
                    scalar.append(key);
                    scalar.append('=');
                    scalar.append(value);
                    continue;
                }
                List<String> values = this.getVectorValue(feature, key);
                Iterator<String> v = values.iterator();
                vector.append(feature);
                vector.append(':');
                vector.append(key);
                vector.append('=');
                vector.append('{');
                boolean firsttime = true;
                while (v.hasNext()) {
                    String value = v.next();
                    if (!firsttime) {
                        vector.append(',');
                    } else {
                        firsttime = false;
                    }
                    vector.append(value);
                }
                vector.append('}');
            }
        }
        buff.append("Class=" + this.getClass().getName());
        buff.append(' ');
        buff.append("Instance=" + this.hashCode());
        buff.append(' ');
        buff.append("Scalar Values:");
        buff.append(scalar.toString());
        buff.append(' ');
        buff.append("Vector Values:");
        buff.append(vector.toString());
        buff.append(' ');
        return buff.toString();
    }
}

