/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.CipherSuiteUtil;
import com.mps.deepviolet.api.IDVHost;
import com.mps.deepviolet.api.IDVSession;
import java.net.URL;
import java.rmi.dgc.VMID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MutableDVSession
implements IDVSession {
    private VMID id;
    private IDVHost[] hosts;
    private URL url;
    private HashMap<IDVSession.SESSION_PROPERTIES, String> session_property_map = new HashMap();
    private HashMap<IDVSession.VULNERABILITY_ASSESSMENTS, String> vulnerability_assessment_map = new HashMap();
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    MutableDVSession(URL url, IDVHost[] hosts) {
        this.hosts = hosts;
        this.url = url;
        this.id = new VMID();
        try {
            this.headers = CipherSuiteUtil.getHttpResponseHeaders(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getIdentity() {
        return this.id.toString();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public IDVHost[] getHostInterfaces() {
        return this.hosts;
    }

    @Override
    public Map<String, List<String>> getHttpResponseHeaders() {
        return this.headers;
    }

    @Override
    public String getSessionPropertyValue(IDVSession.SESSION_PROPERTIES keyname) {
        return this.session_property_map.get((Object)keyname);
    }

    void setSessionPropertyValue(IDVSession.SESSION_PROPERTIES name, String value) {
        this.session_property_map.put(name, value);
    }

    @Override
    public String getVulnerabilityAssessmentValue(IDVSession.VULNERABILITY_ASSESSMENTS keyname) {
        return this.vulnerability_assessment_map.get((Object)keyname);
    }

    void setVulnerabilityAssessmentValue(IDVSession.VULNERABILITY_ASSESSMENTS name, String value) {
        this.vulnerability_assessment_map.put(name, value);
    }
}

