/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api;

import com.mps.deepviolet.api.CipherSuiteUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

class ServerHelloSSLv2 {
    int[] cipherSuites;
    String serverCertName;
    String serverCertHash;

    ServerHelloSSLv2(InputStream in) throws IOException {
        int connIdLen;
        int csLen;
        byte[] buf = new byte[2];
        CipherSuiteUtil.readFully(in, buf);
        int len = CipherSuiteUtil.dec16be(buf, 0);
        if ((len & 0x8000) == 0) {
            throw new IOException("not a SSLv2 record");
        }
        if ((len &= Short.MAX_VALUE) < 11) {
            throw new IOException("not a SSLv2 server hello");
        }
        buf = new byte[11];
        CipherSuiteUtil.readFully(in, buf);
        if (buf[0] != 4) {
            throw new IOException("not a SSLv2 server hello");
        }
        int certLen = CipherSuiteUtil.dec16be(buf, 5);
        if (len != 11 + certLen + (csLen = CipherSuiteUtil.dec16be(buf, 7)) + (connIdLen = CipherSuiteUtil.dec16be(buf, 9))) {
            throw new IOException("not a SSLv2 server hello");
        }
        if (csLen == 0 || csLen % 3 != 0) {
            throw new IOException("not a SSLv2 server hello");
        }
        byte[] cert = new byte[certLen];
        CipherSuiteUtil.readFully(in, cert);
        byte[] cs = new byte[csLen];
        CipherSuiteUtil.readFully(in, cs);
        byte[] connId = new byte[connIdLen];
        CipherSuiteUtil.readFully(in, connId);
        this.cipherSuites = new int[csLen / 3];
        int i = 0;
        int j = 0;
        while (i < csLen) {
            this.cipherSuites[j] = CipherSuiteUtil.dec24be(cs, i);
            i += 3;
            ++j;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate xc = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
            this.serverCertName = xc.getSubjectX500Principal().toString();
            this.serverCertHash = CipherSuiteUtil.doSHA1(cert);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

